/*
 * Decompiled with CFR 0.152.
 */
package kickass.converter.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kickass.converter.SourceInfo.ISourceInfo;
import kickass.converter.SourceInfo.SourceInfoType;
import kickass.converter.SourceInfo.StdSourceInfo;
import kickass.converter.analyzer.Kick3Analyzer;
import kickass.converter.file.ConverterConfig;
import kickass.converter.file.IFileConverter;
import kickass.converter.file.LineTransformer;
import kickass.lexvalues.DebugInfo;

public class KickAss3To4FileConverter
implements IFileConverter {
    ConverterConfig config;

    public KickAss3To4FileConverter(ConverterConfig converterConfig) {
        this.config = converterConfig;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(String string, String string2) throws Exception {
        Object object2;
        List<Object> list3;
        List<ISourceInfo> list2 = Kick3Analyzer.execute(string);
        HashMap<Integer, List<Object>> hashMap = new HashMap<Integer, List<Object>>();
        for (ISourceInfo iSourceInfo3 : list2) {
            void object22;
            if (iSourceInfo3.getType() == SourceInfoType.CommandEnd) {
                list3 = iSourceInfo3.getDebug();
                StdSourceInfo stdSourceInfo = new StdSourceInfo(SourceInfoType.CommandEnd, new DebugInfo(((DebugInfo)((Object)list3)).getEndLine(), ((DebugInfo)((Object)list3)).getEndPos(), ((DebugInfo)((Object)list3)).getEndLine(), ((DebugInfo)((Object)list3)).getEndPos(), ((DebugInfo)((Object)list3)).getFilename(), ((DebugInfo)((Object)list3)).getParrent()));
            }
            if ((list3 = (List)hashMap.get(object22.getDebug().getStartLine())) == null) {
                list3 = new ArrayList<void>();
                hashMap.put(object22.getDebug().getStartLine(), list3);
            }
            list3.add(object22);
        }
        Comparator comparator = (iSourceInfo, iSourceInfo2) -> Integer.compare(iSourceInfo2.getDebug().getEndPos(), iSourceInfo.getDebug().getEndPos());
        for (List<Object> list3 : hashMap.values()) {
            list3.sort(comparator);
        }
        Charset charset = this.getEncoding(new File(string));
        list3 = Files.readAllLines(Paths.get(string, new String[0]), charset);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (Object object2 : list3) {
            List list4 = (List)hashMap.get(n);
            String string3 = this.convertLine(n, (String)object2, list4);
            arrayList.add(string3);
            ++n;
        }
        BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(string, new String[0]), charset, StandardOpenOption.TRUNCATE_EXISTING);
        object2 = new PrintWriter(bufferedWriter);
        for (String string3 : arrayList) {
            ((PrintWriter)object2).println(string3);
        }
        ((PrintWriter)object2).flush();
        bufferedWriter.flush();
        ((PrintWriter)object2).close();
        bufferedWriter.close();
    }

    private String convertLine(int n, String string, List<ISourceInfo> list) {
        if (list == null) {
            return string;
        }
        LineTransformer lineTransformer = new LineTransformer(string);
        for (ISourceInfo iSourceInfo : list) {
            SourceInfoType sourceInfoType = iSourceInfo.getType();
            int n2 = iSourceInfo.getDebug().getStartPos();
            int n3 = iSourceInfo.getDebug().getEndPos();
            if (this.config.replacePcWithStar && sourceInfoType == SourceInfoType.Pc) {
                lineTransformer.replace(n2, n3, "*");
                continue;
            }
            if (this.config.insertCmdEndSemi && sourceInfoType == SourceInfoType.CommandEnd) {
                if (!this.hasExtraSourceOnLine(n3, string)) continue;
                lineTransformer.insert(n3, ";");
                continue;
            }
            if (!this.config.replacePseudoSemiWithColon || sourceInfoType != SourceInfoType.PseudoCmdSemi) continue;
            lineTransformer.replace(n2, n3, ":");
        }
        return lineTransformer.getResult();
    }

    private boolean hasExtraSourceOnLine(int n, String string) {
        while (n < string.length()) {
            int n2;
            boolean bl = string.startsWith("//", n);
            if (bl) {
                return false;
            }
            boolean bl2 = string.startsWith("/*", n);
            if (bl2) {
                n2 = string.indexOf("*/", n + 2);
                if (n2 < 0) {
                    return false;
                }
                n = n2 + 2;
                continue;
            }
            int n3 = n2 = !Character.isWhitespace(string.charAt(n)) ? 1 : 0;
            if (n2 != 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Charset getEncoding(File file) {
        Charset charset = StandardCharsets.UTF_8;
        byte[] byArray = new byte[4];
        Charset charset2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ((InputStream)fileInputStream).read(byArray, 0, byArray.length);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            return charset;
        }
        charset2 = byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65 ? StandardCharsets.UTF_8 : (byArray[0] == -2 && byArray[1] == -1 ? StandardCharsets.UTF_16BE : (byArray[0] == -1 && byArray[1] == -2 ? StandardCharsets.UTF_16LE : charset));
        return charset2;
    }
}

