/*
 * Decompiled with CFR 0.152.
 */
package kickass.converter.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineTransformer {
    private String srcLine;
    private int idx;
    private List<String> resultStringInRevOrder = new ArrayList<String>();

    public LineTransformer(String string) {
        this.srcLine = string;
        this.idx = string.length();
    }

    public void replace(int n, int n2, String string) {
        this.ensureCorrectPos(n2);
        this.acceptUntil(n2);
        this.resultStringInRevOrder.add(string);
        this.idx = n;
    }

    public void insert(int n, String string) {
        this.ensureCorrectPos(n);
        this.acceptUntil(n);
        this.resultStringInRevOrder.add(string);
    }

    private void ensureCorrectPos(int n) {
        if (n > this.idx) {
            throw new RuntimeException("Invalid position: " + n + ". You have to process the strings backwards. Idx=" + this.idx);
        }
    }

    private void acceptUntil(int n) {
        if (this.idx <= n) {
            return;
        }
        String string = this.srcLine.substring(n, this.idx);
        this.resultStringInRevOrder.add(string);
        this.idx = n;
    }

    public String getResult() {
        this.resultStringInRevOrder.add(this.srcLine.substring(0, this.idx));
        this.idx = 0;
        StringBuilder stringBuilder = new StringBuilder();
        Collections.reverse(this.resultStringInRevOrder);
        for (String string : this.resultStringInRevOrder) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

