/*
 * Decompiled with CFR 0.152.
 */
package kickass.converter.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kickass.converter.gui.util.SpringUtilities;

public class FormPanel
extends JPanel {
    private List<Consumer<Object>> updateActions = new ArrayList<Consumer<Object>>();

    public void addBoolField(String string, BooleanSupplier booleanSupplier, final Consumer<Boolean> consumer) {
        this.add(new JLabel(string));
        final JCheckBox jCheckBox = new JCheckBox();
        this.add(jCheckBox);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                consumer.accept(jCheckBox.isSelected());
            }
        });
        this.updateActions.add(object -> jCheckBox.setSelected(booleanSupplier.getAsBoolean()));
    }

    public void addTextField(String string, int n, Supplier<String> supplier, final Consumer<String> consumer) {
        this.add(new JLabel(string));
        final JTextField jTextField = new JTextField();
        jTextField.setColumns(n);
        this.add(jTextField);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                consumer.accept(jTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                consumer.accept(jTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                consumer.accept(jTextField.getText());
            }
        });
        this.updateActions.add(object -> jTextField.setText((String)supplier.get()));
    }

    public void setupLayout() {
        this.setLayout(new SpringLayout());
        int n = this.getComponentCount() / 2;
        SpringUtilities.makeCompactGrid(this, n, 2, 5, 5, 5, 5);
    }

    public void updateFields() {
        for (Consumer<Object> consumer : this.updateActions) {
            consumer.accept(null);
        }
    }
}

