/*
 * Decompiled with CFR 0.152.
 */
package kickass.lexvalues;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class DebugInfo {
    private int startLine;
    private int startPos;
    private int endLine;
    private int endPos;
    private String filename;
    private DebugInfo parrent;

    public DebugInfo(int n, int n2, int n3, int n4, String string, DebugInfo debugInfo) {
        this.startLine = n;
        this.startPos = n2;
        this.endLine = n3;
        this.endPos = n4;
        this.filename = string;
        this.parrent = debugInfo;
    }

    public DebugInfo(DebugInfo debugInfo, DebugInfo debugInfo2) {
        if (debugInfo2 == null) {
            debugInfo2 = debugInfo;
        }
        if (debugInfo == null) {
            debugInfo = debugInfo2;
        }
        this.startLine = debugInfo.startLine;
        this.startPos = debugInfo.startPos;
        this.endLine = debugInfo2.endLine;
        this.endPos = debugInfo2.endPos;
        this.filename = debugInfo.filename;
        this.parrent = debugInfo.parrent;
    }

    public String getInclusionTrace() {
        String string = System.getProperties().getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPositionString());
        stringBuffer.append(string);
        if (this.parrent != null) {
            stringBuffer.append("- included " + this.parrent.getInclusionTrace());
        }
        return stringBuffer.toString();
    }

    public String getPositionString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.startLine >= 0) {
            stringBuffer.append("at line " + (this.startLine + 1));
            if (this.startPos >= 0) {
                stringBuffer.append(", column " + (this.startPos + 1) + " ");
            }
        }
        if (this.filename != null) {
            stringBuffer.append("in " + this.filename);
        }
        return stringBuffer.toString();
    }

    public String getMarkedErrorLine() {
        String string = System.getProperties().getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.removeTabs(this.getLinesInFile(this.startLine - 3, this.startLine - 1, this.filename)));
        if (this.startPos < 0) {
            stringBuffer.append(">>>");
        }
        stringBuffer.append(this.removeTabs(this.getLinesInFile(this.startLine, this.startLine, this.filename)));
        if (this.startPos >= 0) {
            for (int i = 0; i < this.startPos; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('^' + string);
        }
        return stringBuffer.toString();
    }

    private String getLinesInFile(int n, int n2, String string) {
        String string2 = System.getProperties().getProperty("line.separator");
        try {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            for (n3 = 0; n3 < n; ++n3) {
                bufferedReader.readLine();
            }
            while (n3 <= n2) {
                stringBuffer.append(bufferedReader.readLine() + string2);
                ++n3;
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Error - End of file reached";
        }
    }

    private String removeTabs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\t') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String getFormattedErrorMessage(String string) {
        String string2 = System.getProperties().getProperty("line.separator");
        return this.getMarkedErrorLine() + string2 + "Error: " + string + string2;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public String getFilename() {
        return this.filename;
    }

    public DebugInfo getParrent() {
        return this.parrent;
    }
}

