/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;

public abstract class AbstractExternalResourceAccessor
implements ExternalResourceAccessor {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T withContent(ExternalResourceName location, boolean revalidate, ExternalResource.ContentAndMetadataAction<T> action) throws ResourceException {
        ExternalResourceReadResponse response = this.openResource(location, revalidate);
        if (response == null) {
            return null;
        }
        try {
            try {
                T t;
                block12: {
                    InputStream inputStream = response.openStream();
                    try {
                        t = action.execute(inputStream, response.getMetaData());
                        if (inputStream == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return t;
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(location.getUri(), e);
        }
    }

    @Nullable
    protected abstract ExternalResourceReadResponse openResource(ExternalResourceName var1, boolean var2) throws ResourceException;
}

