/*
 * Decompiled with CFR 0.152.
 */
package kickass.converter.gui.controllers.subdialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import kickass.converter.gui.controllers.BaseController;
import kickass.converter.gui.controllers.ConverterMainController;
import kickass.converter.gui.controllers.IDialogController;
import kickass.converter.gui.util.FormPanel;

public class AddSourceDirDialogController
extends BaseController
implements IDialogController,
ActionListener {
    public static final String ControllerId = "AddSourceDirDialogController";
    private boolean traveseSubdirs = true;
    private String sourceFileExtensions = ".asm,.lib";
    private JDialog dialog = new JDialog(this.getMainController().getMainFrame(), "Add Files from Source Folder", true);
    private FormPanel paramPanel;
    private JFileChooser fileChooser;

    public AddSourceDirDialogController(ConverterMainController converterMainController) {
        super(converterMainController);
        this.dialog.setLocationRelativeTo(this.getMainController().getMainFrame());
        JPanel jPanel = new JPanel();
        this.dialog.add(jPanel);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "North");
        this.paramPanel = new FormPanel();
        jPanel2.add(this.paramPanel);
        this.paramPanel.addBoolField("Traverse subdirectories:", () -> this.traveseSubdirs, bl -> {
            this.traveseSubdirs = bl;
        });
        this.paramPanel.addTextField("Source file extensions:", 15, () -> this.sourceFileExtensions, string -> {
            this.sourceFileExtensions = string;
        });
        this.paramPanel.setupLayout();
        this.fileChooser = new JFileChooser();
        jPanel.add((Component)this.fileChooser, "Center");
        this.fileChooser.setApproveButtonText("Add");
        this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.addActionListener(this);
        this.dialog.pack();
    }

    @Override
    public void execute() {
        this.update();
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("CancelSelection")) {
            this.dialog.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("ApproveSelection")) {
            this.dialog.setVisible(false);
            File file = this.fileChooser.getSelectedFile();
            ExtFileFilter extFileFilter = new ExtFileFilter(this.parseExensions(this.sourceFileExtensions));
            this.addFilesFromSourceDir(file, extFileFilter, this.traveseSubdirs);
            this.getMainController().update();
        }
    }

    private void addFilesFromSourceDir(File file, FileFilter fileFilter, boolean bl) {
        if (!file.isDirectory()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                if (!bl) continue;
                this.addFilesFromSourceDir(file2, fileFilter, bl);
                continue;
            }
            if (!fileFilter.accept(file2)) continue;
            this.getMainModel().files.add(file2.getAbsolutePath());
        }
    }

    @Override
    public void update() {
        this.paramPanel.updateFields();
    }

    private List<String> parseExensions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(",")) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private class ExtFileFilter
    implements FileFilter {
        private List<String> extensions;

        public ExtFileFilter(List<String> list) {
            this.extensions = list;
        }

        @Override
        public boolean accept(File file) {
            if (this.extensions.size() == 0) {
                return true;
            }
            String string = file.getAbsolutePath();
            for (String string2 : this.extensions) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
            return false;
        }
    }
}

