/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.assmbleinfo;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kickass.common.assmbleinfo.IAssembleInfoWriter;
import kickass.parsing.sourcelocation.SourceRange;

public class PrintStreamAssembleInfoWriter
implements IAssembleInfoWriter {
    private PrintStream out;
    private boolean firstField = true;
    private List<String> filenames = new ArrayList<String>();

    public PrintStreamAssembleInfoWriter(PrintStream printStream) {
        this.out = printStream;
    }

    @Override
    public void addSection(String string) {
        this.out.print('[');
        this.out.print(string);
        this.out.print(']');
        this.nextLine();
    }

    @Override
    public void addLine(String string) {
        this.addFieldSeparator();
        this.out.print(string);
        this.nextLine();
    }

    @Override
    public void addStringField(String string) {
        this.addFieldSeparator();
        this.out.print(string);
    }

    @Override
    public void addIntField(int n) {
        this.addFieldSeparator();
        this.out.print(Integer.toString(n));
    }

    @Override
    public void addIntField(Integer n) {
        this.addFieldSeparator();
        if (n != null) {
            this.out.print(n);
        }
    }

    @Override
    public void addSourceRangeField(SourceRange sourceRange) {
        this.addFieldSeparator();
        if (sourceRange == null) {
            return;
        }
        this.out.print(sourceRange.getStartLineNo());
        this.out.print(',');
        this.out.print(sourceRange.getStartLinePos());
        this.out.print(',');
        this.out.print(sourceRange.getEndLineNo());
        this.out.print(',');
        this.out.print(sourceRange.getEndLinePos());
        this.out.print(',');
        this.out.print(this.getFileIndex(sourceRange.getFileName()));
    }

    private int getFileIndex(String string) {
        Integer n = this.filenames.indexOf(string);
        if (n < 0) {
            n = this.filenames.size();
            this.filenames.add(string);
        }
        return n;
    }

    @Override
    public void registerFile(String string) {
        this.getFileIndex(string);
    }

    @Override
    public void writeFilesSection(String string) {
        this.addSection(string);
        int n = 0;
        for (String string2 : this.filenames) {
            this.addIntField(n++);
            this.addStringField(string2);
            this.nextLine();
        }
    }

    @Override
    public void nextLine() {
        this.out.println();
        this.firstField = true;
    }

    @Override
    public void close() {
        this.out.close();
    }

    private void addFieldSeparator() {
        if (!this.firstField) {
            this.out.print(';');
        }
        this.firstField = false;
    }
}

