/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.output;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kickass.nonasm.tools.tuples.Pair;
import kickass.state.EvaluationState;

public class ViceSymbolFile {
    private List<Pair<String, Integer>> symbols;

    public ViceSymbolFile(List<Pair<String, Integer>> list) {
        this.symbols = list;
    }

    public void writeFile(String string, EvaluationState evaluationState) {
        try {
            OutputStream outputStream = evaluationState.outputMgr.OpenOutputStream(string, false);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            this.writeFile(this.symbols, bufferedWriter);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            evaluationState.log.error("IO error while writing vice symbol file '" + string + "':" + iOException.getMessage());
        }
        catch (Exception exception) {
            evaluationState.log.error("Internal error while writing vice symbol file '" + string + "'. Contact the author");
            exception.printStackTrace(System.out);
        }
    }

    private void writeFile(List<Pair<String, Integer>> list, Writer writer) throws Exception {
        Object object;
        String string;
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        for (Pair<String, Integer> object2 : list) {
            ArrayList<Object> bl;
            string = object2.getA();
            object = object2.getB();
            if (string.startsWith("@")) {
                string = string.substring(1);
            }
            if ((bl = (ArrayList<Object>)hashMap.get(string)) == null) {
                bl = new ArrayList<Object>();
                hashMap.put(string, bl);
            }
            bl.add(object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            string = (String)entry.getKey();
            object = (List)entry.getValue();
            boolean bl = object.size() > 1;
            int n = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                String string2 = string;
                if (bl) {
                    string2 = string2 + "__" + n++;
                }
                String string3 = Integer.toHexString(n2);
                writer.write("al C:" + string3 + " ." + string2 + "\n");
            }
        }
    }
}

