/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.baselang;

import kickass.parsing.baselang.TokenCategory;

public class TokenType {
    private static int idCount = 0;
    public static final TokenType UnknownChar = new TokenType("UnknownChar", TokenCategory.special);
    public static final TokenType Eos = new TokenType("EndOfStream", TokenCategory.special);
    public static final TokenType SubFileToken = new TokenType("SubFileRange", TokenCategory.special);
    public static final TokenType Newline = new TokenType("Newline", TokenCategory.whitespace);
    public static final TokenType StdWhitespace = new TokenType("StdWhitespace", TokenCategory.whitespace);
    public static final TokenType Root = new TokenType("Root", TokenCategory.range);
    public static final TokenType CurlyBracketRange = new TokenType("CurlyBracketRange", TokenCategory.range);
    public static final TokenType LCBracket = new TokenType("LCBracket", TokenCategory.rangeStartOperator);
    public static final TokenType RCBracket = new TokenType("RCBracket", TokenCategory.rangeEndOperator);
    public static final TokenType SquareBracketRange = new TokenType("SquareBracketRange", TokenCategory.range);
    public static final TokenType LSBracket = new TokenType("LSBracket", TokenCategory.rangeStartOperator);
    public static final TokenType RSBracket = new TokenType("RSBracket", TokenCategory.rangeEndOperator);
    public static final TokenType ParanthesisRange = new TokenType("ParanthesisBracketRange", TokenCategory.range);
    public static final TokenType LParan = new TokenType("LParan", TokenCategory.rangeStartOperator);
    public static final TokenType RParan = new TokenType("RParan", TokenCategory.rangeEndOperator);
    public static final TokenType Id = new TokenType("Id", TokenCategory.id);
    public static final TokenType LocalLabelId = new TokenType("LocalLabelId", TokenCategory.id);
    public static final TokenType Null = new TokenType("Null", TokenCategory.value);
    public static final TokenType Boolean = new TokenType("Boolean", TokenCategory.value);
    public static final TokenType Number = new TokenType("Number", TokenCategory.value);
    public static final TokenType StringQuote = new TokenType("StringQuote", TokenCategory.value);
    public static final TokenType CharQuote = new TokenType("CharQuote", TokenCategory.value);
    public static final TokenType Hash = new TokenType("Hash", TokenCategory.operator);
    public static final TokenType Assign = new TokenType("Assign", TokenCategory.operator);
    public static final TokenType Comma = new TokenType("Comma", TokenCategory.operator);
    public static final TokenType Semi = new TokenType("Semi", TokenCategory.operator);
    public static final TokenType GreaterEqual = new TokenType("GreaterEqual", TokenCategory.operator);
    public static final TokenType LessEqual = new TokenType("LessEqual", TokenCategory.operator);
    public static final TokenType Greater = new TokenType("Greater", TokenCategory.operator);
    public static final TokenType Less = new TokenType("Less", TokenCategory.operator);
    public static final TokenType BitAnd = new TokenType("BitAnd", TokenCategory.operator);
    public static final TokenType BitOr = new TokenType("BitOr", TokenCategory.operator);
    public static final TokenType BitXor = new TokenType("BitXor", TokenCategory.operator);
    public static final TokenType ShiftLeft = new TokenType("ShiftLeft", TokenCategory.operator);
    public static final TokenType ShiftRight = new TokenType("ShiftRight", TokenCategory.operator);
    public static final TokenType Plus = new TokenType("Plus", TokenCategory.operator);
    public static final TokenType Minus = new TokenType("Minus", TokenCategory.operator);
    public static final TokenType Times = new TokenType("Times", TokenCategory.operator);
    public static final TokenType Divide = new TokenType("Divide", TokenCategory.operator);
    public static final TokenType NotEqual = new TokenType("NotEqual", TokenCategory.operator);
    public static final TokenType Equal = new TokenType("Equal", TokenCategory.operator);
    public static final TokenType And = new TokenType("And", TokenCategory.operator);
    public static final TokenType Or = new TokenType("Or", TokenCategory.operator);
    public static final TokenType Not = new TokenType("Not", TokenCategory.operator);
    public static final TokenType PlusPlus = new TokenType("PlusPlus", TokenCategory.operator);
    public static final TokenType MinusMinus = new TokenType("MinusMinus", TokenCategory.operator);
    public static final TokenType PlusEqual = new TokenType("PlusEqual", TokenCategory.operator);
    public static final TokenType MinusEqual = new TokenType("MinusEqual", TokenCategory.operator);
    public static final TokenType TimesEqual = new TokenType("TimesEqual", TokenCategory.operator);
    public static final TokenType DivideEqual = new TokenType("DivideEqual", TokenCategory.operator);
    public static final TokenType Dot = new TokenType("Dot", TokenCategory.operator);
    public static final TokenType Colon = new TokenType("Colon", TokenCategory.operator);
    public static final TokenType Questionmark = new TokenType("Questionmark", TokenCategory.operator);
    private int idNo = idCount++;
    private String name;
    private TokenCategory category;
    private TokenType rangeType;
    private TokenType rangeStartType;
    private TokenType rangeEndType;

    private TokenType(String string, TokenCategory tokenCategory) {
        this.name = string;
        this.category = tokenCategory;
    }

    private void setRangeInfo(TokenType tokenType, TokenType tokenType2, TokenType tokenType3) {
        this.rangeType = tokenType;
        this.rangeStartType = tokenType2;
        this.rangeEndType = tokenType3;
    }

    public static int getNoOfTypes() {
        return idCount;
    }

    public int getIdNo() {
        return this.idNo;
    }

    public TokenCategory getCategory() {
        return this.category;
    }

    public TokenType getRangeType() {
        return this.rangeType;
    }

    public TokenType getRangeStartType() {
        return this.rangeStartType;
    }

    public TokenType getRangeEndType() {
        return this.rangeEndType;
    }

    public String toString() {
        return this.name;
    }

    static {
        CurlyBracketRange.setRangeInfo(CurlyBracketRange, LCBracket, RCBracket);
        LCBracket.setRangeInfo(CurlyBracketRange, LCBracket, RCBracket);
        RCBracket.setRangeInfo(CurlyBracketRange, LCBracket, RCBracket);
        SquareBracketRange.setRangeInfo(SquareBracketRange, LSBracket, RSBracket);
        LSBracket.setRangeInfo(SquareBracketRange, LSBracket, RSBracket);
        RSBracket.setRangeInfo(SquareBracketRange, LSBracket, RSBracket);
        ParanthesisRange.setRangeInfo(ParanthesisRange, LParan, RParan);
        LParan.setRangeInfo(ParanthesisRange, LParan, RParan);
        RParan.setRangeInfo(ParanthesisRange, LParan, RParan);
    }
}

