/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.common.errors.AsmError;
import kickass.nonasm.util.functions.Func2;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;

public class ParamMapTailParser<NODE>
implements ITailParser<NODE> {
    private Func2<ParameterMap, SourceRange, NODE> nodeCreator;

    public ParamMapTailParser(Func2<ParameterMap, SourceRange, NODE> func2) {
        this.nodeCreator = func2;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        ParameterMap parameterMap;
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        tokenStreamList.skipWs();
        IToken iToken2 = tokenStreamList.expectType(TokenType.SquareBracketRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        IToken iToken3 = tokenStreamList.nextSkipWs();
        if (!iToken3.isEos()) {
            evaluationState.errorMgr.addError(new AsmError("Invalid extra tokens", iToken3.getSourceRange()));
        }
        if ((parameterMap = ExprParser.parseParametersMap(iToken2.getChildStream(), evaluationState, iToken2.getSourceRange())) == null) {
            return null;
        }
        return this.nodeCreator.apply(parameterMap, sourceRange);
    }
}

