/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.preprocessor.directives;

import kickass.common.errors.AsmError;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.preprocessor.IfState;
import kickass.parsing.preprocessor.PreProcessor;
import kickass.parsing.preprocessor.PreprocessorParser;
import kickass.parsing.preprocessor.directives.IPreProcessorDirective;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;

public class PpdElif
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdElif(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) {
        IfState ifState;
        EvaluationState evaluationState = this.preprocessor.getState();
        Boolean bl = PreprocessorParser.parse(tokenStreamList, evaluationState);
        if (bl == null) {
            return;
        }
        SourceRange sourceRange = iToken.getSourceRange();
        IfState ifState2 = evaluationState.preprocessorMgr.popState(sourceRange);
        if (ifState2 == null) {
            evaluationState.errorMgr.addError(new AsmError("Elif without if", sourceRange));
            return;
        }
        if (ifState2 == IfState.ifTaken) {
            ifState = IfState.unevaluatedIf;
        } else if (ifState2 == IfState.ifNotTaken) {
            ifState = bl != false ? IfState.ifTaken : IfState.ifNotTaken;
        } else if (ifState2 == IfState.unevaluatedIf) {
            ifState = IfState.unevaluatedIf;
        } else {
            evaluationState.errorMgr.addError(new AsmError("Elif without if", sourceRange));
            return;
        }
        evaluationState.preprocessorMgr.pushState(ifState, sourceRange);
    }
}

