/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.script;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java_cup.runtime.Symbol;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.baselang.TokenCategory;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokens.RangeToken;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.script.ScriptExpressionParser;
import kickass.parsing.script.symbolstreams.ListSymbolStream;
import kickass.parsing.script.symbolstreams.TokenToScriptSymbolConverter;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.Constant;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.stmt.StmtNode;
import kickass.pass.values.BooleanValue;
import kickass.state.EvaluationState;

public class ExprParser {
    private static ScriptExpressionParser parser = new ScriptExpressionParser();

    public static ExprNode parse(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (ExprNode)ExprParser.parseX(2, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    public static ExprNode parse(TokenStreamList tokenStreamList, int n, int n2, EvaluationState evaluationState) {
        return (ExprNode)ExprParser.parseX(2, tokenStreamList, n, n2, evaluationState);
    }

    public static StmtNode parseStmt(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (StmtNode)ExprParser.parseX(3, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    public static List<ExprNode> parseOptExprList(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (List)ExprParser.parseX(5, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    public static List<StmtNode> parseOptStmtList(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (List)ExprParser.parseX(7, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    public static List<String> parseOptIdList(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (List)ExprParser.parseX(9, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    public static ParameterMap parseParametersMap(TokenStreamList tokenStreamList, EvaluationState evaluationState, SourceRange sourceRange) {
        ParameterMap parameterMap = new ParameterMap(sourceRange);
        try {
            while (true) {
                tokenStreamList.skipWsAndNl();
                if (!tokenStreamList.peek().isEos()) {
                    ExprNode exprNode;
                    boolean bl;
                    TokenStreamList tokenStreamList2 = tokenStreamList.getUntilCommaSkipWsAndNl();
                    IToken iToken = tokenStreamList2.expectType(TokenType.Id, evaluationState);
                    if (iToken == null) continue;
                    String string = iToken.getStringValue();
                    tokenStreamList.skipWsAndNl();
                    boolean bl2 = bl = tokenStreamList2.peek().getType() == TokenType.Assign;
                    if (bl) {
                        tokenStreamList2.next();
                        exprNode = ExprParser.parse(tokenStreamList2, evaluationState);
                        if (exprNode == null) {
                            continue;
                        }
                    } else {
                        tokenStreamList2.skipWsAndNl();
                        if (tokenStreamList2.expectType(TokenType.Eos, evaluationState) == null) continue;
                        exprNode = new Constant(BooleanValue.trueValue, sourceRange);
                    }
                    parameterMap.addParameter(string, iToken.getSourceRange(), exprNode, evaluationState);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return parameterMap;
    }

    private static Object parseX(int n, TokenStreamList tokenStreamList, int n2, int n3, EvaluationState evaluationState) {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        arrayList.add(new Symbol(n));
        for (int i = n2 + 1; i < n3; ++i) {
            ExprParser.addSymbols(tokenStreamList.get(i), arrayList);
        }
        IToken iToken = tokenStreamList.get(n3);
        if (iToken.isEos()) {
            iToken = tokenStreamList.getTerminatingToken();
        }
        parser.setSymbolStream(new ListSymbolStream(arrayList, iToken));
        parser.setState(evaluationState);
        try {
            return ExprParser.parser.parse().value;
        }
        catch (AsmErrorException asmErrorException) {
            evaluationState.errorMgr.addError(asmErrorException.getError());
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void addSymbols(IToken iToken, List<Symbol> list) {
        TokenCategory tokenCategory = iToken.getType().getCategory();
        if (tokenCategory == TokenCategory.whitespace) {
            return;
        }
        if (tokenCategory == TokenCategory.range) {
            RangeToken rangeToken = (RangeToken)iToken;
            list.add(TokenToScriptSymbolConverter.getSymbolValue(rangeToken.getRangeStartToken()));
            for (IToken iToken2 : rangeToken.getChildren()) {
                ExprParser.addSymbols(iToken2, list);
            }
            list.add(TokenToScriptSymbolConverter.getSymbolValue(rangeToken.getRangeEndToken()));
            return;
        }
        list.add(TokenToScriptSymbolConverter.getSymbolValue(iToken));
    }
}

