/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.metanodes.ScopeNode;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentType;

public class AssertErrorCodeDirective
extends AsmDirective {
    private ExprNode testNameExpr;
    private AsmNode body;
    private SourceRange range;
    private List<AsmError> errorsFound = null;
    boolean prepassed = false;

    public AssertErrorCodeDirective(ExprNode exprNode, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.testNameExpr = exprNode;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new AssertErrorCodeDirective(this.testNameExpr, this.body, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = new SymbolScope(evaluationState.scopeMgr.getCurrentScope(), null);
        this.body = new ScopeNode(this.body, symbolScope);
        evaluationState.errorMgr.startExpectErrorsMode();
        this.body = this.body.executeMetaRegistrations(evaluationState);
        this.errorsFound = evaluationState.errorMgr.endExpectErrorsMode();
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.testNameExpr.executePrepass(evaluationState);
        evaluationState.errorMgr.startExpectErrorsMode();
        this.body = this.body.executePrepass(evaluationState);
        this.errorsFound.addAll(evaluationState.errorMgr.endExpectErrorsMode());
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Segment segment = evaluationState.segmentMgr.getCurrentSegment();
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        int n = evaluationState.callStack.getStackSize();
        Segment segment2 = new Segment("AssertError", SegmentType.input);
        segment2.initPass();
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment2);
        AsmError asmError = null;
        if (!this.errorsFound.isEmpty()) {
            asmError = this.errorsFound.get(0);
        } else {
            try {
                this.body = this.body.executePass(evaluationState);
            }
            catch (AsmErrorException asmErrorException) {
                asmError = asmErrorException.getError();
            }
        }
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
        evaluationState.callStack.popTilDepth(n);
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.testNameExpr.evaluate(evaluationState);
        if (asmError == null && !this.body.isFinished()) {
            return this;
        }
        String string = value.getString(this.range);
        String string2 = asmError != null ? string + " -- OK. | " + asmError.getMessage() : string + " -- FAILED!";
        evaluationState.sideeffectMgr.addTextOutput(string2);
        evaluationState.assertMgr.madeAssert(asmError == null);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

