/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.SegmentAssert;

public class AssertSegmentDirective
extends Directive {
    private ExprNode msgExpr;
    private String resultSegmentId;
    private String expectedSegmentId;

    public AssertSegmentDirective(ExprNode exprNode, String string, String string2, SourceRange sourceRange) {
        super(sourceRange);
        this.msgExpr = exprNode;
        this.resultSegmentId = string;
        this.expectedSegmentId = string2;
    }

    @Override
    public AsmNode copy() {
        return new AssertSegmentDirective(this.msgExpr, this.resultSegmentId, this.expectedSegmentId, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.msgExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.msgExpr.evaluate(evaluationState);
        if (value.isInvalid() || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        SegmentAssert segmentAssert = new SegmentAssert(value.getString(this.range), this.expectedSegmentId, this.resultSegmentId);
        evaluationState.segmentMgr.addAssert(segmentAssert);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

