/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.ByteOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class DataBlockDirective
extends AsmDirective {
    private int datasize;
    private List<ExprNode> datalist;

    public DataBlockDirective(int n, List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.datasize = n;
        this.datalist = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        for (ExprNode exprNode : this.datalist) {
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        byte[] byArray = new byte[this.datasize * this.datalist.size()];
        int n = 0;
        boolean bl = false;
        for (ExprNode exprNode : this.datalist) {
            Value value = exprNode.evaluate(evaluationState);
            if (value.isInvalid()) {
                n += this.datasize;
                bl = true;
                continue;
            }
            long l = value.getLong(this.range);
            for (int i = 0; i < this.datasize; ++i) {
                byArray[n++] = (byte)(l & 0xFFL);
                l >>= 8;
            }
        }
        evaluationState.segmentMgr.increaseMemoryPosition(this.datasize * this.datalist.size());
        if (bl || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(byArray, this.range, evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

