/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.ArrayList;
import java.util.List;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelConnectorNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.pass.asmnode.metanodes.ScopeAndSymbolPageNode;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.stmt.StmtNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.LabelValue;
import kickass.pass.values.ScopeArrayValue;
import kickass.pass.values.ScopeValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolTable;

public class ForDirective
extends Directive
implements ILabelConnectorNode {
    private List<StmtNode> initStmts;
    private ExprNode conditionExpr;
    private List<ExprNode> iterExprs;
    private AsmNode body;
    private String labelId;
    private SymbolScope countVarScope;
    private SymbolScope innerScope;
    private ISymbolPageIdx labelPageIdx;

    public ForDirective(List<StmtNode> list, ExprNode exprNode, List<ExprNode> list2, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.initStmts = list;
        this.conditionExpr = exprNode;
        this.iterExprs = list2;
        this.body = asmNode;
    }

    private ForDirective(List<StmtNode> list, ExprNode exprNode, List<ExprNode> list2, AsmNode asmNode, SourceRange sourceRange, SymbolScope symbolScope, SymbolScope symbolScope2, String string, ISymbolPageIdx iSymbolPageIdx) {
        super(sourceRange);
        this.initStmts = list;
        this.conditionExpr = exprNode;
        this.iterExprs = list2;
        this.labelId = string;
        this.body = asmNode;
        this.countVarScope = symbolScope;
        this.innerScope = symbolScope2;
        this.labelPageIdx = iSymbolPageIdx;
    }

    @Override
    public boolean connectToLabel(ILabelNode iLabelNode) {
        this.labelId = iLabelNode.getName();
        return true;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public AsmNode copy() {
        return new ForDirective(this.initStmts, this.conditionExpr, this.iterExprs, this.body.copy(), this.range, this.countVarScope, this.innerScope, this.labelId, this.labelPageIdx);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        this.countVarScope = new SymbolScope(symbolScope, null);
        this.innerScope = new SymbolScope(this.countVarScope, new SymbolTable());
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope);
        for (int i = 0; i < this.initStmts.size(); ++i) {
            this.initStmts.get(i).executeMetaRegistrations(evaluationState);
        }
        evaluationState.scopeMgr.setCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
        if (this.labelId != null) {
            this.labelPageIdx = evaluationState.scopeMgr.resolveSymbol(this.labelId);
            this.labelPageIdx.replaceInitializer(LabelValue.getInitializer(evaluationState, () -> new ScopeArrayValue(this.innerScope)));
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope);
        for (StmtNode object : this.initStmts) {
            object.executePrepass(evaluationState);
        }
        this.conditionExpr.executePrepass(evaluationState);
        for (ExprNode exprNode : this.iterExprs) {
            exprNode.executePrepass(evaluationState);
        }
        evaluationState.scopeMgr.setCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope.getParent());
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        IValueHolder[] iValueHolderArray;
        ArrayList<AsmNode> arrayList = new ArrayList<AsmNode>();
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        ScopeArrayValue scopeArrayValue = null;
        if (this.labelPageIdx != null) {
            iValueHolderArray = (IValueHolder[])this.labelPageIdx.getValueHolder().getWithoutSideeffect();
            scopeArrayValue = (ScopeArrayValue)iValueHolderArray.getConnectedValue();
        }
        this.evaluateStmts(this.initStmts, evaluationState);
        while (this.errorIfInvalid(this.conditionExpr.evaluate(evaluationState)).getBoolean(this.range)) {
            arrayList.add(new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput()));
            evaluationState.sideeffectMgr.clearFunctionSideOutput();
            iValueHolderArray = this.innerScope.getSymbolTable().createPage();
            AsmNode asmNode = new ScopeAndSymbolPageNode(this.body.copy(), this.innerScope, iValueHolderArray);
            asmNode = ((AsmNode)asmNode).executePass(evaluationState);
            arrayList.add(asmNode);
            if (scopeArrayValue != null) {
                scopeArrayValue.addScopeValue(new ScopeValue(this.innerScope, iValueHolderArray));
            }
            evaluationState.sideeffectMgr.clearFunctionSideOutput();
            this.evaluateExprs(this.iterExprs, evaluationState);
        }
        arrayList.add(new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput()));
        if (scopeArrayValue != null) {
            scopeArrayValue.setLoopExecuted();
        }
        return new AsmNodeList(arrayList);
    }

    private void evaluateStmts(List<StmtNode> list, EvaluationState evaluationState) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).evaluate(evaluationState);
        }
    }

    private void evaluateExprs(List<ExprNode> list, EvaluationState evaluationState) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).evaluate(evaluationState);
        }
    }

    private Value errorIfInvalid(Value value) {
        if (value.isInvalid()) {
            throw new AsmErrorException("Can't evaluate condition in first pass", this.range);
        }
        return value;
    }
}

