/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.StartOfMemoryBlockOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class MemoryBlockDirective
extends AsmDirective {
    private SourceRange Range;
    private ExprNode startAddressExpr;
    private boolean isVirtual;
    private String name;
    boolean adressNotResolvedBefore = true;

    public MemoryBlockDirective(ExprNode exprNode, String string, Boolean bl, SourceRange sourceRange) {
        super(sourceRange);
        this.startAddressExpr = exprNode;
        this.isVirtual = bl;
        this.name = string == null ? "Unnamed" : string;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.startAddressExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.startAddressExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n = value.getInt(this.Range);
        if (n < 0) {
            throw new AsmErrorException("Memory address may not be negative!", this.range);
        }
        evaluationState.segmentMgr.startMemoryBlock(n, this.range);
        if (this.adressNotResolvedBefore) {
            evaluationState.setMadeMetaProgress();
            this.adressNotResolvedBefore = false;
        }
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        boolean bl = this.isVirtual || evaluationState.segmentMgr.getCurrentSegment().isVirtual();
        return new StartOfMemoryBlockOutput(n, this.name, bl, evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

