/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.metanodes;

import java.util.List;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.metanodes.MacroInstanceRootNode;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.valueholder.VariableValueHolder;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.ScopePosition;
import kickass.state.namespace.Namespace;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;

public class MacroDefinitionRootNode
extends AsmNode {
    private List<String> argNames;
    private SourceRange range;
    private AsmNode body;
    private Namespace definitionNamespace;
    private SymbolScope innerScope;
    private SymbolTable symbolTable;
    private ISymbolPageIdx[] argSymbolIdxs;

    public MacroDefinitionRootNode(List<String> list, AsmNode asmNode, Namespace namespace, ScopePosition scopePosition, SourceRange sourceRange) {
        this.argNames = list;
        this.body = asmNode;
        this.range = sourceRange;
        this.definitionNamespace = namespace;
        this.symbolTable = new SymbolTable();
        this.innerScope = new SymbolScope(namespace.getScope(), this.symbolTable);
        this.innerScope.setScopePosition(scopePosition);
    }

    public List<String> getArgumentNames() {
        return this.argNames;
    }

    public SymbolScope getInnerScope() {
        return this.innerScope;
    }

    public MacroInstanceRootNode instantiate(List<ExprNode> list, Value value, IValueHolder[] iValueHolderArray, SourceRange sourceRange) {
        return new MacroInstanceRootNode(this.body.copy(), this.symbolTable, this.argSymbolIdxs, iValueHolderArray, this.definitionNamespace, list, value, sourceRange);
    }

    @Override
    public AsmNode copy() {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = this.innerScope;
        this.argSymbolIdxs = new ISymbolPageIdx[this.argNames.size()];
        for (int i = 0; i < this.argNames.size(); ++i) {
            String string = this.argNames.get(i);
            if (symbolScope.isDefined(string)) {
                evaluationState.errorMgr.addError(new AsmError("The symbol is already defined", this.range));
            }
            this.argSymbolIdxs[i] = symbolScope.define(string, VariableValueHolder.initializer).setStatus(SymbolStatus.defined);
        }
        SymbolScope symbolScope2 = evaluationState.scopeMgr.replaceCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope2);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.replaceCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
    }

    @Override
    public boolean isFinished() {
        return true;
    }
}

