/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.special.Function1Arg;
import kickass.pass.function.special.Function2Arg;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.ImmutableValue;

public class NumberValue
extends ImmutableValue {
    public static final NumberValue zero = new NumberValue(0.0);
    public static final NumberValue one = new NumberValue(1.0);
    public static final NumberValue invalid = new NumberValue();
    protected double value;
    protected static FunctionTable functions = new StdFunctionTable(NumberValue.getStandardFunctions());

    @Override
    public String getType() {
        return "number";
    }

    private NumberValue() {
        this.setInvalid();
    }

    public NumberValue(double d) {
        this.value = d;
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return this.isInvalid() ? "<<Invalid Number>>" : this.doubleToString(this.value);
    }

    @Override
    public boolean hasDouble() {
        return true;
    }

    @Override
    public double getDouble(SourceRange sourceRange) {
        return this.value;
    }

    @Override
    public int getInt(SourceRange sourceRange) {
        return (int)this.value;
    }

    @Override
    public long getLong(SourceRange sourceRange) {
        return (long)this.value;
    }

    private String doubleToString(double d) {
        int n = (int)d;
        return d == (double)n ? Integer.toString(n) : Double.toString(d);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    static {
        functions.add(new Function1Arg("-", invalid, (value, sourceRange) -> new NumberValue(-value.getDouble((SourceRange)sourceRange))));
        functions.add(new Function1Arg("<", invalid, (value, sourceRange) -> new NumberValue(value.getLong((SourceRange)sourceRange) & 0xFFL)));
        functions.add(new Function1Arg(">", invalid, (value, sourceRange) -> new NumberValue(value.getLong((SourceRange)sourceRange) >> 8 & 0xFFL)));
        functions.add(new Function2Arg("+", invalid, (value, value2, sourceRange) -> new NumberValue(value.getDouble((SourceRange)sourceRange) + value2.getDouble((SourceRange)sourceRange))));
        functions.add(new Function2Arg("-", invalid, (value, value2, sourceRange) -> new NumberValue(value.getDouble((SourceRange)sourceRange) - value2.getDouble((SourceRange)sourceRange))));
        functions.add(new Function2Arg("*", invalid, (value, value2, sourceRange) -> new NumberValue(value.getDouble((SourceRange)sourceRange) * value2.getDouble((SourceRange)sourceRange))));
        functions.add(new Function2Arg("/", invalid, (value, value2, sourceRange) -> new NumberValue(value.getDouble((SourceRange)sourceRange) / value2.getDouble((SourceRange)sourceRange))));
        functions.add(new Function2Arg("<=", BooleanValue.invalid, (value, value2, sourceRange) -> BooleanValue.get(value.getDouble((SourceRange)sourceRange) <= value2.getDouble((SourceRange)sourceRange))));
        functions.add(new Function2Arg(">=", BooleanValue.invalid, (value, value2, sourceRange) -> BooleanValue.get(value.getDouble((SourceRange)sourceRange) >= value2.getDouble((SourceRange)sourceRange))));
        functions.add(new Function2Arg("<", BooleanValue.invalid, (value, value2, sourceRange) -> BooleanValue.get(value.getDouble((SourceRange)sourceRange) < value2.getDouble((SourceRange)sourceRange))));
        functions.add(new Function2Arg(">", BooleanValue.invalid, (value, value2, sourceRange) -> BooleanValue.get(value.getDouble((SourceRange)sourceRange) > value2.getDouble((SourceRange)sourceRange))));
        functions.add(new Function2Arg("&", invalid, (value, value2, sourceRange) -> new NumberValue(value.getLong((SourceRange)sourceRange) & value2.getLong((SourceRange)sourceRange))));
        functions.add(new Function2Arg("|", invalid, (value, value2, sourceRange) -> new NumberValue(value.getLong((SourceRange)sourceRange) | value2.getLong((SourceRange)sourceRange))));
        functions.add(new Function2Arg("^", invalid, (value, value2, sourceRange) -> new NumberValue(value.getLong((SourceRange)sourceRange) ^ value2.getLong((SourceRange)sourceRange))));
        functions.add(new Function2Arg(">>", invalid, (value, value2, sourceRange) -> new NumberValue(value.getLong((SourceRange)sourceRange) >> (int)value2.getLong((SourceRange)sourceRange))));
        functions.add(new Function2Arg("<<", invalid, (value, value2, sourceRange) -> new NumberValue(value.getLong((SourceRange)sourceRange) << (int)value2.getLong((SourceRange)sourceRange))));
        functions.add(new Function2Arg("==", BooleanValue.invalid, (value, value2, sourceRange) -> BooleanValue.get(!value2.hasDouble() ? false : value.getDouble((SourceRange)sourceRange) == value2.getDouble((SourceRange)sourceRange))));
        functions.add(new Function2Arg("!=", BooleanValue.invalid, (value, value2, sourceRange) -> BooleanValue.get(!value2.hasDouble() ? true : value.getDouble((SourceRange)sourceRange) != value2.getDouble((SourceRange)sourceRange))));
    }
}

