/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import java.util.ArrayList;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.ImmutableValue;
import kickass.pass.values.ScopeValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;

public class ScopeArrayValue
extends ImmutableValue {
    private SymbolScope scope;
    private boolean loopExecuted = false;
    private ArrayList<ScopeValue> scopeInstances = new ArrayList();
    protected static FunctionTable functions = new StdFunctionTable(ScopeArrayValue.getStandardFunctions());

    public ScopeArrayValue(SymbolScope symbolScope) {
        this.scope = symbolScope;
    }

    public static ScopeArrayValue getInvalidValue(SymbolScope symbolScope) {
        ScopeArrayValue scopeArrayValue = new ScopeArrayValue(symbolScope);
        scopeArrayValue.setInvalid();
        return scopeArrayValue;
    }

    public void setLoopExecuted() {
        this.loopExecuted = true;
    }

    public void addScopeValue(ScopeValue scopeValue) {
        this.scopeInstances.add(scopeValue);
    }

    @Override
    public Value operatorIndex(Value value, EvaluationState evaluationState, SourceRange sourceRange) {
        boolean bl;
        if (this.isInvalid() || value.isInvalid()) {
            return ScopeValue.getInvalidValue(this.scope);
        }
        int n = value.getInt(sourceRange);
        boolean bl2 = bl = this.loopExecuted && this.scopeInstances.size() <= n;
        if (n < 0 || bl) {
            throw new AsmErrorException(new AsmError("Index out of range: " + n, sourceRange));
        }
        if (this.scopeInstances.size() <= n) {
            return ScopeValue.getInvalidValue(this.scope);
        }
        return this.scopeInstances.get(n);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public String getType() {
        return null;
    }
}

