# OGDF

The **O**pen **G**raph **D**rawing **F**ramework is a self-contained C++ class library
for the automatic layout of diagrams. OGDF offers sophisticated algorithms and
data structures to use within your own applications or scientific projects.
The library is available under the GNU General Public License.

OGDF is developed and supported by [TU Dortmund](http://ls11-www.cs.uni-dortmund.de/),
[Osnabrück University](http://www.inf.uni-osnabrueck.de/theoinf),
[University of Cologne](http://www.informatik.uni-koeln.de/ls_juenger/),
[Monash University](http://www.infotech.monash.edu.au/about/schools/caulfield/),
and [TU Ilmenau](http://www.tu-ilmenau.de/dma/).

## Shortcuts

* [How to Install](doc/build.md)
* [Porting Guide](doc/porting.md)
* [Compiler Defines](doc/defines.md)
* [Official Website](http://ogdf.net/)
* [Snapshot Reference Documentation](http://ogdf.github.io/doc/ogdf-snapshot/)

## License

This software is distributed under the terms of the GNU
General Public License v2 or v3, with special exceptions.
By installing this software you agree to these license terms.

See [LICENSE.txt](LICENSE.txt) for more information on the license and
included third-party software, like frameworks for
linear programming or unit testing.

## Copyright

All files in the OGDF distribution (except for third-party
software) are copyrighted:

Copyright (C) 1999-2018

## Note for GitHub users

OGDF is actively developed using a non-public Git repository.

The [Git repository on GitHub](https://github.com/ogdf/ogdf) is not a
mirror but contains the [official releases](http://ogdf.net/doku.php/tech:download)
and [snapshots](http://ogdf.net/doku.php/tech:download#download_snapshots)
of OGDF.
We however attempt to take care of issues and pull requests.

## Do you use OGDF?

If you use OGDF for some software project, we would be proud to mention it on
[our list of projects using OGDF](http://ogdf.net/doku.php/project:external).
In this case, please contact us.
