/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeObjectPrototype
extends NativeObject {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int Id_toSource = 8;
    private static final int MAX_PROTOTYPE_ID = 8;

    NativeObjectPrototype(Context cx, Scriptable scope, boolean sealed) {
        this.addAsPrototype(8, cx, scope, sealed);
    }

    public int methodArity(int methodId) {
        switch (methodId) {
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 0;
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        switch (methodId) {
            case 1: {
                if (thisObj != null) {
                    return f.construct(cx, scope, args);
                }
                if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
                    return new NativeObject();
                }
                return ScriptRuntime.toObject(cx, scope, args[0]);
            }
            case 2: 
            case 3: {
                if (cx.hasFeature(4)) {
                    String s = NativeObjectPrototype.toSource(cx, scope, thisObj, args);
                    int L = s.length();
                    if (L != 0 && s.charAt(0) == '(' && s.charAt(L - 1) == ')') {
                        s = s.substring(1, L - 1);
                    }
                    return s;
                }
                return NativeObjectPrototype.toString(thisObj);
            }
            case 4: {
                return thisObj;
            }
            case 5: {
                String property;
                if (args.length != 0 && thisObj.has(property = ScriptRuntime.toString(args[0]), thisObj)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 6: {
                ScriptableObject so;
                int a;
                String name;
                if (args.length != 0 && thisObj.has(name = ScriptRuntime.toString(args[0]), thisObj) && thisObj instanceof ScriptableObject && ((a = (so = (ScriptableObject)thisObj).getAttributes(name)) & 2) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 7: {
                if (args.length != 0 && args[0] instanceof Scriptable) {
                    Scriptable v = (Scriptable)args[0];
                    do {
                        if ((v = v.getPrototype()) != thisObj) continue;
                        return Boolean.TRUE;
                    } while (v != null);
                }
                return Boolean.FALSE;
            }
            case 8: {
                return NativeObjectPrototype.toSource(cx, scope, thisObj, args);
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    static String toString(Scriptable thisObj) {
        return "[object " + thisObj.getClassName() + "]";
    }

    private static String toSource(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        boolean iterating;
        boolean toplevel;
        if (cx.iterating == null) {
            toplevel = true;
            iterating = false;
            cx.iterating = new ObjToIntMap(31);
        } else {
            toplevel = false;
            iterating = cx.iterating.has(thisObj);
        }
        StringBuffer result = new StringBuffer(128);
        if (toplevel) {
            result.append("(");
        }
        result.append('{');
        try {
            if (!iterating) {
                cx.iterating.intern(thisObj);
                Object[] ids = thisObj.getIds();
                int i = 0;
                while (i < ids.length) {
                    Object value;
                    Object id;
                    if (i > 0) {
                        result.append(", ");
                    }
                    if ((id = ids[i]) instanceof Integer) {
                        int intId = (Integer)id;
                        value = thisObj.get(intId, thisObj);
                        result.append(intId);
                    } else {
                        String strId = (String)id;
                        value = thisObj.get(strId, thisObj);
                        if (ScriptRuntime.isValidIdentifierName(strId)) {
                            result.append(strId);
                        } else {
                            result.append('\'');
                            result.append(ScriptRuntime.escapeString(strId, '\''));
                            result.append('\'');
                        }
                    }
                    result.append(':');
                    result.append(ScriptRuntime.uneval(cx, scope, value));
                    ++i;
                }
            }
            Object var13_13 = null;
            if (toplevel) {
                cx.iterating = null;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (toplevel) {
                cx.iterating = null;
            }
            throw throwable;
        }
        result.append('}');
        if (toplevel) {
            result.append(')');
        }
        return result.toString();
    }

    protected String getIdName(int id) {
        switch (id) {
            case 1: {
                return "constructor";
            }
            case 2: {
                return "toString";
            }
            case 3: {
                return "toLocaleString";
            }
            case 4: {
                return "valueOf";
            }
            case 5: {
                return "hasOwnProperty";
            }
            case 6: {
                return "propertyIsEnumerable";
            }
            case 7: {
                return "isPrototypeOf";
            }
            case 8: {
                return "toSource";
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 7: {
                X = "valueOf";
                id = 4;
                break;
            }
            case 8: {
                char c = s.charAt(3);
                if (c == 'o') {
                    X = "toSource";
                    id = 8;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
                break;
            }
            case 13: {
                X = "isPrototypeOf";
                id = 7;
                break;
            }
            case 14: {
                char c = s.charAt(0);
                if (c == 'h') {
                    X = "hasOwnProperty";
                    id = 5;
                    break;
                }
                if (c != 't') break;
                X = "toLocaleString";
                id = 3;
                break;
            }
            case 20: {
                X = "propertyIsEnumerable";
                id = 6;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

