/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.ParserException;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.TokenStream;

public class Parser {
    CompilerEnvirons compilerEnv;
    private TokenStream ts;
    private IRFactory nf;
    private boolean ok;
    private ScriptOrFnNode currentScriptOrFn;
    private int nestingOfWith;
    private Decompiler decompiler;
    private String encodedSource;

    public Parser(CompilerEnvirons compilerEnv) {
        this.compilerEnv = compilerEnv;
    }

    protected Decompiler createDecompiler(CompilerEnvirons compilerEnv) {
        return new Decompiler();
    }

    public ScriptOrFnNode parse(String sourceString, String sourceLocation, int lineno) {
        this.ts = new TokenStream(this.compilerEnv, null, sourceString, sourceLocation, lineno);
        try {
            return this.parse();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public ScriptOrFnNode parse(Reader sourceReader, String sourceLocation, int lineno) throws IOException {
        this.ts = new TokenStream(this.compilerEnv, sourceReader, null, sourceLocation, lineno);
        return this.parse();
    }

    private void mustMatchToken(int toMatch, String messageId) throws IOException, ParserException {
        int tt = this.ts.getToken();
        if (tt != toMatch) {
            this.reportError(messageId);
            this.ts.ungetToken(tt);
        }
    }

    void reportError(String messageId) {
        this.ok = false;
        this.ts.reportCurrentLineError(Context.getMessage0(messageId));
        throw new ParserException();
    }

    private ScriptOrFnNode parse() throws IOException {
        Object pn;
        int baseLineno;
        int sourceStartOffset;
        block8: {
            this.decompiler = this.createDecompiler(this.compilerEnv);
            this.nf = new IRFactory(this);
            this.currentScriptOrFn = this.nf.createScript();
            this.decompiler = this.decompiler;
            sourceStartOffset = this.decompiler.getCurrentOffset();
            this.encodedSource = null;
            this.decompiler.addToken(118);
            this.ok = true;
            baseLineno = this.ts.getLineno();
            pn = this.nf.createLeaf(107);
            try {
                while (true) {
                    Object n;
                    block9: {
                        this.ts.flags |= 0x10;
                        int tt = this.ts.getToken();
                        this.ts.flags &= 0xFFFFFFEF;
                        if (tt <= 0) break block8;
                        if (tt == 87) {
                            try {
                                n = this.function(1);
                                break block9;
                            }
                            catch (ParserException e) {
                                this.ok = false;
                                break;
                            }
                        }
                        this.ts.ungetToken(tt);
                        n = this.statement();
                    }
                    this.nf.addChildToBack(pn, n);
                }
            }
            catch (StackOverflowError ex) {
                String msg = Context.getMessage0("mag.too.deep.parser.recursion");
                throw Context.reportRuntimeError(msg, this.ts.getSourceName(), this.ts.getLineno(), null, 0);
            }
        }
        if (!this.ok) {
            return null;
        }
        this.currentScriptOrFn.setSourceName(this.ts.getSourceName());
        this.currentScriptOrFn.setBaseLineno(baseLineno);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        int sourceEndOffset = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(sourceStartOffset, sourceEndOffset);
        this.nf.initScript(this.currentScriptOrFn, pn);
        if (this.compilerEnv.isGeneratingSource()) {
            this.encodedSource = this.decompiler.getEncodedSource();
        }
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    public String getEncodedSource() {
        return this.encodedSource;
    }

    public boolean eof() {
        return this.ts.eof();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parseFunctionBody() throws IOException {
        int oldflags = this.ts.flags;
        this.ts.flags &= 0xFFFFFFF3;
        this.ts.flags |= 2;
        Object pn = this.nf.createBlock(this.ts.getLineno());
        try {
            try {
                int tt;
                while ((tt = this.ts.peekToken()) > 0 && tt != 74) {
                    Object n;
                    void var3_3;
                    if (var3_3 == 87) {
                        this.ts.getToken();
                        n = this.function(1);
                    } else {
                        n = this.statement();
                    }
                    this.nf.addChildToBack(pn, n);
                }
            }
            catch (ParserException e) {
                this.ok = false;
                Object var6_7 = null;
                this.ts.flags = oldflags;
                return pn;
            }
            Object var6_6 = null;
            this.ts.flags = oldflags;
            return pn;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.ts.flags = oldflags;
            throw throwable;
        }
    }

    private Object function(int functionType) throws IOException, ParserException {
        Object pn;
        int functionSourceEnd;
        Object body;
        String name;
        int syntheticType = functionType;
        int baseLineno = this.ts.getLineno();
        Object memberExprNode = null;
        if (this.ts.matchToken(39)) {
            name = this.ts.getString();
            if (!this.ts.matchToken(75)) {
                if (this.compilerEnv.allowMemberExprAsFunctionName) {
                    this.decompiler.addName(name);
                    Object memberExprHead = this.nf.createName(name);
                    name = "";
                    memberExprNode = this.memberExprTail(false, memberExprHead);
                }
                this.mustMatchToken(75, "msg.no.paren.parms");
            }
        } else if (this.ts.matchToken(75)) {
            name = "";
        } else {
            name = "";
            if (this.compilerEnv.allowMemberExprAsFunctionName) {
                memberExprNode = this.memberExpr(false);
            }
            this.mustMatchToken(75, "msg.no.paren.parms");
        }
        if (memberExprNode != null) {
            syntheticType = 2;
            this.decompiler.addToken(78);
        }
        boolean nested = this.currentScriptOrFn.type == 87;
        FunctionNode fnNode = this.nf.createFunction(name);
        if (nested) {
            fnNode.setCheckThis();
        }
        if (nested || this.nestingOfWith > 0) {
            fnNode.setIgnoreDynamicScope();
        }
        int functionIndex = this.currentScriptOrFn.addFunction(fnNode);
        int functionSourceStart = this.decompiler.markFunctionStart(syntheticType, name);
        ScriptOrFnNode savedScriptOrFn = this.currentScriptOrFn;
        this.currentScriptOrFn = fnNode;
        int savedNestingOfWith = this.nestingOfWith;
        this.nestingOfWith = 0;
        try {
            this.decompiler.addToken(75);
            if (!this.ts.matchToken(76)) {
                boolean first = true;
                do {
                    if (!first) {
                        this.decompiler.addToken(77);
                    }
                    first = false;
                    this.mustMatchToken(39, "msg.no.parm");
                    String s = this.ts.getString();
                    if (fnNode.hasParamOrVar(s)) {
                        this.ts.reportCurrentLineWarning(Context.getMessage1("msg.dup.parms", s));
                    }
                    fnNode.addParam(s);
                    this.decompiler.addName(s);
                } while (this.ts.matchToken(77));
                this.mustMatchToken(76, "msg.no.paren.after.parms");
            }
            this.decompiler.addToken(76);
            this.mustMatchToken(73, "msg.no.brace.body");
            this.decompiler.addEOL(73);
            body = this.parseFunctionBody();
            this.mustMatchToken(74, "msg.no.brace.after.body");
            this.decompiler.addToken(74);
            functionSourceEnd = this.decompiler.markFunctionEnd(functionSourceStart);
            if (functionType != 2) {
                this.checkWellTerminatedFunction();
                if (memberExprNode == null) {
                    this.decompiler.addToken(1);
                } else {
                    this.decompiler.addEOL(70);
                }
            }
            Object var18_18 = null;
            this.currentScriptOrFn = savedScriptOrFn;
            this.nestingOfWith = savedNestingOfWith;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            this.currentScriptOrFn = savedScriptOrFn;
            this.nestingOfWith = savedNestingOfWith;
            throw throwable;
        }
        fnNode.setEncodedSourceBounds(functionSourceStart, functionSourceEnd);
        fnNode.setSourceName(this.ts.getSourceName());
        fnNode.setBaseLineno(baseLineno);
        fnNode.setEndLineno(this.ts.getLineno());
        if (memberExprNode == null) {
            pn = this.nf.initFunction(fnNode, functionIndex, body, syntheticType);
            if (functionType == 3) {
                pn = this.nf.createExprStatementNoReturn(pn, baseLineno);
            }
        } else {
            pn = this.nf.initFunction(fnNode, functionIndex, body, syntheticType);
            pn = this.nf.createAssignment(memberExprNode, pn);
            if (functionType != 2) {
                pn = this.nf.createExprStatement(pn, baseLineno);
            }
        }
        return pn;
    }

    private Object statements() throws IOException {
        int tt;
        Object pn = this.nf.createBlock(this.ts.getLineno());
        while ((tt = this.ts.peekToken()) > 0 && tt != 74) {
            this.nf.addChildToBack(pn, this.statement());
        }
        return pn;
    }

    private Object condition() throws IOException, ParserException {
        this.mustMatchToken(75, "msg.no.paren.cond");
        this.decompiler.addToken(75);
        Object pn = this.expr(false);
        this.mustMatchToken(76, "msg.no.paren.after.cond");
        this.decompiler.addToken(76);
        return pn;
    }

    private void checkWellTerminated() throws IOException, ParserException {
        int tt = this.ts.peekTokenSameLine();
        switch (tt) {
            case -1: 
            case 0: 
            case 1: 
            case 70: 
            case 74: {
                return;
            }
            case 87: {
                if (this.compilerEnv.languageVersion >= 120) break;
                return;
            }
        }
        this.reportError("msg.no.semi.stmt");
    }

    private void checkWellTerminatedFunction() throws IOException, ParserException {
        if (this.compilerEnv.languageVersion < 120) {
            return;
        }
        this.checkWellTerminated();
    }

    private String matchLabel() throws IOException, ParserException {
        int lineno = this.ts.getLineno();
        String label = null;
        int tt = this.ts.peekTokenSameLine();
        if (tt == 39) {
            this.ts.getToken();
            label = this.ts.getString();
        }
        if (lineno == this.ts.getLineno()) {
            this.checkWellTerminated();
        }
        return label;
    }

    private Object statement() throws IOException {
        try {
            return this.statementHelper();
        }
        catch (ParserException e) {
            int t;
            int lineno = this.ts.getLineno();
            while ((t = this.ts.getToken()) != 70 && t != 1 && t != 0 && t != -1) {
            }
            return this.nf.createExprStatement(this.nf.createName("error"), lineno);
        }
    }

    private Object statementHelper() throws IOException, ParserException {
        Object pn = null;
        boolean skipsemi = false;
        int tt = this.ts.getToken();
        switch (tt) {
            case 90: {
                skipsemi = true;
                this.decompiler.addToken(90);
                int lineno = this.ts.getLineno();
                Object cond = this.condition();
                this.decompiler.addEOL(73);
                Object ifTrue = this.statement();
                Object ifFalse = null;
                if (this.ts.matchToken(91)) {
                    this.decompiler.addToken(74);
                    this.decompiler.addToken(91);
                    this.decompiler.addEOL(73);
                    ifFalse = this.statement();
                }
                this.decompiler.addEOL(74);
                pn = this.nf.createIf(cond, ifTrue, ifFalse, lineno);
                break;
            }
            case 92: {
                skipsemi = true;
                this.decompiler.addToken(92);
                pn = this.nf.createSwitch(this.ts.getLineno());
                Object cur_case = null;
                this.mustMatchToken(75, "msg.no.paren.switch");
                this.decompiler.addToken(75);
                this.nf.addChildToBack(pn, this.expr(false));
                this.mustMatchToken(76, "msg.no.paren.after.switch");
                this.decompiler.addToken(76);
                this.mustMatchToken(73, "msg.no.brace.switch");
                this.decompiler.addEOL(73);
                while ((tt = this.ts.getToken()) != 74 && tt != 0) {
                    switch (tt) {
                        case 93: {
                            this.decompiler.addToken(93);
                            cur_case = this.nf.createUnary(93, this.expr(false));
                            this.decompiler.addEOL(81);
                            break;
                        }
                        case 94: {
                            cur_case = this.nf.createLeaf(94);
                            this.decompiler.addToken(94);
                            this.decompiler.addEOL(81);
                            break;
                        }
                        default: {
                            this.reportError("msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(81, "msg.no.colon.case");
                    Object case_statements = this.nf.createLeaf(107);
                    while ((tt = this.ts.peekToken()) != 74 && tt != 93 && tt != 94 && tt != 0) {
                        this.nf.addChildToBack(case_statements, this.statement());
                    }
                    this.nf.addChildToBack(cur_case, case_statements);
                    this.nf.addChildToBack(pn, cur_case);
                }
                this.decompiler.addEOL(74);
                break;
            }
            case 95: {
                skipsemi = true;
                this.decompiler.addToken(95);
                int lineno = this.ts.getLineno();
                Object cond = this.condition();
                this.decompiler.addEOL(73);
                Object body = this.statement();
                this.decompiler.addEOL(74);
                pn = this.nf.createWhile(cond, body, lineno);
                break;
            }
            case 96: {
                this.decompiler.addToken(96);
                this.decompiler.addEOL(73);
                int lineno = this.ts.getLineno();
                Object body = this.statement();
                this.decompiler.addToken(74);
                this.mustMatchToken(95, "msg.no.while.do");
                this.decompiler.addToken(95);
                Object cond = this.condition();
                pn = this.nf.createDoWhile(body, cond, lineno);
                break;
            }
            case 97: {
                Object cond;
                Object init;
                skipsemi = true;
                this.decompiler.addToken(97);
                int lineno = this.ts.getLineno();
                Object incr = null;
                this.mustMatchToken(75, "msg.no.paren.for");
                this.decompiler.addToken(75);
                tt = this.ts.peekToken();
                if (tt == 70) {
                    init = this.nf.createLeaf(106);
                } else if (tt == 100) {
                    this.ts.getToken();
                    init = this.variables(true);
                } else {
                    init = this.expr(true);
                }
                if (this.ts.matchToken(54)) {
                    this.decompiler.addToken(54);
                    cond = this.expr(false);
                } else {
                    this.mustMatchToken(70, "msg.no.semi.for");
                    this.decompiler.addToken(70);
                    cond = this.ts.peekToken() == 70 ? this.nf.createLeaf(106) : this.expr(false);
                    this.mustMatchToken(70, "msg.no.semi.for.cond");
                    this.decompiler.addToken(70);
                    incr = this.ts.peekToken() == 76 ? this.nf.createLeaf(106) : this.expr(false);
                }
                this.mustMatchToken(76, "msg.no.paren.for.ctrl");
                this.decompiler.addToken(76);
                this.decompiler.addEOL(73);
                Object body = this.statement();
                this.decompiler.addEOL(74);
                if (incr == null) {
                    pn = this.nf.createForIn(init, cond, body, lineno);
                    break;
                }
                pn = this.nf.createFor(init, cond, incr, body, lineno);
                break;
            }
            case 69: {
                int lineno = this.ts.getLineno();
                Object catchblocks = null;
                Object finallyblock = null;
                skipsemi = true;
                this.decompiler.addToken(69);
                this.decompiler.addEOL(73);
                Object tryblock = this.statement();
                this.decompiler.addEOL(74);
                catchblocks = this.nf.createLeaf(107);
                boolean sawDefaultCatch = false;
                int peek = this.ts.peekToken();
                if (peek == 102) {
                    while (this.ts.matchToken(102)) {
                        if (sawDefaultCatch) {
                            this.reportError("msg.catch.unreachable");
                        }
                        this.decompiler.addToken(102);
                        this.mustMatchToken(75, "msg.no.paren.catch");
                        this.decompiler.addToken(75);
                        this.mustMatchToken(39, "msg.bad.catchcond");
                        String varName = this.ts.getString();
                        this.decompiler.addName(varName);
                        Object catchCond = null;
                        if (this.ts.matchToken(90)) {
                            this.decompiler.addToken(90);
                            catchCond = this.expr(false);
                        } else {
                            sawDefaultCatch = true;
                        }
                        this.mustMatchToken(76, "msg.bad.catchcond");
                        this.decompiler.addToken(76);
                        this.mustMatchToken(73, "msg.no.brace.catchblock");
                        this.decompiler.addEOL(73);
                        this.nf.addChildToBack(catchblocks, this.nf.createCatch(varName, catchCond, this.statements(), this.ts.getLineno()));
                        this.mustMatchToken(74, "msg.no.brace.after.body");
                        this.decompiler.addEOL(74);
                    }
                } else if (peek != 103) {
                    this.mustMatchToken(103, "msg.try.no.catchfinally");
                }
                if (this.ts.matchToken(103)) {
                    this.decompiler.addToken(103);
                    this.decompiler.addEOL(73);
                    finallyblock = this.statement();
                    this.decompiler.addEOL(74);
                }
                pn = this.nf.createTryCatchFinally(tryblock, catchblocks, finallyblock, lineno);
                break;
            }
            case 53: {
                int lineno = this.ts.getLineno();
                this.decompiler.addToken(53);
                pn = this.nf.createThrow(this.expr(false), lineno);
                if (lineno != this.ts.getLineno()) break;
                this.checkWellTerminated();
                break;
            }
            case 98: {
                int lineno = this.ts.getLineno();
                this.decompiler.addToken(98);
                String label = this.matchLabel();
                if (label != null) {
                    this.decompiler.addName(label);
                }
                pn = this.nf.createBreak(label, lineno);
                break;
            }
            case 99: {
                int lineno = this.ts.getLineno();
                this.decompiler.addToken(99);
                String label = this.matchLabel();
                if (label != null) {
                    this.decompiler.addName(label);
                }
                pn = this.nf.createContinue(label, lineno);
                break;
            }
            case 101: {
                Object body;
                skipsemi = true;
                this.decompiler.addToken(101);
                int lineno = this.ts.getLineno();
                this.mustMatchToken(75, "msg.no.paren.with");
                this.decompiler.addToken(75);
                Object obj = this.expr(false);
                this.mustMatchToken(76, "msg.no.paren.after.with");
                this.decompiler.addToken(76);
                this.decompiler.addEOL(73);
                ++this.nestingOfWith;
                try {
                    body = this.statement();
                    Object var13_44 = null;
                    --this.nestingOfWith;
                }
                catch (Throwable throwable) {
                    Object var13_45 = null;
                    --this.nestingOfWith;
                    throw throwable;
                }
                this.decompiler.addEOL(74);
                pn = this.nf.createWith(obj, body, lineno);
                break;
            }
            case 100: {
                int lineno = this.ts.getLineno();
                pn = this.variables(false);
                if (this.ts.getLineno() != lineno) break;
                this.checkWellTerminated();
                break;
            }
            case 5: {
                Object retExpr = null;
                this.decompiler.addToken(5);
                if ((this.ts.flags & 2) == 0) {
                    this.reportError("msg.bad.return");
                }
                this.ts.flags |= 0x10;
                tt = this.ts.peekTokenSameLine();
                this.ts.flags &= ~16;
                int lineno = this.ts.getLineno();
                if (tt != 0 && tt != 1 && tt != 70 && tt != 74) {
                    retExpr = this.expr(false);
                    if (this.ts.getLineno() == lineno) {
                        this.checkWellTerminated();
                    }
                    this.ts.flags |= 4;
                } else {
                    this.ts.flags |= 8;
                }
                pn = this.nf.createReturn(retExpr, lineno);
                break;
            }
            case 73: {
                skipsemi = true;
                pn = this.statements();
                this.mustMatchToken(74, "msg.no.brace.block");
                break;
            }
            case -1: 
            case 1: 
            case 70: {
                pn = this.nf.createLeaf(106);
                skipsemi = true;
                break;
            }
            case 87: {
                pn = this.function(3);
                break;
            }
            default: {
                int lastExprType = tt;
                int tokenno = this.ts.getTokenno();
                this.ts.ungetToken(tt);
                int lineno = this.ts.getLineno();
                pn = this.expr(false);
                if (this.ts.peekToken() == 81) {
                    if (lastExprType != 39 || this.ts.getTokenno() != tokenno) {
                        this.reportError("msg.bad.label");
                    }
                    this.ts.getToken();
                    String name = this.ts.getString();
                    pn = this.nf.createLabel(name, lineno);
                    this.decompiler.addEOL(81);
                    return pn;
                }
                pn = this.nf.createExprStatement(pn, lineno);
                if (this.ts.getLineno() != lineno) break;
                this.checkWellTerminated();
                break;
            }
        }
        this.ts.matchToken(70);
        if (!skipsemi) {
            this.decompiler.addEOL(70);
        }
        return pn;
    }

    private Object variables(boolean inForInit) throws IOException, ParserException {
        Object pn = this.nf.createVariables(this.ts.getLineno());
        boolean first = true;
        this.decompiler.addToken(100);
        do {
            this.mustMatchToken(39, "msg.bad.var");
            String s = this.ts.getString();
            if (!first) {
                this.decompiler.addToken(77);
            }
            first = false;
            this.decompiler.addName(s);
            this.currentScriptOrFn.addVar(s);
            Object name = this.nf.createName(s);
            if (this.ts.matchToken(78)) {
                this.decompiler.addToken(78);
                Object init = this.assignExpr(inForInit);
                this.nf.addChildToBack(name, init);
            }
            this.nf.addChildToBack(pn, name);
        } while (this.ts.matchToken(77));
        return pn;
    }

    private Object expr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.assignExpr(inForInit);
        while (this.ts.matchToken(77)) {
            this.decompiler.addToken(77);
            pn = this.nf.createBinary(77, pn, this.assignExpr(inForInit));
        }
        return pn;
    }

    private Object assignExpr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.condExpr(inForInit);
        int tt = this.ts.peekToken();
        if (tt == 78) {
            this.ts.getToken();
            this.decompiler.addToken(78);
            pn = this.nf.createAssignment(pn, this.assignExpr(inForInit));
        } else if (tt == 79) {
            this.ts.getToken();
            int op = this.ts.getOp();
            this.decompiler.addAssignOp(op);
            pn = this.nf.createAssignmentOp(op, pn, this.assignExpr(inForInit));
        }
        return pn;
    }

    private Object condExpr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.orExpr(inForInit);
        if (this.ts.matchToken(80)) {
            this.decompiler.addToken(80);
            Object ifTrue = this.assignExpr(false);
            this.mustMatchToken(81, "msg.no.colon.cond");
            this.decompiler.addToken(81);
            Object ifFalse = this.assignExpr(inForInit);
            return this.nf.createCondExpr(pn, ifTrue, ifFalse);
        }
        return pn;
    }

    private Object orExpr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.andExpr(inForInit);
        if (this.ts.matchToken(82)) {
            this.decompiler.addToken(82);
            pn = this.nf.createBinary(82, pn, this.orExpr(inForInit));
        }
        return pn;
    }

    private Object andExpr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.bitOrExpr(inForInit);
        if (this.ts.matchToken(83)) {
            this.decompiler.addToken(83);
            pn = this.nf.createBinary(83, pn, this.andExpr(inForInit));
        }
        return pn;
    }

    private Object bitOrExpr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.bitXorExpr(inForInit);
        while (this.ts.matchToken(10)) {
            this.decompiler.addToken(10);
            pn = this.nf.createBinary(10, pn, this.bitXorExpr(inForInit));
        }
        return pn;
    }

    private Object bitXorExpr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.bitAndExpr(inForInit);
        while (this.ts.matchToken(11)) {
            this.decompiler.addToken(11);
            pn = this.nf.createBinary(11, pn, this.bitAndExpr(inForInit));
        }
        return pn;
    }

    private Object bitAndExpr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.eqExpr(inForInit);
        while (this.ts.matchToken(12)) {
            this.decompiler.addToken(12);
            pn = this.nf.createBinary(12, pn, this.eqExpr(inForInit));
        }
        return pn;
    }

    private Object eqExpr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.relExpr(inForInit);
        block9: while (true) {
            int tt = this.ts.peekToken();
            switch (tt) {
                case 13: 
                case 14: 
                case 48: 
                case 49: {
                    this.ts.getToken();
                    int decompilerToken = tt;
                    int parseToken = tt;
                    if (this.compilerEnv.languageVersion == 120) {
                        switch (tt) {
                            case 13: {
                                parseToken = 48;
                                break;
                            }
                            case 14: {
                                parseToken = 49;
                                break;
                            }
                            case 48: {
                                decompilerToken = 13;
                                break;
                            }
                            case 49: {
                                decompilerToken = 14;
                            }
                        }
                    }
                    this.decompiler.addToken(decompilerToken);
                    pn = this.nf.createBinary(parseToken, pn, this.relExpr(inForInit));
                    continue block9;
                }
            }
            break;
        }
        return pn;
    }

    private Object relExpr(boolean inForInit) throws IOException, ParserException {
        Object pn = this.shiftExpr();
        block4: while (true) {
            int tt = this.ts.peekToken();
            switch (tt) {
                case 54: {
                    if (inForInit) break block4;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 55: {
                    this.ts.getToken();
                    this.decompiler.addToken(tt);
                    pn = this.nf.createBinary(tt, pn, this.shiftExpr());
                    continue block4;
                }
            }
            break;
        }
        return pn;
    }

    private Object shiftExpr() throws IOException, ParserException {
        Object pn = this.addExpr();
        block3: while (true) {
            int tt = this.ts.peekToken();
            switch (tt) {
                case 19: 
                case 20: 
                case 21: {
                    this.ts.getToken();
                    this.decompiler.addToken(tt);
                    pn = this.nf.createBinary(tt, pn, this.addExpr());
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private Object addExpr() throws IOException, ParserException {
        int tt;
        Object pn = this.mulExpr();
        while ((tt = this.ts.peekToken()) == 22 || tt == 23) {
            this.ts.getToken();
            this.decompiler.addToken(tt);
            pn = this.nf.createBinary(tt, pn, this.mulExpr());
        }
        return pn;
    }

    private Object mulExpr() throws IOException, ParserException {
        Object pn = this.unaryExpr();
        block3: while (true) {
            int tt = this.ts.peekToken();
            switch (tt) {
                case 24: 
                case 25: 
                case 26: {
                    this.ts.getToken();
                    this.decompiler.addToken(tt);
                    pn = this.nf.createBinary(tt, pn, this.unaryExpr());
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private Object unaryExpr() throws IOException, ParserException {
        this.ts.flags |= 0x10;
        int tt = this.ts.getToken();
        this.ts.flags &= ~16;
        switch (tt) {
            case 27: 
            case 28: 
            case 33: 
            case 104: {
                this.decompiler.addToken(tt);
                return this.nf.createUnary(tt, this.unaryExpr());
            }
            case 22: {
                this.decompiler.addToken(29);
                return this.nf.createUnary(29, this.unaryExpr());
            }
            case 23: {
                this.decompiler.addToken(30);
                return this.nf.createUnary(30, this.unaryExpr());
            }
            case 84: 
            case 85: {
                this.decompiler.addToken(tt);
                return this.nf.createIncDec(tt, false, this.memberExpr(true));
            }
            case 32: {
                this.decompiler.addToken(32);
                return this.nf.createUnary(32, this.unaryExpr());
            }
            case -1: {
                break;
            }
            default: {
                this.ts.ungetToken(tt);
                int lineno = this.ts.getLineno();
                Object pn = this.memberExpr(true);
                int peeked = this.ts.peekToken();
                if ((peeked == 84 || peeked == 85) && this.ts.getLineno() == lineno) {
                    int pf = this.ts.getToken();
                    this.decompiler.addToken(pf);
                    return this.nf.createIncDec(pf, true, pn);
                }
                return pn;
            }
        }
        return this.nf.createName("err");
    }

    private Object argumentList(Object listNode) throws IOException, ParserException {
        this.ts.flags |= 0x10;
        boolean matched = this.ts.matchToken(76);
        this.ts.flags &= ~16;
        if (!matched) {
            boolean first = true;
            do {
                if (!first) {
                    this.decompiler.addToken(77);
                }
                first = false;
                this.nf.addChildToBack(listNode, this.assignExpr(false));
            } while (this.ts.matchToken(77));
            this.mustMatchToken(76, "msg.no.paren.arg");
        }
        this.decompiler.addToken(76);
        return listNode;
    }

    private Object memberExpr(boolean allowCallSyntax) throws IOException, ParserException {
        Object pn;
        this.ts.flags |= 0x10;
        int tt = this.ts.peekToken();
        this.ts.flags &= ~16;
        if (tt == 31) {
            this.ts.getToken();
            this.decompiler.addToken(31);
            pn = this.nf.createLeaf(31);
            this.nf.addChildToBack(pn, this.memberExpr(false));
            if (this.ts.matchToken(75)) {
                this.decompiler.addToken(75);
                pn = this.argumentList(pn);
            }
            if ((tt = this.ts.peekToken()) == 73) {
                this.nf.addChildToBack(pn, this.primaryExpr());
            }
        } else {
            pn = this.primaryExpr();
        }
        return this.memberExprTail(allowCallSyntax, pn);
    }

    /*
     * WARNING - void declaration
     */
    private Object memberExprTail(boolean allowCallSyntax, Object pn) throws IOException, ParserException {
        int tt;
        while ((tt = this.ts.getToken()) > 0) {
            void var3_3;
            if (var3_3 == 86) {
                this.decompiler.addToken(86);
                this.mustMatchToken(39, "msg.no.name.after.dot");
                String s = this.ts.getString();
                this.decompiler.addName(s);
                pn = this.nf.createBinary(86, pn, this.nf.createName(this.ts.getString()));
                continue;
            }
            if (var3_3 == 71) {
                this.decompiler.addToken(71);
                pn = this.nf.createBinary(71, pn, this.expr(false));
                this.mustMatchToken(72, "msg.no.bracket.index");
                this.decompiler.addToken(72);
                continue;
            }
            if (allowCallSyntax && var3_3 == 75) {
                pn = this.nf.createUnary(38, pn);
                this.decompiler.addToken(75);
                pn = this.argumentList(pn);
                continue;
            }
            this.ts.ungetToken((int)var3_3);
            break;
        }
        return pn;
    }

    private Object primaryExpr() throws IOException, ParserException {
        this.ts.flags |= 0x10;
        int tt = this.ts.getToken();
        this.ts.flags &= ~16;
        switch (tt) {
            case 87: {
                return this.function(2);
            }
            case 71: {
                this.decompiler.addToken(71);
                Object pn = this.nf.createLeaf(108);
                this.ts.flags |= 0x10;
                boolean matched = this.ts.matchToken(72);
                this.ts.flags &= ~16;
                if (!matched) {
                    boolean first = true;
                    do {
                        this.ts.flags |= 0x10;
                        tt = this.ts.peekToken();
                        this.ts.flags &= ~16;
                        if (!first) {
                            this.decompiler.addToken(77);
                        } else {
                            first = false;
                        }
                        if (tt == 72) break;
                        if (tt == 77) {
                            this.nf.addChildToBack(pn, this.nf.createLeaf(61));
                            continue;
                        }
                        this.nf.addChildToBack(pn, this.assignExpr(false));
                    } while (this.ts.matchToken(77));
                    this.mustMatchToken(72, "msg.no.bracket.arg");
                }
                this.decompiler.addToken(72);
                return this.nf.createArrayLiteral(pn);
            }
            case 73: {
                Object pn = this.nf.createLeaf(109);
                this.decompiler.addToken(73);
                if (!this.ts.matchToken(74)) {
                    boolean first = true;
                    block19: do {
                        Object property;
                        if (!first) {
                            this.decompiler.addToken(77);
                        } else {
                            first = false;
                        }
                        tt = this.ts.getToken();
                        switch (tt) {
                            case 39: 
                            case 41: {
                                String s = this.ts.getString();
                                this.decompiler.addName(s);
                                property = this.nf.createString(this.ts.getString());
                                break;
                            }
                            case 40: {
                                double n = this.ts.getNumber();
                                this.decompiler.addNumber(n);
                                property = this.nf.createNumber(n);
                                break;
                            }
                            case 74: {
                                this.ts.ungetToken(tt);
                                break block19;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block19;
                            }
                        }
                        this.mustMatchToken(81, "msg.no.colon.prop");
                        this.decompiler.addToken(109);
                        this.nf.addChildToBack(pn, property);
                        this.nf.addChildToBack(pn, this.assignExpr(false));
                    } while (this.ts.matchToken(77));
                    this.mustMatchToken(74, "msg.no.brace.prop");
                }
                this.decompiler.addToken(74);
                return this.nf.createObjectLiteral(pn);
            }
            case 75: {
                this.decompiler.addToken(75);
                Object pn = this.expr(false);
                this.decompiler.addToken(76);
                this.mustMatchToken(76, "msg.no.paren");
                return pn;
            }
            case 39: {
                String name = this.ts.getString();
                this.decompiler.addName(name);
                return this.nf.createName(name);
            }
            case 40: {
                double n = this.ts.getNumber();
                this.decompiler.addNumber(n);
                return this.nf.createNumber(n);
            }
            case 41: {
                String s = this.ts.getString();
                this.decompiler.addString(s);
                return this.nf.createString(s);
            }
            case 50: {
                String flags = this.ts.regExpFlags;
                this.ts.regExpFlags = null;
                String re = this.ts.getString();
                this.decompiler.addRegexp(re, flags);
                int index = this.currentScriptOrFn.addRegexp(re, flags);
                return this.nf.createRegExp(index);
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                this.decompiler.addToken(tt);
                return this.nf.createLeaf(tt);
            }
            case 105: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return null;
    }
}

