# debug_assert[ ![Download](https://api.bintray.com/packages/manu343726/conan-packages/debug_assert%3AManu343726/images/download.svg) ](https://bintray.com/manu343726/conan-packages/debug_assert%3AManu343726/_latestVersion)

debug_assert is a simple, C++11, header-only library that provides a very flexible `DEBUG_ASSERT()` macro.
How many times did you write an assertion macro yourself, because `assert()` is controlled globally and cannot be enabled for certain parts of the program only?
This library solves the problem by providing a flexible, modular assertion macro.

## Features

* No dependencies. It only requires `std::abort()` and - unless `DEBUG_ASSERT_NO_STDIO` is defined - `std::fprintf()`.
* Single, small header file that just needs to be copied into your own project.
* Customizable assertion handling - assertion failure will call a user-defined function, with user-defined arguments.
* Modular - enable or disable assertions for different parts of the same program.
* Support for levels - give levels to your assertion macro and only enable certain levels of assertions.
* Little preprocessor use - just a single assertion macro which is needed to get the stringified expression and source location. Enabling/Disabling is controlled by compile time programming instead of preprocessor conditionals.
* Fast - even though a disabled assertion will still expand to something,
there is no overhead with even basic optimizations enabled and very little without optimization (just the code to read `__FILE__` and `__LINE__`). To be precise: It will only evaluate the assertion expression if the assertion is enabled!

## Overview

The basic usage of the library is like so:

```cpp
DEBUG_ASSERT(1 + 1 == 2, my_module{}); // basic
DEBUG_ASSERT(1 + 1 == 2, my_module{}, debug_assert::level<2>{}); // with level
```

Where `my_module` is a user-defined tag type that will both control the assertion level and the handler code.
It looks like this:

```cpp
struct my_module
: debug_assert::default_handler, // use the default handler
  debug_assert::set_level<-1> // level -1, i.e. all assertions, 0 would mean none, 1 would be level 1, 2 level 2 or lower,...
{};
```

A module handler must have `static` function `handle()` that takes a `debug_assert::source_location`, the stringified expression and any additional arguments you pass to `DEBUG_ASSERT()` (besides the `debug_assert::level`).

See `example.cpp` for more information and [read the blogpost](https://foonathan.github.io/blog/2016/09/16/assertions.html).

### CMake

For convenience you can also use CMake to setup the include directory and have options that map to the customizable macros.
Simple call `add_subdirectory(path/to/debug_assert)` and then `target_link_libraries(my_target PUBLIC debug_assert)`.
It will not actually build something, only setup the flags.
Note that it will not enable C++11 support.
The options are named like the macros.

## Documentation

> Generated by [standardese](https://github.com/foonathan/standardese).

{{ standardese_doc $file commonmark }}

## Acknowledgements

Thanks a lot to [@Manu343726](https://github.com/Manu343726), [@verri](https://github.com/verri) and [@pfultz2](https://github.com/pfultz2).

