/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.util.List;
import nxt.Block;
import nxt.BlockImpl;
import nxt.NxtException;
import nxt.Transaction;
import nxt.TransactionImpl;
import nxt.db.DerivedDbTable;
import nxt.peer.Peer;
import nxt.util.Observable;
import org.json.simple.JSONObject;

public interface BlockchainProcessor
extends Observable<Block, Event> {
    public Peer getLastBlockchainFeeder();

    public int getLastBlockchainFeederHeight();

    public boolean isScanning();

    public boolean isDownloading();

    public boolean isProcessingBlock();

    public int getMinRollbackHeight();

    public int getInitialScanHeight();

    public void processPeerBlock(JSONObject var1) throws NxtException;

    public void fullReset();

    public void scan(int var1, boolean var2);

    public void fullScanWithShutdown();

    public void setGetMoreBlocks(boolean var1);

    public List<? extends Block> popOffTo(int var1);

    public void registerDerivedTable(DerivedDbTable var1);

    public void trimDerivedTables();

    public int restorePrunedData();

    public Transaction restorePrunedTransaction(long var1);

    public static class BlockOutOfOrderException
    extends BlockNotAcceptedException {
        BlockOutOfOrderException(String string, BlockImpl blockImpl) {
            super(string, blockImpl);
        }
    }

    public static class TransactionNotAcceptedException
    extends BlockNotAcceptedException {
        private final TransactionImpl transaction;

        TransactionNotAcceptedException(String string, TransactionImpl transactionImpl) {
            super(string, transactionImpl.getBlock());
            this.transaction = transactionImpl;
        }

        TransactionNotAcceptedException(Throwable throwable, TransactionImpl transactionImpl) {
            super(throwable, transactionImpl.getBlock());
            this.transaction = transactionImpl;
        }

        public TransactionImpl getTransaction() {
            return this.transaction;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + ", transaction " + this.transaction.getStringId() + " " + this.transaction.getJSONObject().toJSONString();
        }
    }

    public static class BlockNotAcceptedException
    extends NxtException {
        private final BlockImpl block;

        BlockNotAcceptedException(String string, BlockImpl blockImpl) {
            super(string);
            this.block = blockImpl;
        }

        BlockNotAcceptedException(Throwable throwable, BlockImpl blockImpl) {
            super(throwable);
            this.block = blockImpl;
        }

        @Override
        public String getMessage() {
            return this.block == null ? super.getMessage() : super.getMessage() + ", block " + this.block.getStringId() + " " + this.block.getJSONObject().toJSONString();
        }
    }

    public static enum Event {
        BLOCK_PUSHED,
        BLOCK_POPPED,
        BLOCK_GENERATED,
        BLOCK_SCANNED,
        RESCAN_BEGIN,
        RESCAN_END,
        BEFORE_BLOCK_ACCEPT,
        AFTER_BLOCK_ACCEPT,
        BEFORE_BLOCK_APPLY,
        AFTER_BLOCK_APPLY;

    }
}

