/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Attachment;
import nxt.Block;
import nxt.BlockchainImpl;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.CurrencyBuyOffer;
import nxt.CurrencyExchangeOffer;
import nxt.CurrencyFounder;
import nxt.CurrencyMint;
import nxt.CurrencyTransfer;
import nxt.CurrencyType;
import nxt.Exchange;
import nxt.Nxt;
import nxt.Shuffling;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class Currency {
    private static final DbKey.LongKeyFactory<Currency> currencyDbKeyFactory = new DbKey.LongKeyFactory<Currency>("id"){

        @Override
        public DbKey newKey(Currency currency) {
            return currency.dbKey == null ? this.newKey(currency.currencyId) : currency.dbKey;
        }
    };
    private static final VersionedEntityDbTable<Currency> currencyTable = new VersionedEntityDbTable<Currency>("currency", currencyDbKeyFactory, "code,name,description"){

        @Override
        protected Currency load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Currency(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Currency currency) throws SQLException {
            currency.save(connection);
        }

        @Override
        public String defaultSort() {
            return " ORDER BY creation_height DESC ";
        }
    };
    private static final DbKey.LongKeyFactory<CurrencySupply> currencySupplyDbKeyFactory = new DbKey.LongKeyFactory<CurrencySupply>("id"){

        @Override
        public DbKey newKey(CurrencySupply currencySupply) {
            return currencySupply.dbKey;
        }
    };
    private static final VersionedEntityDbTable<CurrencySupply> currencySupplyTable = new VersionedEntityDbTable<CurrencySupply>("currency_supply", currencySupplyDbKeyFactory){

        @Override
        protected CurrencySupply load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new CurrencySupply(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, CurrencySupply currencySupply) throws SQLException {
            currencySupply.save(connection);
        }
    };
    private static final Listeners<Currency, Event> listeners = new Listeners();
    private final long currencyId;
    private final DbKey dbKey;
    private final long accountId;
    private final String name;
    private final String code;
    private final String description;
    private final int type;
    private final long maxSupply;
    private final long reserveSupply;
    private final int creationHeight;
    private final int issuanceHeight;
    private final long minReservePerUnitNQT;
    private final int minDifficulty;
    private final int maxDifficulty;
    private final byte ruleset;
    private final byte algorithm;
    private final byte decimals;
    private final long initialSupply;
    private CurrencySupply currencySupply;

    public static boolean addListener(Listener<Currency> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Currency> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static DbIterator<Currency> getAllCurrencies(int n, int n2) {
        return currencyTable.getAll(n, n2);
    }

    public static int getCount() {
        return currencyTable.getCount();
    }

    public static Currency getCurrency(long l) {
        return (Currency)currencyTable.get(currencyDbKeyFactory.newKey(l));
    }

    public static Currency getCurrencyByName(String string) {
        return (Currency)currencyTable.getBy(new DbClause.StringClause("name_lower", string.toLowerCase(Locale.ROOT)));
    }

    public static Currency getCurrencyByCode(String string) {
        return (Currency)currencyTable.getBy(new DbClause.StringClause("code", string.toUpperCase(Locale.ROOT)));
    }

    public static DbIterator<Currency> getCurrencyIssuedBy(long l, int n, int n2) {
        return currencyTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public static DbIterator<Currency> searchCurrencies(String string, int n, int n2) {
        return currencyTable.search(string, DbClause.EMPTY_CLAUSE, n, n2, " ORDER BY ft.score DESC, currency.creation_height DESC ");
    }

    static void addCurrency(AccountLedger.LedgerEvent ledgerEvent, long l, Transaction transaction, Account account, Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance) {
        Currency currency = Currency.getCurrencyByCode(monetarySystemCurrencyIssuance.getCode());
        if (currency != null) {
            currency.delete(ledgerEvent, l, account);
        }
        if ((currency = Currency.getCurrencyByCode(monetarySystemCurrencyIssuance.getName())) != null) {
            currency.delete(ledgerEvent, l, account);
        }
        if ((currency = Currency.getCurrencyByName(monetarySystemCurrencyIssuance.getName())) != null) {
            currency.delete(ledgerEvent, l, account);
        }
        if ((currency = Currency.getCurrencyByName(monetarySystemCurrencyIssuance.getCode())) != null) {
            currency.delete(ledgerEvent, l, account);
        }
        Currency currency2 = new Currency(transaction, monetarySystemCurrencyIssuance);
        currencyTable.insert(currency2);
        if (currency2.is(CurrencyType.MINTABLE) || currency2.is(CurrencyType.RESERVABLE)) {
            CurrencySupply currencySupply = currency2.getSupplyData();
            currencySupply.currentSupply = monetarySystemCurrencyIssuance.getInitialSupply();
            currencySupplyTable.insert(currencySupply);
        }
    }

    static void init() {
    }

    private Currency(Transaction transaction, Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance) {
        this.currencyId = transaction.getId();
        this.dbKey = currencyDbKeyFactory.newKey(this.currencyId);
        this.accountId = transaction.getSenderId();
        this.name = monetarySystemCurrencyIssuance.getName();
        this.code = monetarySystemCurrencyIssuance.getCode();
        this.description = monetarySystemCurrencyIssuance.getDescription();
        this.type = monetarySystemCurrencyIssuance.getType();
        this.initialSupply = monetarySystemCurrencyIssuance.getInitialSupply();
        this.reserveSupply = monetarySystemCurrencyIssuance.getReserveSupply();
        this.maxSupply = monetarySystemCurrencyIssuance.getMaxSupply();
        this.creationHeight = Nxt.getBlockchain().getHeight();
        this.issuanceHeight = monetarySystemCurrencyIssuance.getIssuanceHeight();
        this.minReservePerUnitNQT = monetarySystemCurrencyIssuance.getMinReservePerUnitNQT();
        this.minDifficulty = monetarySystemCurrencyIssuance.getMinDifficulty();
        this.maxDifficulty = monetarySystemCurrencyIssuance.getMaxDifficulty();
        this.ruleset = monetarySystemCurrencyIssuance.getRuleset();
        this.algorithm = monetarySystemCurrencyIssuance.getAlgorithm();
        this.decimals = monetarySystemCurrencyIssuance.getDecimals();
    }

    private Currency(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.currencyId = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.accountId = resultSet.getLong("account_id");
        this.name = resultSet.getString("name");
        this.code = resultSet.getString("code");
        this.description = resultSet.getString("description");
        this.type = resultSet.getInt("type");
        this.initialSupply = resultSet.getLong("initial_supply");
        this.reserveSupply = resultSet.getLong("reserve_supply");
        this.maxSupply = resultSet.getLong("max_supply");
        this.creationHeight = resultSet.getInt("creation_height");
        this.issuanceHeight = resultSet.getInt("issuance_height");
        this.minReservePerUnitNQT = resultSet.getLong("min_reserve_per_unit_nqt");
        this.minDifficulty = resultSet.getByte("min_difficulty") & 0xFF;
        this.maxDifficulty = resultSet.getByte("max_difficulty") & 0xFF;
        this.ruleset = resultSet.getByte("ruleset");
        this.algorithm = resultSet.getByte("algorithm");
        this.decimals = resultSet.getByte("decimals");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO currency (id, account_id, name, name_lower, code, description, type, initial_supply, reserve_supply, max_supply, creation_height, issuance_height, min_reserve_per_unit_nqt, min_difficulty, max_difficulty, ruleset, algorithm, decimals, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.currencyId);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setString(++n, this.name);
            preparedStatement.setString(++n, this.name.toLowerCase(Locale.ROOT));
            preparedStatement.setString(++n, this.code);
            preparedStatement.setString(++n, this.description);
            preparedStatement.setInt(++n, this.type);
            preparedStatement.setLong(++n, this.initialSupply);
            preparedStatement.setLong(++n, this.reserveSupply);
            preparedStatement.setLong(++n, this.maxSupply);
            preparedStatement.setInt(++n, this.creationHeight);
            preparedStatement.setInt(++n, this.issuanceHeight);
            preparedStatement.setLong(++n, this.minReservePerUnitNQT);
            preparedStatement.setByte(++n, (byte)this.minDifficulty);
            preparedStatement.setByte(++n, (byte)this.maxDifficulty);
            preparedStatement.setByte(++n, this.ruleset);
            preparedStatement.setByte(++n, this.algorithm);
            preparedStatement.setByte(++n, this.decimals);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.currencyId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    public long getInitialSupply() {
        return this.initialSupply;
    }

    public long getCurrentSupply() {
        if (!this.is(CurrencyType.RESERVABLE) && !this.is(CurrencyType.MINTABLE)) {
            return this.initialSupply;
        }
        if (this.getSupplyData() == null) {
            return 0L;
        }
        return this.currencySupply.currentSupply;
    }

    public long getReserveSupply() {
        return this.reserveSupply;
    }

    public long getMaxSupply() {
        return this.maxSupply;
    }

    public int getCreationHeight() {
        return this.creationHeight;
    }

    public int getIssuanceHeight() {
        return this.issuanceHeight;
    }

    public long getMinReservePerUnitNQT() {
        return this.minReservePerUnitNQT;
    }

    public int getMinDifficulty() {
        return this.minDifficulty;
    }

    public int getMaxDifficulty() {
        return this.maxDifficulty;
    }

    public byte getRuleset() {
        return this.ruleset;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public byte getDecimals() {
        return this.decimals;
    }

    public long getCurrentReservePerUnitNQT() {
        if (!this.is(CurrencyType.RESERVABLE) || this.getSupplyData() == null) {
            return 0L;
        }
        return this.currencySupply.currentReservePerUnitNQT;
    }

    public boolean isActive() {
        return this.issuanceHeight <= BlockchainImpl.getInstance().getHeight();
    }

    private CurrencySupply getSupplyData() {
        if (!this.is(CurrencyType.RESERVABLE) && !this.is(CurrencyType.MINTABLE)) {
            return null;
        }
        if (this.currencySupply == null) {
            this.currencySupply = (CurrencySupply)currencySupplyTable.get(currencyDbKeyFactory.newKey(this));
            if (this.currencySupply == null) {
                this.currencySupply = new CurrencySupply(this);
            }
        }
        return this.currencySupply;
    }

    static void increaseReserve(AccountLedger.LedgerEvent ledgerEvent, long l, Account account, long l2, long l3) {
        CurrencySupply currencySupply;
        Currency currency = Currency.getCurrency(l2);
        account.addToBalanceNQT(ledgerEvent, l, -Math.multiplyExact(currency.getReserveSupply(), l3));
        CurrencySupply currencySupply2 = currencySupply = currency.getSupplyData();
        currencySupply2.currentReservePerUnitNQT = currencySupply2.currentReservePerUnitNQT + l3;
        currencySupplyTable.insert(currencySupply);
        CurrencyFounder.addOrUpdateFounder(l2, account.getId(), l3);
    }

    static void claimReserve(AccountLedger.LedgerEvent ledgerEvent, long l, Account account, long l2, long l3) {
        account.addToCurrencyUnits(ledgerEvent, l, l2, -l3);
        Currency currency = Currency.getCurrency(l2);
        currency.increaseSupply(-l3);
        account.addToBalanceAndUnconfirmedBalanceNQT(ledgerEvent, l, Math.multiplyExact(l3, currency.getCurrentReservePerUnitNQT()));
    }

    static void transferCurrency(AccountLedger.LedgerEvent ledgerEvent, long l, Account account, Account account2, long l2, long l3) {
        account.addToCurrencyUnits(ledgerEvent, l, l2, -l3);
        account2.addToCurrencyAndUnconfirmedCurrencyUnits(ledgerEvent, l, l2, l3);
    }

    void increaseSupply(long l) {
        this.getSupplyData();
        CurrencySupply currencySupply = this.currencySupply;
        currencySupply.currentSupply = currencySupply.currentSupply + l;
        if (this.currencySupply.currentSupply > this.maxSupply || this.currencySupply.currentSupply < 0L) {
            currencySupply = this.currencySupply;
            currencySupply.currentSupply = currencySupply.currentSupply - l;
            throw new IllegalArgumentException("Cannot add " + l + " to current supply of " + this.currencySupply.currentSupply);
        }
        currencySupplyTable.insert(this.currencySupply);
    }

    public DbIterator<Account.AccountCurrency> getAccounts(int n, int n2) {
        return Account.getCurrencyAccounts(this.currencyId, n, n2);
    }

    public DbIterator<Account.AccountCurrency> getAccounts(int n, int n2, int n3) {
        return Account.getCurrencyAccounts(this.currencyId, n, n2, n3);
    }

    public DbIterator<Exchange> getExchanges(int n, int n2) {
        return Exchange.getCurrencyExchanges(this.currencyId, n, n2);
    }

    public DbIterator<CurrencyTransfer> getTransfers(int n, int n2) {
        return CurrencyTransfer.getCurrencyTransfers(this.currencyId, n, n2);
    }

    public boolean is(CurrencyType currencyType) {
        return (this.type & currencyType.getCode()) != 0;
    }

    public boolean canBeDeletedBy(long l) {
        if (!this.is(CurrencyType.NON_SHUFFLEABLE) && Shuffling.getHoldingShufflingCount(this.currencyId, false) > 0) {
            return false;
        }
        if (!this.isActive()) {
            return l == this.accountId;
        }
        if (this.is(CurrencyType.MINTABLE) && this.getCurrentSupply() < this.maxSupply && l != this.accountId) {
            return false;
        }
        try (DbIterator<Account.AccountCurrency> dbIterator = Account.getCurrencyAccounts(this.currencyId, 0, -1);){
            boolean bl = !dbIterator.hasNext() || dbIterator.next().getAccountId() == l && !dbIterator.hasNext();
            return bl;
        }
    }

    void delete(AccountLedger.LedgerEvent ledgerEvent, long l, Account account) {
        Object object;
        Iterable<Object> iterable;
        if (!this.canBeDeletedBy(account.getId())) {
            throw new IllegalStateException("Currency " + Long.toUnsignedString(this.currencyId) + " not entirely owned by " + Long.toUnsignedString(account.getId()));
        }
        listeners.notify(this, Event.BEFORE_DELETE);
        if (this.is(CurrencyType.RESERVABLE)) {
            if (this.is(CurrencyType.CLAIMABLE) && this.isActive()) {
                account.addToUnconfirmedCurrencyUnits(ledgerEvent, l, this.currencyId, -account.getCurrencyUnits(this.currencyId));
                Currency.claimReserve(ledgerEvent, l, account, this.currencyId, account.getCurrencyUnits(this.currencyId));
            }
            if (!this.isActive()) {
                iterable = CurrencyFounder.getCurrencyFounders(this.currencyId, 0, Integer.MAX_VALUE);
                object = null;
                try {
                    for (CurrencyFounder currencyFounder : iterable) {
                        Account.getAccount(currencyFounder.getAccountId()).addToBalanceAndUnconfirmedBalanceNQT(ledgerEvent, l, Math.multiplyExact(this.reserveSupply, currencyFounder.getAmountPerUnitNQT()));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (iterable != null) {
                        if (object != null) {
                            try {
                                ((DbIterator)iterable).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((DbIterator)iterable).close();
                        }
                    }
                }
            }
            CurrencyFounder.remove(this.currencyId);
        }
        if (this.is(CurrencyType.EXCHANGEABLE)) {
            iterable = new ArrayList();
            object = CurrencyBuyOffer.getOffers(this, 0, -1);
            Object object2 = null;
            try {
                while (((DbIterator)object).hasNext()) {
                    iterable.add(((DbIterator)object).next());
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((DbIterator)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((DbIterator)object).close();
                    }
                }
            }
            iterable.forEach(currencyBuyOffer -> CurrencyExchangeOffer.removeOffer(ledgerEvent, currencyBuyOffer));
        }
        if (this.is(CurrencyType.MINTABLE)) {
            CurrencyMint.deleteCurrency(this);
        }
        account.addToUnconfirmedCurrencyUnits(ledgerEvent, l, this.currencyId, -account.getUnconfirmedCurrencyUnits(this.currencyId));
        account.addToCurrencyUnits(ledgerEvent, l, this.currencyId, -account.getCurrencyUnits(this.currencyId));
        currencyTable.delete(this);
    }

    static {
        Nxt.getBlockchainProcessor().addListener(new CrowdFundingListener(), BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
    }

    private static final class CrowdFundingListener
    implements Listener<Block> {
        private CrowdFundingListener() {
        }

        @Override
        public void notify(Block block) {
            if (block.getHeight() <= Constants.MONETARY_SYSTEM_BLOCK) {
                return;
            }
            try (DbIterator dbIterator = currencyTable.getManyBy(new DbClause.IntClause("issuance_height", block.getHeight()), 0, -1);){
                for (Currency currency : dbIterator) {
                    if (currency.getCurrentReservePerUnitNQT() < currency.getMinReservePerUnitNQT()) {
                        listeners.notify(currency, Event.BEFORE_UNDO_CROWDFUNDING);
                        this.undoCrowdFunding(currency);
                        continue;
                    }
                    listeners.notify(currency, Event.BEFORE_DISTRIBUTE_CROWDFUNDING);
                    this.distributeCurrency(currency);
                }
            }
        }

        private void undoCrowdFunding(Currency currency) {
            try (DbIterator<CurrencyFounder> dbIterator = CurrencyFounder.getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);){
                for (CurrencyFounder currencyFounder : dbIterator) {
                    Account.getAccount(currencyFounder.getAccountId()).addToBalanceAndUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.CURRENCY_UNDO_CROWDFUNDING, currency.getId(), Math.multiplyExact(currency.getReserveSupply(), currencyFounder.getAmountPerUnitNQT()));
                }
            }
            Account.getAccount(currency.getAccountId()).addToCurrencyAndUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_UNDO_CROWDFUNDING, currency.getId(), currency.getId(), -currency.getInitialSupply());
            currencyTable.delete(currency);
            CurrencyFounder.remove(currency.getId());
        }

        private void distributeCurrency(Currency currency) {
            long l = 0L;
            long l2 = currency.getReserveSupply() - currency.getInitialSupply();
            ArrayList<CurrencyFounder> arrayList = new ArrayList<CurrencyFounder>();
            Object object = CurrencyFounder.getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);
            Object object2 = null;
            try {
                Iterator<CurrencyFounder> object3 = ((DbIterator)object).iterator();
                while (object3.hasNext()) {
                    CurrencyFounder currencyFounder = object3.next();
                    l += currencyFounder.getAmountPerUnitNQT();
                    arrayList.add(currencyFounder);
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((DbIterator)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((DbIterator)object).close();
                    }
                }
            }
            object = currency.getSupplyData();
            for (CurrencyFounder currencyFounder : arrayList) {
                long l3 = Math.multiplyExact(l2, currencyFounder.getAmountPerUnitNQT()) / l;
                Object object3 = object;
                ((CurrencySupply)object3).currentSupply = ((CurrencySupply)object3).currentSupply + l3;
                Account.getAccount(currencyFounder.getAccountId()).addToCurrencyAndUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_DISTRIBUTION, currency.getId(), currency.getId(), l3);
            }
            object2 = Account.getAccount(currency.getAccountId());
            ((Account)object2).addToCurrencyAndUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_DISTRIBUTION, currency.getId(), currency.getId(), currency.getReserveSupply() - currency.getCurrentSupply());
            if (!currency.is(CurrencyType.CLAIMABLE)) {
                ((Account)object2).addToBalanceAndUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.CURRENCY_DISTRIBUTION, currency.getId(), Math.multiplyExact(l, currency.getReserveSupply()));
            }
            ((CurrencySupply)object).currentSupply = currency.getReserveSupply();
            currencySupplyTable.insert(object);
        }
    }

    private static final class CurrencySupply {
        private final DbKey dbKey;
        private final long currencyId;
        private long currentSupply;
        private long currentReservePerUnitNQT;

        private CurrencySupply(Currency currency) {
            this.currencyId = currency.currencyId;
            this.dbKey = currencySupplyDbKeyFactory.newKey(this.currencyId);
        }

        private CurrencySupply(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.currencyId = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.currentSupply = resultSet.getLong("current_supply");
            this.currentReservePerUnitNQT = resultSet.getLong("current_reserve_per_unit_nqt");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO currency_supply (id, current_supply, current_reserve_per_unit_nqt, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.currencyId);
                preparedStatement.setLong(++n, this.currentSupply);
                preparedStatement.setLong(++n, this.currentReservePerUnitNQT);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    }

    public static enum Event {
        BEFORE_DISTRIBUTE_CROWDFUNDING,
        BEFORE_UNDO_CROWDFUNDING,
        BEFORE_DELETE;

    }
}

