/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.addons.AddOn;
import nxt.crypto.Crypto;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.parser.ParseException;

public abstract class AbstractEncryptedConfig
implements AddOn {
    private final Map<String, APIServlet.APIRequestHandler> apiRequests = new HashMap<String, APIServlet.APIRequestHandler>();

    @Override
    public void init() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("path");
        arrayList.add("dataAlreadyEncrypted");
        arrayList.add("encryptionPassword");
        arrayList.add(this.getDataParameter());
        arrayList.addAll(this.getExtraParameters());
        ArrayList<APITag> arrayList2 = new ArrayList<APITag>();
        arrayList2.add(APITag.ADDONS);
        if (this.getAPITag() != null) {
            arrayList2.add(this.getAPITag());
        }
        APITag[] aPITagArray = arrayList2.toArray(new APITag[0]);
        APIServlet.APIRequestHandler aPIRequestHandler = new APIServlet.APIRequestHandler(aPITagArray, arrayList.toArray(new String[0])){

            @Override
            protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
                boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("dataAlreadyEncrypted"));
                try {
                    Object object;
                    Object object2;
                    byte[] byArray;
                    if (bl) {
                        byArray = ParameterParser.getBytes(httpServletRequest, AbstractEncryptedConfig.this.getDataParameter(), true);
                    } else {
                        object2 = ParameterParser.getParameter(httpServletRequest, "encryptionPassword");
                        object = Crypto.sha256().digest(Convert.toBytes((String)object2));
                        byte[] byArray2 = Convert.toBytes(AbstractEncryptedConfig.this.getSaveData(httpServletRequest));
                        byArray = Crypto.aesEncrypt(byArray2, object);
                    }
                    object2 = AbstractEncryptedConfig.this.resolvePath(httpServletRequest.getParameter("path"));
                    Logger.logInfoMessage(AbstractEncryptedConfig.this.getAPIRequestName() + " saving to file " + object2);
                    if (AbstractEncryptedConfig.this.getDefaultPath().toAbsolutePath().equals(object2)) {
                        Files.createDirectories(object2.getParent(), new FileAttribute[0]);
                        Files.write((Path)object2, byArray, new OpenOption[0]);
                    } else {
                        Files.write((Path)object2, byArray, StandardOpenOption.CREATE_NEW);
                    }
                    object = new JSONObject();
                    object.put((Object)"filesize", (Object)byArray.length);
                    return object;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage(), iOException);
                }
            }

            @Override
            protected boolean requirePost() {
                return true;
            }

            @Override
            protected boolean allowRequiredBlockParameters() {
                return false;
            }

            @Override
            protected boolean requireFullClient() {
                return true;
            }

            @Override
            protected boolean requireBlockchain() {
                return false;
            }

            @Override
            protected boolean isPassword(String string) {
                return "encryptionPassword".equals(string);
            }

            @Override
            protected boolean isTextArea(String string) {
                return AbstractEncryptedConfig.this.getDataParameter().equals(string);
            }

            @Override
            protected boolean requirePassword() {
                return true;
            }
        };
        APIServlet.APIRequestHandler aPIRequestHandler2 = new APIServlet.APIRequestHandler(aPITagArray, new String[]{"path", "encryptionPassword"}){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
                String string = ParameterParser.getParameter(httpServletRequest, "encryptionPassword");
                byte[] byArray = Crypto.sha256().digest(Convert.toBytes(string));
                try {
                    Path path = AbstractEncryptedConfig.this.resolvePath(httpServletRequest.getParameter("path"));
                    if (!Files.isReadable(path)) {
                        return JSONResponses.INCORRECT_PROCESS_FILE;
                    }
                    byte[] byArray2 = Files.readAllBytes(path);
                    byte[] byArray3 = Crypto.aesDecrypt(byArray2, byArray);
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray3)));){
                        JSONStreamAware jSONStreamAware = AbstractEncryptedConfig.this.processDecrypted(bufferedReader);
                        return jSONStreamAware;
                    }
                }
                catch (IOException | ParseException throwable6) {
                    throw new RuntimeException(throwable6.getMessage(), throwable6);
                }
                catch (RuntimeException runtimeException) {
                    if (runtimeException.getCause() == null) throw runtimeException;
                    if (!(runtimeException.getCause() instanceof InvalidCipherTextException)) throw runtimeException;
                    return JSONResponses.DECRYPTION_FAILED;
                }
            }

            @Override
            protected boolean requirePost() {
                return true;
            }

            @Override
            protected boolean allowRequiredBlockParameters() {
                return false;
            }

            @Override
            protected boolean requireFullClient() {
                return true;
            }

            @Override
            protected boolean isPassword(String string) {
                return "encryptionPassword".equals(string);
            }
        };
        this.apiRequests.put("save" + this.getAPIRequestName() + "Encrypted", aPIRequestHandler);
        this.apiRequests.put("start" + this.getAPIRequestName() + "Encrypted", aPIRequestHandler2);
    }

    @Override
    public Map<String, APIServlet.APIRequestHandler> getAPIRequests() {
        return this.apiRequests;
    }

    protected abstract String getAPIRequestName();

    protected abstract APITag getAPITag();

    protected abstract String getDataParameter();

    protected abstract JSONStreamAware processDecrypted(BufferedReader var1) throws ParseException, IOException;

    protected List<String> getExtraParameters() {
        return Collections.emptyList();
    }

    protected String getSaveData(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getParameter(httpServletRequest, this.getDataParameter());
    }

    protected String getDefaultFilename() {
        return this.getDataParameter();
    }

    protected Path getDefaultPath() {
        Path path = Paths.get(Nxt.getStringProperty("nxt.addons.EncryptedConfig.path", "conf/processes/"), this.getDefaultFilename());
        if (!path.isAbsolute()) {
            path = Paths.get(Nxt.getUserHomeDir(), new String[0]).resolve(path).toAbsolutePath();
        }
        return path;
    }

    protected Path resolvePath(String string2) {
        Path path = Optional.ofNullable(Convert.emptyToNull(string2)).map(string -> Paths.get(string, new String[0])).orElseGet(this::getDefaultPath);
        if (!path.isAbsolute()) {
            path = Paths.get(Nxt.getUserHomeDir(), new String[0]).resolve(path).toAbsolutePath();
        }
        return path;
    }
}

