/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nxt.Account;
import nxt.Asset;
import nxt.Block;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Currency;
import nxt.Db;
import nxt.FxtDistribution;
import nxt.Nxt;
import nxt.addons.AddOn;
import nxt.crypto.Crypto;
import nxt.db.DbUtils;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Listener;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONStreamAware;

public class Snapshot
implements AddOn {
    private static final int snapshotHeight = Nxt.getIntProperty("nxt.snapshotHeight", Integer.MAX_VALUE);
    private static final boolean snapshotForTestnet = Nxt.getBooleanProperty("nxt.snapshotForTestnet", true);
    private static final Set<String> scammerAccounts = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Long.toUnsignedString(Convert.parseAccountId("NXT-TN8U-RBVE-GBJ3-7DEBN")), Long.toUnsignedString(Convert.parseAccountId("NXT-V79Z-RQ5X-XXJR-H8P87")), Long.toUnsignedString(Convert.parseAccountId("NXT-BH28-PKY6-LES8-29DBN")), Long.toUnsignedString(Convert.parseAccountId("NXT-ZKV3-J2WN-T6VM-B28DA")), Long.toUnsignedString(Convert.parseAccountId("NXT-ZPRA-ZDUQ-SYEL-7AAJM")), Long.toUnsignedString(Convert.parseAccountId("NXT-UMZH-XLBB-BGSY-7WESP")), Long.toUnsignedString(Convert.parseAccountId("NXT-5CFL-QTTH-D6K2-AC4TF")), Long.toUnsignedString(Convert.parseAccountId("NXT-B2KJ-DAAF-884G-GENQ8")), Long.toUnsignedString(Convert.parseAccountId("NXT-L8JG-U967-NUNS-BA4RK")), Long.toUnsignedString(Convert.parseAccountId("NXT-LSMJ-YCH7-QESX-AH42N")), Long.toUnsignedString(Convert.parseAccountId("NXT-E8JD-FHKJ-CQ9H-5KGMQ")))));
    private static final String wrongBountyAccount = Long.toUnsignedString(Convert.parseAccountId("NXT-XTJE-PLDX-EZ6E-6FQX6"));
    private static final String AEUR_ACCOUNT = "NXT-NJ92-R5GB-HQB4-6NW7T";

    @Override
    public void init() {
        Nxt.getBlockchainProcessor().addListener(new Listener<Block>(){
            private final List<byte[]> developerPublicKeys = new ArrayList<byte[]>();
            {
                if (snapshotForTestnet) {
                    InputStream inputStream = ClassLoader.getSystemResourceAsStream("developerPasswords.txt");
                    if (inputStream != null) {
                        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                            String string;
                            while ((string = bufferedReader.readLine()) != null) {
                                this.developerPublicKeys.add(Crypto.getPublicKey(string));
                            }
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException.getMessage(), iOException);
                        }
                        this.developerPublicKeys.sort(Convert.byteArrayComparator);
                    } else {
                        Logger.logDebugMessage("No developerPasswords.txt file found");
                    }
                }
            }

            @Override
            public void notify(Block block) {
                if (block.getHeight() == snapshotHeight) {
                    this.exportPublicKeys();
                    Map<String, Long> map = this.exportIgnisBalances();
                    this.exportBitswiftBalances(map);
                    this.exportArdorBalances();
                    this.exportAssetBalances();
                    this.exportAliases();
                    this.exportCurrencies();
                    this.exportAccountInfo();
                    this.exportAccountProperties();
                    this.exportAccountControl();
                }
            }

            private void exportPublicKeys() {
                Throwable throwable;
                AutoCloseable autoCloseable;
                JSONArray jSONArray = new JSONArray();
                try {
                    autoCloseable = Db.db.getConnection();
                    throwable = null;
                    try (PreparedStatement preparedStatement = autoCloseable.prepareStatement("SELECT public_key FROM public_key WHERE public_key IS NOT NULL AND LATEST=true ORDER by account_id");
                         ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            byte[] byArray2 = resultSet.getBytes("public_key");
                            if (Collections.binarySearch(this.developerPublicKeys, byArray2, Convert.byteArrayComparator) >= 0) {
                                throw new RuntimeException("Developer account " + Account.getId(byArray2) + " already exists");
                            }
                            jSONArray.add((Object)Convert.toHexString(resultSet.getBytes("public_key")));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (autoCloseable != null) {
                            if (throwable != null) {
                                try {
                                    autoCloseable.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                autoCloseable.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                this.developerPublicKeys.forEach(byArray -> jSONArray.add((Object)Convert.toHexString(byArray)));
                Logger.logInfoMessage("Will save " + jSONArray.size() + " public keys");
                try {
                    autoCloseable = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(snapshotForTestnet ? "PUBLIC_KEY-testnet.json" : "PUBLIC_KEY.json"))), true);
                    throwable = null;
                    try {
                        JSON.writeJSONString((JSONStreamAware)jSONArray, (Writer)autoCloseable);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (autoCloseable != null) {
                            if (throwable != null) {
                                try {
                                    ((PrintWriter)autoCloseable).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ((PrintWriter)autoCloseable).close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage(), iOException);
                }
                Logger.logInfoMessage("Done");
            }

            private Map<String, Long> exportIgnisBalances() {
                Object object;
                Object object2;
                Throwable throwable;
                PreparedStatement preparedStatement;
                Throwable throwable2;
                Connection connection;
                TreeMap<Object, Long> treeMap = new TreeMap<Object, Long>();
                TreeMap<Object, Long> treeMap2 = new TreeMap<Object, Long>();
                try {
                    connection = Db.db.getConnection();
                    throwable2 = null;
                    try {
                        preparedStatement = connection.prepareStatement("SELECT id, balance FROM account WHERE LATEST=true");
                        throwable = null;
                        try {
                            object2 = preparedStatement.executeQuery();
                            object = null;
                            try {
                                while (object2.next()) {
                                    long l = object2.getLong("id");
                                    long l2 = object2.getLong("balance");
                                    if (l2 <= 0L) continue;
                                    if (!Constants.isTestnet) {
                                        l2 /= 2L;
                                    }
                                    if (snapshotForTestnet && !this.developerPublicKeys.isEmpty()) {
                                        l2 /= 2L;
                                    }
                                    String string = Long.toUnsignedString(l);
                                    treeMap.put(string, l2);
                                    if (snapshotForTestnet) {
                                        treeMap2.put(string, Convert.longValueExact(BigInteger.valueOf(l2).multiply(BigInteger.valueOf(10000L)).divide(BigInteger.valueOf(100000000L))));
                                        continue;
                                    }
                                    treeMap2.put(Long.toUnsignedString(Convert.parseAccountId(Snapshot.AEUR_ACCOUNT)), 100000000000L);
                                }
                            }
                            catch (Throwable throwable3) {
                                object = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (object2 != null) {
                                    if (object != null) {
                                        try {
                                            object2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            ((Throwable)object).addSuppressed(throwable4);
                                        }
                                    } else {
                                        object2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (preparedStatement != null) {
                                if (throwable != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    preparedStatement.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable2 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (connection != null) {
                            if (throwable2 != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable2.addSuppressed(throwable8);
                                }
                            } else {
                                connection.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                if (!Constants.isTestnet) {
                    try {
                        connection = Db.db.getConnection();
                        throwable2 = null;
                        try {
                            preparedStatement = connection.prepareStatement("SELECT account_id, units FROM account_currency WHERE currency_id = ? AND LATEST=true");
                            throwable = null;
                            try {
                                object2 = Currency.getCurrencyByCode("JLRDA");
                                object = Long.toUnsignedString(((Currency)object2).getAccountId());
                                preparedStatement.setLong(1, ((Currency)object2).getId());
                                try (ResultSet resultSet = preparedStatement.executeQuery();){
                                    while (resultSet.next()) {
                                        long l;
                                        Object object3 = Long.toUnsignedString(resultSet.getLong("account_id"));
                                        long l3 = resultSet.getLong("units");
                                        if (l3 <= 0L) continue;
                                        if (snapshotForTestnet && !this.developerPublicKeys.isEmpty()) {
                                            l3 /= 2L;
                                        }
                                        if (scammerAccounts.contains(object3)) {
                                            Logger.logDebugMessage("Will allocate " + l3 + " JLRDA from " + Convert.rsAccount(Long.parseUnsignedLong((String)object3)) + " back to " + Convert.rsAccount(Long.parseUnsignedLong((String)object)));
                                            object3 = object;
                                        }
                                        if (((String)object3).equals(wrongBountyAccount)) {
                                            l3 -= 750000000L;
                                            l = Convert.nullToZero((Long)treeMap.get(object));
                                            treeMap.put(object, l += 7500000000000L);
                                            Logger.logDebugMessage("Will allocate 75k JLRDA from " + Convert.rsAccount(Long.parseUnsignedLong(wrongBountyAccount)) + " back to " + Convert.rsAccount(Long.parseUnsignedLong((String)object)));
                                        }
                                        l = Convert.nullToZero((Long)treeMap.get(object3));
                                        treeMap.put(object3, l += l3 * 10000L);
                                        if (!snapshotForTestnet) continue;
                                        long l4 = Convert.nullToZero((Long)treeMap2.get(object3));
                                        treeMap2.put(object3, l4 + l3);
                                    }
                                }
                            }
                            catch (Throwable throwable9) {
                                throwable = throwable9;
                                throw throwable9;
                            }
                            finally {
                                if (preparedStatement != null) {
                                    if (throwable != null) {
                                        try {
                                            preparedStatement.close();
                                        }
                                        catch (Throwable throwable10) {
                                            throwable.addSuppressed(throwable10);
                                        }
                                    } else {
                                        preparedStatement.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable11) {
                            throwable2 = throwable11;
                            throw throwable11;
                        }
                        finally {
                            if (connection != null) {
                                if (throwable2 != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable12) {
                                        throwable2.addSuppressed(throwable12);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException.getMessage(), sQLException);
                    }
                }
                if (snapshotForTestnet && !this.developerPublicKeys.isEmpty()) {
                    long l = 100000000000000000L / (long)(2 * this.developerPublicKeys.size());
                    this.developerPublicKeys.forEach(byArray -> {
                        String string = Long.toUnsignedString(Account.getId(byArray));
                        treeMap.put(string, l);
                        treeMap2.put(string, l / 100000000L * 10000L);
                    });
                }
                this.saveMap(treeMap, snapshotForTestnet ? "IGNIS-testnet.json" : "IGNIS.json");
                this.saveMap(treeMap2, snapshotForTestnet ? "AEUR-testnet.json" : "AEUR.json");
                return Collections.unmodifiableMap(treeMap);
            }

            private void exportArdorBalances() {
                TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, quantity FROM account_asset WHERE asset_id = ? AND LATEST=true");){
                    preparedStatement.setLong(1, FxtDistribution.FXT_ASSET_ID);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            long l = resultSet.getLong("account_id");
                            long l2 = resultSet.getLong("quantity");
                            if (l2 <= 0L) continue;
                            if (snapshotForTestnet && !this.developerPublicKeys.isEmpty()) {
                                l2 /= 2L;
                            }
                            treeMap.put(Long.toUnsignedString(l), l2 * 10000L);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                if (snapshotForTestnet && !this.developerPublicKeys.isEmpty()) {
                    long l = 100000000000000000L / (long)(2 * this.developerPublicKeys.size());
                    this.developerPublicKeys.forEach(byArray -> {
                        String string = Long.toUnsignedString(Account.getId(byArray));
                        treeMap.put(string, l);
                    });
                }
                this.saveMap(treeMap, snapshotForTestnet ? "ARDR-testnet.json" : "ARDR.json");
            }

            private void exportBitswiftBalances(Map<String, Long> map) {
                Asset asset = Asset.getAsset(FxtDistribution.BITSWIFT_ASSET_ID);
                if (asset == null) {
                    return;
                }
                BigInteger bigInteger = BigInteger.valueOf(asset.getInitialQuantityQNT());
                BigInteger bigInteger2 = BigInteger.valueOf(map.values().stream().mapToLong(Long::longValue).sum());
                TreeMap<Object, Long> treeMap = new TreeMap<Object, Long>();
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, quantity FROM account_asset WHERE asset_id = ? AND LATEST=true");){
                    preparedStatement.setLong(1, FxtDistribution.BITSWIFT_ASSET_ID);
                    Throwable object22 = null;
                    try (Object object = preparedStatement.executeQuery();){
                        while (object.next()) {
                            long string = object.getLong("quantity");
                            if (string <= 0L) continue;
                            String string2 = Long.toUnsignedString(object.getLong("account_id"));
                            treeMap.put(string2, string);
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable l = throwable;
                        throw throwable;
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        String string = (String)entry.getKey();
                        long l = Convert.nullToZero((Long)entry.getValue());
                        long l2 = Convert.longValueExact(bigInteger.multiply(BigInteger.valueOf(l)).divide(bigInteger2).divide(BigInteger.TEN));
                        Long l3 = (Long)treeMap.get(string);
                        treeMap.put(string, l3 == null ? l2 : l3 + l2);
                    }
                    object = Long.toUnsignedString(FxtDistribution.BITSWIFT_SHAREDROP_ACCOUNT);
                    long l = (Long)treeMap.get(object);
                    if ((l -= Convert.longValueExact(bigInteger.divide(BigInteger.TEN))) < 0L) {
                        throw new RuntimeException("Not enough Bitswift available for sharedrop");
                    }
                    treeMap.put(object, l);
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                this.saveMap(treeMap, snapshotForTestnet ? "BITSWIFT-testnet.json" : "BITSWIFT.json");
            }

            private void exportAssetBalances() {
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, quantity FROM account_asset WHERE asset_id = ? AND LATEST=true");){
                    for (long l : new long[]{FxtDistribution.JANUS_ASSET_ID, FxtDistribution.JANUSXT_ASSET_ID, FxtDistribution.COMJNSXT_ASSET_ID}) {
                        Asset asset = Asset.getAsset(l);
                        String string = asset.getName();
                        String string2 = asset.getDescription();
                        String string3 = Long.toUnsignedString(asset.getAccountId());
                        byte by = asset.getDecimals();
                        TreeMap<String, Long> treeMap2 = new TreeMap<String, Long>();
                        preparedStatement.setLong(1, l);
                        try (Object object = preparedStatement.executeQuery();){
                            while (object.next()) {
                                long l2 = object.getLong("account_id");
                                long l3 = object.getLong("quantity");
                                if (l3 <= 0L) continue;
                                treeMap2.put(Long.toUnsignedString(l2), l3);
                            }
                        }
                        object = new TreeMap();
                        object.put("name", string);
                        object.put("description", string2);
                        object.put("issuer", string3);
                        object.put("decimals", by);
                        object.put("balances", treeMap2);
                        treeMap.put(Long.toUnsignedString(l), object);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                this.saveMap(treeMap, snapshotForTestnet ? "ASSETS-testnet.json" : "ASSETS.json");
            }

            private void exportAliases() {
                TreeMap treeMap = new TreeMap();
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, alias_name, alias_uri FROM alias WHERE LATEST=true");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        String string = resultSet.getString("alias_name");
                        String string2 = Convert.nullToEmpty(resultSet.getString("alias_uri"));
                        long l = resultSet.getLong("account_id");
                        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
                        treeMap2.put("account", Long.toUnsignedString(l));
                        treeMap2.put("uri", string2);
                        treeMap.put(string, treeMap2);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                this.saveMap(treeMap, snapshotForTestnet ? "IGNIS_ALIASES-testnet.json" : "IGNIS_ALIASES.json");
            }

            private void exportCurrencies() {
                TreeMap treeMap = new TreeMap();
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, name, code FROM currency WHERE LATEST=true");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        String string = resultSet.getString("name");
                        String string2 = resultSet.getString("code");
                        if (this.invalidCurrency(string2, string.toLowerCase(Locale.ROOT))) {
                            Logger.logDebugMessage("Skipping currency " + string2 + " " + string);
                            continue;
                        }
                        long l = resultSet.getLong("account_id");
                        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
                        treeMap2.put("account", Long.toUnsignedString(l));
                        treeMap2.put("name", string);
                        treeMap.put(string2, treeMap2);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                this.saveMap(treeMap, snapshotForTestnet ? "IGNIS_CURRENCIES-testnet.json" : "IGNIS_CURRENCIES.json");
            }

            private boolean invalidCurrency(String string, String string2) {
                if (string.equals("ARDOR") || string.contains("ARDR") || "ardor".equals(string2) || "ardr".equals(string2)) {
                    return true;
                }
                if (string.contains("NXT") || string.contains("NEXT") || "nxt".equals(string2) || "next".equals(string2)) {
                    return true;
                }
                if (string.equals("IGNIS") || "ignis".equals(string2)) {
                    return true;
                }
                if ("bitswift".equals(string2)) {
                    return true;
                }
                return string.equals("AEUR") || "aeur".equals(string2);
            }

            private void exportAccountInfo() {
                TreeMap treeMap = new TreeMap();
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, name, description FROM account_info WHERE LATEST=true");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        String string = Convert.nullToEmpty(resultSet.getString("name"));
                        String string2 = Convert.nullToEmpty(resultSet.getString("description"));
                        long l = resultSet.getLong("account_id");
                        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
                        treeMap2.put("name", string);
                        treeMap2.put("description", string2);
                        treeMap.put(Long.toUnsignedString(l), treeMap2);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                this.saveMap(treeMap, snapshotForTestnet ? "ACCOUNT_INFO-testnet.json" : "ACCOUNT_INFO.json");
            }

            private void exportAccountProperties() {
                TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT recipient_id, setter_id, property, value FROM account_property WHERE LATEST=true");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("property");
                        String string3 = Convert.nullToEmpty(resultSet.getString("value"));
                        String string4 = Long.toUnsignedString(resultSet.getLong("recipient_id"));
                        String string5 = Long.toUnsignedString(resultSet.getLong("setter_id"));
                        Map map = treeMap.computeIfAbsent(string4, string -> new TreeMap());
                        Map map2 = map.computeIfAbsent(string5, string -> new TreeMap());
                        map2.put(string2, string3);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                this.saveMap(treeMap, snapshotForTestnet ? "ACCOUNT_PROPERTIES-testnet.json" : "ACCOUNT_PROPERTIES.json");
            }

            private void exportAccountControl() {
                TreeMap treeMap = new TreeMap();
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, whitelist, quorum, max_fees, min_duration, max_duration FROM account_control_phasing WHERE voting_model = 0 AND min_balance IS NULL AND whitelist IS NOT NULL AND LATEST=true");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        long l = resultSet.getLong("account_id");
                        if (l == FxtDistribution.FXT_ISSUER_ID) continue;
                        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
                        Long[] longArray = (Long[])DbUtils.getArray(resultSet, "whitelist", Long[].class);
                        for (int i = 0; i < longArray.length; ++i) {
                            if (longArray[i] != 1739068987193023818L) continue;
                            longArray[i] = 0L;
                        }
                        JSONArray jSONArray = new JSONArray();
                        jSONArray.addAll(Arrays.asList(longArray));
                        treeMap2.put("whitelist", jSONArray);
                        treeMap2.put("quorum", resultSet.getInt("quorum"));
                        treeMap2.put("maxFees", resultSet.getLong("max_fees"));
                        treeMap2.put("minDuration", resultSet.getInt("min_duration"));
                        treeMap2.put("maxDuration", resultSet.getInt("max_duration"));
                        treeMap.put(Long.toUnsignedString(l), treeMap2);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                this.saveMap(treeMap, snapshotForTestnet ? "ACCOUNT_CONTROL-testnet.json" : "ACCOUNT_CONTROL.json");
            }

            private void saveMap(Map<String, ?> map, String string) {
                Logger.logInfoMessage("Will save " + map.size() + " entries to " + string);
                try (PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string))), true);){
                    StringBuilder stringBuilder = new StringBuilder(1024);
                    JSON.encodeObject(map, stringBuilder);
                    printWriter.write(stringBuilder.toString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage(), iOException);
                }
                Logger.logInfoMessage("Done");
            }
        }, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
    }
}

