/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.util.Iterator;
import java.util.NoSuchElementException;
import nxt.db.DbIterator;
import nxt.util.Filter;

public final class FilteringIterator<T>
implements Iterator<T>,
Iterable<T>,
AutoCloseable {
    private final DbIterator<T> dbIterator;
    private final Filter<T> filter;
    private final int from;
    private final int to;
    private T next;
    private boolean hasNext;
    private boolean iterated;
    private int count;

    public FilteringIterator(DbIterator<T> dbIterator, Filter<T> filter) {
        this(dbIterator, filter, 0, Integer.MAX_VALUE);
    }

    public FilteringIterator(DbIterator<T> dbIterator, int n, int n2) {
        this(dbIterator, object -> true, n, n2);
    }

    public FilteringIterator(DbIterator<T> dbIterator, Filter<T> filter, int n, int n2) {
        this.dbIterator = dbIterator;
        this.filter = filter;
        this.from = n;
        this.to = n2;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        while (this.dbIterator.hasNext() && this.count <= this.to) {
            this.next = this.dbIterator.next();
            if (!this.filter.ok(this.next)) continue;
            if (this.count >= this.from) {
                ++this.count;
                this.hasNext = true;
                return true;
            }
            ++this.count;
        }
        this.hasNext = false;
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext) {
            this.hasNext = false;
            return this.next;
        }
        while (this.dbIterator.hasNext() && this.count <= this.to) {
            this.next = this.dbIterator.next();
            if (!this.filter.ok(this.next)) continue;
            if (this.count >= this.from) {
                ++this.count;
                this.hasNext = false;
                return this.next;
            }
            ++this.count;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() {
        this.dbIterator.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iterated) {
            throw new IllegalStateException("Already iterated");
        }
        this.iterated = true;
        return this;
    }
}

