/*
 * Decompiled with CFR 0.152.
 */
package nxt.env;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nxt.env.AndroidDirProvider;
import nxt.env.CommandLineMode;
import nxt.env.DefaultDirProvider;
import nxt.env.DesktopMode;
import nxt.env.DirProvider;
import nxt.env.MacUserDirProvider;
import nxt.env.RuntimeMode;
import nxt.env.UnixUserDirProvider;
import nxt.env.WindowsServiceMode;
import nxt.env.WindowsUserDirProvider;

public class RuntimeEnvironment {
    public static final String RUNTIME_MODE_ARG = "nxt.runtime.mode";
    public static final String DIRPROVIDER_ARG = "nxt.runtime.dirProvider";
    private static final String osname;
    private static final String javaSpecVendor;
    private static final boolean isHeadless;
    private static final boolean hasJavaFX;

    private static boolean isWindowsRuntime() {
        return osname.startsWith("windows");
    }

    private static boolean isUnixRuntime() {
        return osname.contains("nux") || osname.contains("nix") || osname.contains("aix") || osname.contains("bsd") || osname.contains("sunos");
    }

    private static boolean isMacRuntime() {
        return osname.contains("mac");
    }

    public static boolean isAndroidRuntime() {
        return javaSpecVendor.equals("The Android Project");
    }

    private static boolean isWindowsService() {
        return "service".equalsIgnoreCase(System.getProperty(RUNTIME_MODE_ARG)) && RuntimeEnvironment.isWindowsRuntime();
    }

    private static boolean isHeadless() {
        return isHeadless;
    }

    private static boolean isDesktopEnabled() {
        return "desktop".equalsIgnoreCase(System.getProperty(RUNTIME_MODE_ARG)) && !RuntimeEnvironment.isHeadless();
    }

    public static boolean isDesktopApplicationEnabled() {
        return RuntimeEnvironment.isDesktopEnabled() && hasJavaFX;
    }

    public static RuntimeMode getRuntimeMode() {
        System.out.println("isHeadless=" + RuntimeEnvironment.isHeadless());
        if (RuntimeEnvironment.isDesktopEnabled()) {
            return new DesktopMode();
        }
        if (RuntimeEnvironment.isWindowsService()) {
            return new WindowsServiceMode();
        }
        if (RuntimeEnvironment.isAndroidRuntime()) {
            try {
                return (RuntimeMode)Class.forName("nxt.env.AndroidServiceMode").newInstance();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new RuntimeException("Failed to instantiate nxt.env.AndroidServiceMode", reflectiveOperationException);
            }
        }
        return new CommandLineMode();
    }

    public static DirProvider getDirProvider() {
        String string = System.getProperty(DIRPROVIDER_ARG);
        if (string != null) {
            try {
                return (DirProvider)Class.forName(string).newInstance();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                System.out.println("Failed to instantiate dirProvider " + string);
                throw new RuntimeException(reflectiveOperationException.getMessage(), reflectiveOperationException);
            }
        }
        if (RuntimeEnvironment.isAndroidRuntime()) {
            return new AndroidDirProvider();
        }
        if (RuntimeEnvironment.isDesktopEnabled()) {
            if (RuntimeEnvironment.isWindowsRuntime()) {
                return new WindowsUserDirProvider();
            }
            if (RuntimeEnvironment.isUnixRuntime()) {
                return new UnixUserDirProvider();
            }
            if (RuntimeEnvironment.isMacRuntime()) {
                return new MacUserDirProvider();
            }
        }
        return new DefaultDirProvider();
    }

    static {
        boolean bl;
        osname = System.getProperty("os.name").toLowerCase();
        javaSpecVendor = System.getProperty("java.specification.vendor");
        try {
            Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
            Method method = clazz.getMethod("isHeadless", new Class[0]);
            bl = (Boolean)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            bl = true;
        }
        isHeadless = bl;
        try {
            Class.forName("javafx.application.Application");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("javafx not supported");
            bl = false;
        }
        hasJavaFX = bl;
    }
}

