/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nxt.addons.JO;
import nxt.http.APIConnector;
import nxt.http.APIInProcessConnector;
import nxt.http.APIRemoteConnector;
import nxt.http.callers.ApiSpec;
import nxt.http.responses.BlockResponse;
import nxt.http.responses.TransactionResponse;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class APICall {
    private APIConnector apiConnector;

    private APICall(Builder<?> builder) {
        URL uRL = ((Builder)builder).remoteUrl;
        if (builder.isRemoteOnly() && uRL == null) {
            throw new IllegalArgumentException("API call " + this.getClass().getName() + " must connect to a remote node");
        }
        this.apiConnector = uRL != null ? new APIRemoteConnector(builder.params, ((Builder)builder).parts, uRL, ((Builder)builder).isTrustRemoteCertificate) : new APIInProcessConnector(builder.params, ((Builder)builder).parts);
    }

    public JO getJsonResponse() {
        return new JO(this.invoke());
    }

    public InputStream getInputStream() {
        return this.apiConnector.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes() {
        try (InputStream inputStream = this.getInputStream();){
            byte[] byArray = APICall.readInputStream(inputStream);
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public InvocationError invokeWithError() {
        JSONObject jSONObject = this.invoke();
        return new InvocationError(jSONObject);
    }

    public JSONObject invokeNoError() {
        JSONObject jSONObject = this.invoke();
        APICall.assertNull(jSONObject.get((Object)"errorDescription"));
        APICall.assertNull(jSONObject.get((Object)"errorCode"));
        return jSONObject;
    }

    public JSONObject invoke() {
        return AccessController.doPrivileged(this::invokeImpl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject invokeImpl() {
        try {
            InputStream inputStream = this.apiConnector.getInputStream();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)bufferedReader);
                return jSONObject;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static void assertNull(Object object) {
        if (object != null) {
            throw new AssertionError((Object)("Expected null, got: " + object));
        }
    }

    private static <T> T assertNotNull(T t) {
        if (t == null) {
            throw new AssertionError((Object)"Expected not null");
        }
        return t;
    }

    private static byte[] readInputStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static class InvocationError {
        private JSONObject jsonObject;

        public InvocationError(JSONObject jSONObject) {
            this.jsonObject = jSONObject;
        }

        public String getErrorCode() {
            return this.str("errorCode");
        }

        public String getErrorDescription() {
            return this.str("errorDescription");
        }

        private String str(String string) {
            return (String)APICall.assertNotNull(this.jsonObject.get((Object)string));
        }
    }

    public static class Builder<T extends Builder> {
        protected final Map<String, List<String>> params = new HashMap<String, List<String>>();
        private List<String> validParams = new ArrayList<String>();
        private boolean isValidationEnabled = true;
        private final Map<String, byte[]> parts = new HashMap<String, byte[]>();
        private String validFileParam;
        private String requestType;
        private URL remoteUrl;
        private boolean isTrustRemoteCertificate;

        public Builder(String string) {
            this(ApiSpec.valueOf(string));
        }

        public Builder(ApiSpec apiSpec) {
            this.requestType = apiSpec.name();
            this.params.put("requestType", Collections.singletonList(this.requestType));
            this.params.put("deadline", Collections.singletonList("1440"));
            this.validParams.addAll(apiSpec.getParameters());
            this.validFileParam = apiSpec.getFileParameter();
        }

        public T remote(URL uRL) {
            this.remoteUrl = uRL;
            return this.self();
        }

        public T trustRemoteCertificate(boolean bl) {
            this.isTrustRemoteCertificate = bl;
            return this.self();
        }

        public boolean isRemoteOnly() {
            return false;
        }

        public T setParamValidation(boolean bl) {
            this.isValidationEnabled = bl;
            return this.self();
        }

        public T param(String string, String string2) {
            return this.param(string, Collections.singletonList(string2));
        }

        public T param(String string, String[] stringArray) {
            return this.param(string, Arrays.asList(stringArray));
        }

        public T param(String string, List<String> list) {
            if (this.isValidationEnabled && !this.validParams.contains(string)) {
                throw new IllegalArgumentException(String.format("Invalid parameter %s for request type %s", string, this.requestType));
            }
            if (list.size() == 0) {
                throw new IllegalArgumentException(String.format("Empty values parameter %s for requesttype %s", string, this.requestType));
            }
            this.params.put(string, list);
            return this.self();
        }

        public T param(String string, boolean bl) {
            return this.param(string, "" + bl);
        }

        public T param(String string, byte by) {
            return this.param(string, "" + by);
        }

        public T param(String string, int n) {
            return this.param(string, "" + n);
        }

        public T param(String string, int ... nArray) {
            String[] stringArray = (String[])Arrays.stream(nArray).boxed().map(n -> Integer.toString(n)).toArray(String[]::new);
            return this.param(string, stringArray);
        }

        public T param(String string, long l) {
            return this.param(string, "" + l);
        }

        public T param(String string, long ... lArray) {
            String[] stringArray = (String[])Arrays.stream(lArray).boxed().map(l -> Long.toString(l)).toArray(String[]::new);
            return this.param(string, stringArray);
        }

        public T unsignedLongParam(String string, long l) {
            return this.param(string, Long.toUnsignedString(l));
        }

        public T unsignedLongParam(String string, long ... lArray) {
            String[] stringArray = (String[])Arrays.stream(lArray).boxed().map(Long::toUnsignedString).toArray(String[]::new);
            return this.param(string, stringArray);
        }

        public T param(String string, byte[] byArray) {
            return this.param(string, Convert.toHexString(byArray));
        }

        public T param(String string, byte[][] byArray) {
            String[] stringArray = new String[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                stringArray[i] = Convert.toHexString(byArray[i]);
            }
            return this.param(string, stringArray);
        }

        public T secretPhrase(String string) {
            return this.param("secretPhrase", string);
        }

        public T chain(String string) {
            return this.param("chain", string);
        }

        public T chain(int n) {
            return this.param("chain", "" + n);
        }

        public String getParam(String string) {
            List<String> list = this.params.get(string);
            return list == null ? null : list.get(0);
        }

        public boolean isParamSet(String string) {
            return this.params.get(string) != null;
        }

        public T parts(String string, byte[] byArray) {
            if (!this.validFileParam.equals(string)) {
                throw new IllegalArgumentException(String.format("Invalid file parameter %s for request type %s", string, this.requestType));
            }
            this.parts.put(string, byArray);
            return this.self();
        }

        private T self() {
            return (T)this;
        }

        public APICall build() {
            return new APICall(this);
        }

        public JO call() {
            return new APICall(this).getJsonResponse();
        }

        public byte[] download() {
            return new APICall(this).getBytes();
        }

        public List<TransactionResponse> getTransactions() {
            return this.getTransactions("transactions");
        }

        public List<TransactionResponse> getTransactions(String string) {
            JO jO = this.call();
            if (jO.isExist("errorCode")) {
                throw new IllegalStateException(jO.toJSONString());
            }
            if (!jO.isExist(string)) {
                throw new IllegalStateException("Response object does not represent a list of transactions " + jO.toJSONString());
            }
            return jO.getJoList(string).stream().map(TransactionResponse::create).collect(Collectors.toList());
        }

        public List<TransactionResponse> getCreatedTransactions() {
            JO jO2 = this.call();
            if (jO2.isExist("errorCode")) {
                throw new IllegalStateException(jO2.toJSONString());
            }
            if (!jO2.isExist("transactions")) {
                throw new IllegalStateException("Response object does not represent a list of created transactions " + jO2.toJSONString());
            }
            return jO2.getJoList("transactions").stream().map(jO -> TransactionResponse.create(jO.getJo("transactionJSON"))).collect(Collectors.toList());
        }

        public TransactionResponse getTransaction() {
            JO jO = this.call();
            if (jO.isExist("errorCode")) {
                throw new IllegalStateException(jO.toJSONString());
            }
            if (!jO.isExist("deadline")) {
                throw new IllegalStateException("Response object does not represent a transaction " + jO.toJSONString());
            }
            return TransactionResponse.create(jO);
        }

        public TransactionResponse getCreatedTransaction() {
            JO jO = this.call();
            if (jO.isExist("errorCode")) {
                throw new IllegalStateException(jO.toJSONString());
            }
            if (!jO.isExist("deadline")) {
                throw new IllegalStateException("Response object does not represent a transaction " + jO.toJSONString());
            }
            return TransactionResponse.create(jO.getJo("transactionJSON"));
        }

        public List<BlockResponse> getBlocks() {
            JO jO = this.call();
            if (jO.isExist("errorCode")) {
                throw new IllegalStateException(jO.toJSONString());
            }
            if (!jO.isExist("blocks")) {
                throw new IllegalStateException("Response object does not represent a list of blocks " + jO.toJSONString());
            }
            return jO.getJoList("blocks").stream().map(BlockResponse::create).collect(Collectors.toList());
        }

        public BlockResponse getBlock() {
            JO jO = this.call();
            if (jO.isExist("errorCode")) {
                throw new IllegalStateException(jO.toJSONString());
            }
            if (!jO.isExist("generatorPublicKey")) {
                throw new IllegalStateException("Response object does not represent a block " + jO.toJSONString());
            }
            return BlockResponse.create(jO);
        }
    }
}

