/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.TransactionType;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedAssetTransfers
extends APIServlet.APIRequestHandler {
    static final GetExpectedAssetTransfers instance = new GetExpectedAssetTransfers();

    private GetExpectedAssetTransfers() {
        super(new APITag[]{APITag.AE}, "asset", "account", "includeAssetInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, "account", false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssetInfo"));
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != TransactionType.ColoredCoins.ASSET_TRANSFER) {
                return false;
            }
            if (l2 != 0L && transaction.getSenderId() != l2 && transaction.getRecipientId() != l2) {
                return false;
            }
            Attachment.ColoredCoinsAssetTransfer coloredCoinsAssetTransfer = (Attachment.ColoredCoinsAssetTransfer)transaction.getAttachment();
            return l == 0L || coloredCoinsAssetTransfer.getAssetId() == l;
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add((Object)JSONData.expectedAssetTransfer(transaction, bl)));
        jSONObject.put((Object)"transfers", (Object)jSONArray);
        return jSONObject;
    }
}

