/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import nxt.Currency;
import nxt.CurrencyMint;
import nxt.CurrencyMinting;
import nxt.NxtException;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetMintingTarget
extends APIServlet.APIRequestHandler {
    static final GetMintingTarget instance = new GetMintingTarget();

    private GetMintingTarget() {
        super(new APITag[]{APITag.MS}, "currency", "account", "units");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Currency currency = ParameterParser.getCurrency(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(currency.getId()));
        long l = ParameterParser.getLong(httpServletRequest, "units", 1L, currency.getMaxSupply() - currency.getReserveSupply(), true);
        BigInteger bigInteger = CurrencyMinting.getNumericTarget(currency, l);
        jSONObject.put((Object)"difficulty", (Object)String.valueOf(BigInteger.ZERO.equals(bigInteger) ? Integer.valueOf(-1) : BigInteger.valueOf(2L).pow(256).subtract(BigInteger.ONE).divide(bigInteger)));
        jSONObject.put((Object)"targetBytes", (Object)Convert.toHexString(CurrencyMinting.getTarget(bigInteger)));
        jSONObject.put((Object)"counter", (Object)CurrencyMint.getCounter(currency.getId(), ParameterParser.getAccountId(httpServletRequest, true)));
        return jSONObject;
    }
}

