/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nxt.Account;
import nxt.AccountLedger;
import nxt.AccountRestrictions;
import nxt.Alias;
import nxt.Appendix;
import nxt.Asset;
import nxt.AssetDividend;
import nxt.AssetHistory;
import nxt.AssetTransfer;
import nxt.Attachment;
import nxt.Block;
import nxt.Constants;
import nxt.Currency;
import nxt.CurrencyExchangeOffer;
import nxt.CurrencyFounder;
import nxt.CurrencyTransfer;
import nxt.CurrencyType;
import nxt.DigitalGoodsStore;
import nxt.Exchange;
import nxt.ExchangeRequest;
import nxt.FundingMonitor;
import nxt.Generator;
import nxt.HoldingType;
import nxt.MonetarySystem;
import nxt.Nxt;
import nxt.Order;
import nxt.PhasingPoll;
import nxt.PhasingVote;
import nxt.Poll;
import nxt.PrunableMessage;
import nxt.Shuffler;
import nxt.Shuffling;
import nxt.ShufflingParticipant;
import nxt.TaggedData;
import nxt.Token;
import nxt.Trade;
import nxt.Transaction;
import nxt.Vote;
import nxt.VoteWeighting;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.peer.Hallmark;
import nxt.peer.Peer;
import nxt.util.Convert;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class JSONData {
    static JSONObject alias(Alias alias) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", alias.getAccountId());
        jSONObject.put((Object)"aliasName", (Object)alias.getAliasName());
        jSONObject.put((Object)"aliasURI", (Object)alias.getAliasURI());
        jSONObject.put((Object)"timestamp", (Object)alias.getTimestamp());
        jSONObject.put((Object)"alias", (Object)Long.toUnsignedString(alias.getId()));
        Alias.Offer offer = Alias.getOffer(alias);
        if (offer != null) {
            jSONObject.put((Object)"priceNQT", (Object)String.valueOf(offer.getPriceNQT()));
            if (offer.getBuyerId() != 0L) {
                jSONObject.put((Object)"buyer", (Object)Long.toUnsignedString(offer.getBuyerId()));
            }
        }
        return jSONObject;
    }

    static JSONObject accountBalance(Account account, boolean bl) {
        return JSONData.accountBalance(account, bl, Nxt.getBlockchain().getHeight());
    }

    static JSONObject accountBalance(Account account, boolean bl, int n) {
        JSONObject jSONObject = new JSONObject();
        if (account == null) {
            jSONObject.put((Object)"balanceNQT", (Object)"0");
            jSONObject.put((Object)"unconfirmedBalanceNQT", (Object)"0");
            jSONObject.put((Object)"forgedBalanceNQT", (Object)"0");
            if (bl) {
                jSONObject.put((Object)"effectiveBalanceNXT", (Object)"0");
                jSONObject.put((Object)"guaranteedBalanceNQT", (Object)"0");
            }
        } else {
            jSONObject.put((Object)"balanceNQT", (Object)String.valueOf(account.getBalanceNQT()));
            jSONObject.put((Object)"unconfirmedBalanceNQT", (Object)String.valueOf(account.getUnconfirmedBalanceNQT()));
            jSONObject.put((Object)"forgedBalanceNQT", (Object)String.valueOf(account.getForgedBalanceNQT()));
            if (bl) {
                jSONObject.put((Object)"effectiveBalanceNXT", (Object)account.getEffectiveBalanceNXT(n));
                jSONObject.put((Object)"guaranteedBalanceNQT", (Object)String.valueOf(account.getGuaranteedBalanceNQT(Constants.GUARANTEED_BALANCE_CONFIRMATIONS, n)));
            }
        }
        return jSONObject;
    }

    static JSONObject lessor(Account account, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        Account.AccountLease accountLease = account.getAccountLease();
        if (accountLease.getCurrentLesseeId() != 0L) {
            JSONData.putAccount(jSONObject, "currentLessee", accountLease.getCurrentLesseeId());
            jSONObject.put((Object)"currentHeightFrom", (Object)String.valueOf(accountLease.getCurrentLeasingHeightFrom()));
            jSONObject.put((Object)"currentHeightTo", (Object)String.valueOf(accountLease.getCurrentLeasingHeightTo()));
            if (bl) {
                jSONObject.put((Object)"effectiveBalanceNXT", (Object)String.valueOf(account.getGuaranteedBalanceNQT() / 100000000L));
            }
        }
        if (accountLease.getNextLesseeId() != 0L) {
            JSONData.putAccount(jSONObject, "nextLessee", accountLease.getNextLesseeId());
            jSONObject.put((Object)"nextHeightFrom", (Object)String.valueOf(accountLease.getNextLeasingHeightFrom()));
            jSONObject.put((Object)"nextHeightTo", (Object)String.valueOf(accountLease.getNextLeasingHeightTo()));
        }
        return jSONObject;
    }

    static JSONObject asset(Asset asset, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", asset.getAccountId());
        jSONObject.put((Object)"name", (Object)asset.getName());
        jSONObject.put((Object)"description", (Object)asset.getDescription());
        jSONObject.put((Object)"decimals", (Object)asset.getDecimals());
        jSONObject.put((Object)"initialQuantityQNT", (Object)String.valueOf(asset.getInitialQuantityQNT()));
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(asset.getQuantityQNT()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(asset.getId()));
        if (bl) {
            jSONObject.put((Object)"numberOfTrades", (Object)Trade.getTradeCount(asset.getId()));
            jSONObject.put((Object)"numberOfTransfers", (Object)AssetTransfer.getTransferCount(asset.getId()));
            jSONObject.put((Object)"numberOfAccounts", (Object)Account.getAssetAccountCount(asset.getId()));
        }
        return jSONObject;
    }

    static JSONObject currency(Currency currency, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(currency.getId()));
        JSONData.putAccount(jSONObject, "account", currency.getAccountId());
        jSONObject.put((Object)"name", (Object)currency.getName());
        jSONObject.put((Object)"code", (Object)currency.getCode());
        jSONObject.put((Object)"description", (Object)currency.getDescription());
        jSONObject.put((Object)"type", (Object)currency.getType());
        jSONObject.put((Object)"initialSupply", (Object)String.valueOf(currency.getInitialSupply()));
        jSONObject.put((Object)"currentSupply", (Object)String.valueOf(currency.getCurrentSupply()));
        jSONObject.put((Object)"reserveSupply", (Object)String.valueOf(currency.getReserveSupply()));
        jSONObject.put((Object)"maxSupply", (Object)String.valueOf(currency.getMaxSupply()));
        jSONObject.put((Object)"creationHeight", (Object)currency.getCreationHeight());
        jSONObject.put((Object)"issuanceHeight", (Object)currency.getIssuanceHeight());
        jSONObject.put((Object)"minReservePerUnitNQT", (Object)String.valueOf(currency.getMinReservePerUnitNQT()));
        jSONObject.put((Object)"currentReservePerUnitNQT", (Object)String.valueOf(currency.getCurrentReservePerUnitNQT()));
        jSONObject.put((Object)"minDifficulty", (Object)currency.getMinDifficulty());
        jSONObject.put((Object)"maxDifficulty", (Object)currency.getMaxDifficulty());
        jSONObject.put((Object)"algorithm", (Object)currency.getAlgorithm());
        jSONObject.put((Object)"decimals", (Object)currency.getDecimals());
        if (bl) {
            jSONObject.put((Object)"numberOfExchanges", (Object)Exchange.getExchangeCount(currency.getId()));
            jSONObject.put((Object)"numberOfTransfers", (Object)CurrencyTransfer.getTransferCount(currency.getId()));
        }
        JSONArray jSONArray = new JSONArray();
        for (CurrencyType currencyType : CurrencyType.values()) {
            if (!currency.is(currencyType)) continue;
            jSONArray.add((Object)currencyType.toString());
        }
        jSONObject.put((Object)"types", (Object)jSONArray);
        return jSONObject;
    }

    static JSONObject currencyFounder(CurrencyFounder currencyFounder) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(currencyFounder.getCurrencyId()));
        JSONData.putAccount(jSONObject, "account", currencyFounder.getAccountId());
        jSONObject.put((Object)"amountPerUnitNQT", (Object)String.valueOf(currencyFounder.getAmountPerUnitNQT()));
        return jSONObject;
    }

    static JSONObject accountAsset(Account.AccountAsset accountAsset, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            JSONData.putAccount(jSONObject, "account", accountAsset.getAccountId());
        }
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(accountAsset.getAssetId()));
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(accountAsset.getQuantityQNT()));
        jSONObject.put((Object)"unconfirmedQuantityQNT", (Object)String.valueOf(accountAsset.getUnconfirmedQuantityQNT()));
        if (bl2) {
            JSONData.putAssetInfo(jSONObject, accountAsset.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject accountCurrency(Account.AccountCurrency accountCurrency, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            JSONData.putAccount(jSONObject, "account", accountCurrency.getAccountId());
        }
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(accountCurrency.getCurrencyId()));
        jSONObject.put((Object)"units", (Object)String.valueOf(accountCurrency.getUnits()));
        jSONObject.put((Object)"unconfirmedUnits", (Object)String.valueOf(accountCurrency.getUnconfirmedUnits()));
        if (bl2) {
            JSONData.putCurrencyInfo(jSONObject, accountCurrency.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject accountProperty(Account.AccountProperty accountProperty, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            JSONData.putAccount(jSONObject, "recipient", accountProperty.getRecipientId());
        }
        if (bl2) {
            JSONData.putAccount(jSONObject, "setter", accountProperty.getSetterId());
        }
        jSONObject.put((Object)"property", (Object)accountProperty.getProperty());
        jSONObject.put((Object)"value", (Object)accountProperty.getValue());
        return jSONObject;
    }

    static JSONObject assetProperty(Asset.AssetProperty assetProperty, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetProperty.getAssetId()));
        }
        if (bl2) {
            JSONData.putAccount(jSONObject, "setter", assetProperty.getSetterId());
        }
        jSONObject.put((Object)"property", (Object)assetProperty.getProperty());
        jSONObject.put((Object)"value", (Object)assetProperty.getValue());
        return jSONObject;
    }

    static JSONObject askOrder(Order.Ask ask) {
        JSONObject jSONObject = JSONData.order(ask);
        jSONObject.put((Object)"type", (Object)"ask");
        return jSONObject;
    }

    static JSONObject bidOrder(Order.Bid bid) {
        JSONObject jSONObject = JSONData.order(bid);
        jSONObject.put((Object)"type", (Object)"bid");
        return jSONObject;
    }

    private static JSONObject order(Order order) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"order", (Object)Long.toUnsignedString(order.getId()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(order.getAssetId()));
        JSONData.putAccount(jSONObject, "account", order.getAccountId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(order.getQuantityQNT()));
        jSONObject.put((Object)"priceNQT", (Object)String.valueOf(order.getPriceNQT()));
        jSONObject.put((Object)"height", (Object)order.getHeight());
        jSONObject.put((Object)"transactionIndex", (Object)order.getTransactionIndex());
        jSONObject.put((Object)"transactionHeight", (Object)order.getTransactionHeight());
        return jSONObject;
    }

    static JSONObject expectedAskOrder(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOrder(transaction);
        jSONObject.put((Object)"type", (Object)"ask");
        return jSONObject;
    }

    static JSONObject expectedBidOrder(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOrder(transaction);
        jSONObject.put((Object)"type", (Object)"bid");
        return jSONObject;
    }

    private static JSONObject expectedOrder(Transaction transaction) {
        JSONObject jSONObject = new JSONObject();
        Attachment.ColoredCoinsOrderPlacement coloredCoinsOrderPlacement = (Attachment.ColoredCoinsOrderPlacement)transaction.getAttachment();
        jSONObject.put((Object)"order", (Object)transaction.getStringId());
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(coloredCoinsOrderPlacement.getAssetId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(coloredCoinsOrderPlacement.getQuantityQNT()));
        jSONObject.put((Object)"priceNQT", (Object)String.valueOf(coloredCoinsOrderPlacement.getPriceNQT()));
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject expectedOrderCancellation(Transaction transaction) {
        JSONObject jSONObject = new JSONObject();
        Attachment.ColoredCoinsOrderCancellation coloredCoinsOrderCancellation = (Attachment.ColoredCoinsOrderCancellation)transaction.getAttachment();
        jSONObject.put((Object)"order", (Object)Long.toUnsignedString(coloredCoinsOrderCancellation.getOrderId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject offer(CurrencyExchangeOffer currencyExchangeOffer) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"offer", (Object)Long.toUnsignedString(currencyExchangeOffer.getId()));
        JSONData.putAccount(jSONObject, "account", currencyExchangeOffer.getAccountId());
        jSONObject.put((Object)"height", (Object)currencyExchangeOffer.getHeight());
        jSONObject.put((Object)"expirationHeight", (Object)currencyExchangeOffer.getExpirationHeight());
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(currencyExchangeOffer.getCurrencyId()));
        jSONObject.put((Object)"rateNQT", (Object)String.valueOf(currencyExchangeOffer.getRateNQT()));
        jSONObject.put((Object)"limit", (Object)String.valueOf(currencyExchangeOffer.getLimit()));
        jSONObject.put((Object)"supply", (Object)String.valueOf(currencyExchangeOffer.getSupply()));
        return jSONObject;
    }

    static JSONObject expectedBuyOffer(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOffer(transaction);
        Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
        jSONObject.put((Object)"rateNQT", (Object)String.valueOf(monetarySystemPublishExchangeOffer.getBuyRateNQT()));
        jSONObject.put((Object)"limit", (Object)String.valueOf(monetarySystemPublishExchangeOffer.getTotalBuyLimit()));
        jSONObject.put((Object)"supply", (Object)String.valueOf(monetarySystemPublishExchangeOffer.getInitialBuySupply()));
        return jSONObject;
    }

    static JSONObject expectedSellOffer(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOffer(transaction);
        Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
        jSONObject.put((Object)"rateNQT", (Object)String.valueOf(monetarySystemPublishExchangeOffer.getSellRateNQT()));
        jSONObject.put((Object)"limit", (Object)String.valueOf(monetarySystemPublishExchangeOffer.getTotalSellLimit()));
        jSONObject.put((Object)"supply", (Object)String.valueOf(monetarySystemPublishExchangeOffer.getInitialSellSupply()));
        return jSONObject;
    }

    private static JSONObject expectedOffer(Transaction transaction) {
        Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"offer", (Object)transaction.getStringId());
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        jSONObject.put((Object)"expirationHeight", (Object)monetarySystemPublishExchangeOffer.getExpirationHeight());
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(monetarySystemPublishExchangeOffer.getCurrencyId()));
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject availableOffers(CurrencyExchangeOffer.AvailableOffers availableOffers) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"rateNQT", (Object)String.valueOf(availableOffers.getRateNQT()));
        jSONObject.put((Object)"units", (Object)String.valueOf(availableOffers.getUnits()));
        jSONObject.put((Object)"amountNQT", (Object)String.valueOf(availableOffers.getAmountNQT()));
        return jSONObject;
    }

    static JSONObject shuffling(Shuffling shuffling, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"shuffling", (Object)Long.toUnsignedString(shuffling.getId()));
        JSONData.putAccount(jSONObject, "issuer", shuffling.getIssuerId());
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(shuffling.getHoldingId()));
        jSONObject.put((Object)"holdingType", (Object)shuffling.getHoldingType().getCode());
        if (shuffling.getAssigneeAccountId() != 0L) {
            JSONData.putAccount(jSONObject, "assignee", shuffling.getAssigneeAccountId());
        }
        jSONObject.put((Object)"amount", (Object)String.valueOf(shuffling.getAmount()));
        jSONObject.put((Object)"blocksRemaining", (Object)shuffling.getBlocksRemaining());
        jSONObject.put((Object)"participantCount", (Object)shuffling.getParticipantCount());
        jSONObject.put((Object)"registrantCount", (Object)shuffling.getRegistrantCount());
        jSONObject.put((Object)"stage", (Object)shuffling.getStage().getCode());
        jSONObject.put((Object)"shufflingStateHash", (Object)Convert.toHexString(shuffling.getStateHash()));
        jSONObject.put((Object)"shufflingFullHash", (Object)Convert.toHexString(shuffling.getFullHash()));
        JSONArray jSONArray = new JSONArray();
        for (byte[] byArray : shuffling.getRecipientPublicKeys()) {
            jSONArray.add((Object)Convert.toHexString(byArray));
        }
        if (jSONArray.size() > 0) {
            jSONObject.put((Object)"recipientPublicKeys", (Object)jSONArray);
        }
        if (bl && shuffling.getHoldingType() != HoldingType.NXT) {
            jSONObject.put((Object)"holdingInfo", (Object)JSONData.holdingInfoJson(shuffling.getHoldingType(), shuffling.getHoldingId()));
        }
        return jSONObject;
    }

    private static JSONObject holdingInfoJson(HoldingType holdingType, long l) {
        JSONObject jSONObject = new JSONObject();
        if (holdingType == HoldingType.ASSET) {
            JSONData.putAssetInfo(jSONObject, l);
        } else if (holdingType == HoldingType.CURRENCY) {
            JSONData.putCurrencyInfo(jSONObject, l);
        }
        return jSONObject;
    }

    static JSONObject participant(ShufflingParticipant shufflingParticipant) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"shuffling", (Object)Long.toUnsignedString(shufflingParticipant.getShufflingId()));
        JSONData.putAccount(jSONObject, "account", shufflingParticipant.getAccountId());
        JSONData.putAccount(jSONObject, "nextAccount", shufflingParticipant.getNextAccountId());
        jSONObject.put((Object)"state", (Object)shufflingParticipant.getState().getCode());
        return jSONObject;
    }

    static JSONObject shuffler(Shuffler shuffler, boolean bl) {
        ShufflingParticipant shufflingParticipant;
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", shuffler.getAccountId());
        JSONData.putAccount(jSONObject, "recipient", Account.getId(shuffler.getRecipientPublicKey()));
        jSONObject.put((Object)"shufflingFullHash", (Object)Convert.toHexString(shuffler.getShufflingFullHash()));
        jSONObject.put((Object)"shuffling", (Object)Long.toUnsignedString(Convert.fullHashToId(shuffler.getShufflingFullHash())));
        if (shuffler.getFailedTransaction() != null) {
            jSONObject.put((Object)"failedTransaction", (Object)JSONData.unconfirmedTransaction(shuffler.getFailedTransaction()));
            jSONObject.put((Object)"failureCause", (Object)shuffler.getFailureCause().getMessage());
        }
        if (bl && (shufflingParticipant = ShufflingParticipant.getParticipant(Convert.fullHashToId(shuffler.getShufflingFullHash()), shuffler.getAccountId())) != null) {
            jSONObject.put((Object)"participantState", (Object)shufflingParticipant.getState().getCode());
        }
        return jSONObject;
    }

    static JSONObject block(Block block, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"block", (Object)block.getStringId());
        jSONObject.put((Object)"height", (Object)block.getHeight());
        JSONData.putAccount(jSONObject, "generator", block.getGeneratorId());
        jSONObject.put((Object)"generatorPublicKey", (Object)Convert.toHexString(block.getGeneratorPublicKey()));
        jSONObject.put((Object)"timestamp", (Object)block.getTimestamp());
        jSONObject.put((Object)"numberOfTransactions", (Object)block.getTransactions().size());
        jSONObject.put((Object)"totalAmountNQT", (Object)String.valueOf(block.getTotalAmountNQT()));
        jSONObject.put((Object)"totalFeeNQT", (Object)String.valueOf(block.getTotalFeeNQT()));
        jSONObject.put((Object)"payloadLength", (Object)block.getPayloadLength());
        jSONObject.put((Object)"version", (Object)block.getVersion());
        jSONObject.put((Object)"baseTarget", (Object)Long.toUnsignedString(block.getBaseTarget()));
        jSONObject.put((Object)"cumulativeDifficulty", (Object)block.getCumulativeDifficulty().toString());
        if (block.getPreviousBlockId() != 0L) {
            jSONObject.put((Object)"previousBlock", (Object)Long.toUnsignedString(block.getPreviousBlockId()));
        }
        if (block.getNextBlockId() != 0L) {
            jSONObject.put((Object)"nextBlock", (Object)Long.toUnsignedString(block.getNextBlockId()));
        }
        jSONObject.put((Object)"payloadHash", (Object)Convert.toHexString(block.getPayloadHash()));
        jSONObject.put((Object)"generationSignature", (Object)Convert.toHexString(block.getGenerationSignature()));
        if (block.getVersion() > 1) {
            jSONObject.put((Object)"previousBlockHash", (Object)Convert.toHexString(block.getPreviousBlockHash()));
        }
        jSONObject.put((Object)"blockSignature", (Object)Convert.toHexString(block.getBlockSignature()));
        JSONArray jSONArray = new JSONArray();
        if (bl) {
            block.getTransactions().forEach(transaction -> jSONArray.add((Object)JSONData.transaction(transaction)));
        } else {
            block.getTransactions().forEach(transaction -> jSONArray.add((Object)transaction.getStringId()));
        }
        jSONObject.put((Object)"transactions", (Object)jSONArray);
        if (bl2) {
            JSONArray jSONArray2 = new JSONArray();
            try (DbIterator<PhasingPoll.PhasingPollResult> dbIterator = PhasingPoll.getApproved(block.getHeight());){
                for (PhasingPoll.PhasingPollResult phasingPollResult : dbIterator) {
                    long l = phasingPollResult.getId();
                    if (bl) {
                        jSONArray2.add((Object)JSONData.transaction(Nxt.getBlockchain().getTransaction(l)));
                        continue;
                    }
                    jSONArray2.add((Object)Long.toUnsignedString(l));
                }
            }
            jSONObject.put((Object)"executedPhasedTransactions", (Object)jSONArray2);
        }
        return jSONObject;
    }

    static JSONObject encryptedData(EncryptedData encryptedData) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"data", (Object)Convert.toHexString(encryptedData.getData()));
        jSONObject.put((Object)"nonce", (Object)Convert.toHexString(encryptedData.getNonce()));
        return jSONObject;
    }

    static JSONObject goods(DigitalGoodsStore.Goods goods, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"goods", (Object)Long.toUnsignedString(goods.getId()));
        jSONObject.put((Object)"name", (Object)goods.getName());
        jSONObject.put((Object)"description", (Object)goods.getDescription());
        jSONObject.put((Object)"quantity", (Object)goods.getQuantity());
        jSONObject.put((Object)"priceNQT", (Object)String.valueOf(goods.getPriceNQT()));
        JSONData.putAccount(jSONObject, "seller", goods.getSellerId());
        jSONObject.put((Object)"tags", (Object)goods.getTags());
        JSONArray jSONArray = new JSONArray();
        Collections.addAll(jSONArray, goods.getParsedTags());
        jSONObject.put((Object)"parsedTags", (Object)jSONArray);
        jSONObject.put((Object)"delisted", (Object)goods.isDelisted());
        jSONObject.put((Object)"timestamp", (Object)goods.getTimestamp());
        jSONObject.put((Object)"hasImage", (Object)goods.hasImage());
        if (bl) {
            jSONObject.put((Object)"numberOfPurchases", (Object)DigitalGoodsStore.Purchase.getGoodsPurchaseCount(goods.getId(), false, true));
            jSONObject.put((Object)"numberOfPublicFeedbacks", (Object)DigitalGoodsStore.Purchase.getGoodsPurchaseCount(goods.getId(), true, true));
        }
        return jSONObject;
    }

    static JSONObject tag(DigitalGoodsStore.Tag tag) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"tag", (Object)tag.getTag());
        jSONObject.put((Object)"inStockCount", (Object)tag.getInStockCount());
        jSONObject.put((Object)"totalCount", (Object)tag.getTotalCount());
        return jSONObject;
    }

    static JSONObject hallmark(Hallmark hallmark) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", Account.getId(hallmark.getPublicKey()));
        jSONObject.put((Object)"host", (Object)hallmark.getHost());
        jSONObject.put((Object)"port", (Object)hallmark.getPort());
        jSONObject.put((Object)"weight", (Object)hallmark.getWeight());
        String string = Hallmark.formatDate(hallmark.getDate());
        jSONObject.put((Object)"date", (Object)string);
        jSONObject.put((Object)"valid", (Object)hallmark.isValid());
        return jSONObject;
    }

    static JSONObject token(Token token) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", Account.getId(token.getPublicKey()));
        jSONObject.put((Object)"timestamp", (Object)token.getTimestamp());
        jSONObject.put((Object)"valid", (Object)token.isValid());
        return jSONObject;
    }

    static JSONObject peer(Peer peer) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"address", (Object)peer.getHost());
        jSONObject.put((Object)"port", (Object)peer.getPort());
        jSONObject.put((Object)"state", (Object)peer.getState().ordinal());
        jSONObject.put((Object)"announcedAddress", (Object)peer.getAnnouncedAddress());
        jSONObject.put((Object)"shareAddress", (Object)peer.shareAddress());
        if (peer.getHallmark() != null) {
            jSONObject.put((Object)"hallmark", (Object)peer.getHallmark().getHallmarkString());
        }
        jSONObject.put((Object)"weight", (Object)peer.getWeight());
        jSONObject.put((Object)"downloadedVolume", (Object)peer.getDownloadedVolume());
        jSONObject.put((Object)"uploadedVolume", (Object)peer.getUploadedVolume());
        jSONObject.put((Object)"application", (Object)peer.getApplication());
        jSONObject.put((Object)"version", (Object)peer.getVersion());
        jSONObject.put((Object)"platform", (Object)peer.getPlatform());
        if (peer.getApiPort() != 0) {
            jSONObject.put((Object)"apiPort", (Object)peer.getApiPort());
        }
        if (peer.getApiSSLPort() != 0) {
            jSONObject.put((Object)"apiSSLPort", (Object)peer.getApiSSLPort());
        }
        jSONObject.put((Object)"blacklisted", (Object)peer.isBlacklisted());
        jSONObject.put((Object)"lastUpdated", (Object)peer.getLastUpdated());
        jSONObject.put((Object)"lastConnectAttempt", (Object)peer.getLastConnectAttempt());
        jSONObject.put((Object)"inbound", (Object)peer.isInbound());
        jSONObject.put((Object)"inboundWebSocket", (Object)peer.isInboundWebSocket());
        jSONObject.put((Object)"outboundWebSocket", (Object)peer.isOutboundWebSocket());
        if (peer.isBlacklisted()) {
            jSONObject.put((Object)"blacklistingCause", (Object)peer.getBlacklistingCause());
        }
        JSONArray jSONArray = new JSONArray();
        for (Peer.Service service : Peer.Service.values()) {
            if (!peer.providesService(service)) continue;
            jSONArray.add((Object)service.name());
        }
        jSONObject.put((Object)"services", (Object)jSONArray);
        jSONObject.put((Object)"blockchainState", (Object)peer.getBlockchainState());
        return jSONObject;
    }

    static JSONObject poll(Poll poll) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", poll.getAccountId());
        jSONObject.put((Object)"poll", (Object)Long.toUnsignedString(poll.getId()));
        jSONObject.put((Object)"name", (Object)poll.getName());
        jSONObject.put((Object)"description", (Object)poll.getDescription());
        JSONArray jSONArray = new JSONArray();
        Collections.addAll(jSONArray, poll.getOptions());
        jSONObject.put((Object)"options", (Object)jSONArray);
        jSONObject.put((Object)"finishHeight", (Object)poll.getFinishHeight());
        jSONObject.put((Object)"minNumberOfOptions", (Object)poll.getMinNumberOfOptions());
        jSONObject.put((Object)"maxNumberOfOptions", (Object)poll.getMaxNumberOfOptions());
        jSONObject.put((Object)"minRangeValue", (Object)poll.getMinRangeValue());
        jSONObject.put((Object)"maxRangeValue", (Object)poll.getMaxRangeValue());
        JSONData.putVoteWeighting(jSONObject, poll.getVoteWeighting());
        jSONObject.put((Object)"finished", (Object)poll.isFinished());
        jSONObject.put((Object)"timestamp", (Object)poll.getTimestamp());
        return jSONObject;
    }

    static JSONObject pollResults(Poll poll, List<Poll.OptionResult> list, VoteWeighting voteWeighting) {
        Transaction transaction;
        Currency currency;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"poll", (Object)Long.toUnsignedString(poll.getId()));
        if (voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.ASSET) {
            jSONObject.put((Object)"decimals", (Object)Asset.getAsset(voteWeighting.getHoldingId()).getDecimals());
        } else if (voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.CURRENCY) {
            currency = Currency.getCurrency(voteWeighting.getHoldingId());
            if (currency != null) {
                jSONObject.put((Object)"decimals", (Object)currency.getDecimals());
            } else {
                transaction = Nxt.getBlockchain().getTransaction(voteWeighting.getHoldingId());
                Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment();
                jSONObject.put((Object)"decimals", (Object)monetarySystemCurrencyIssuance.getDecimals());
            }
        }
        JSONData.putVoteWeighting(jSONObject, voteWeighting);
        jSONObject.put((Object)"finished", (Object)poll.isFinished());
        currency = new JSONArray();
        Collections.addAll(currency, poll.getOptions());
        jSONObject.put((Object)"options", (Object)currency);
        transaction = new JSONArray();
        for (Poll.OptionResult optionResult : list) {
            JSONObject jSONObject2 = new JSONObject();
            if (optionResult != null) {
                jSONObject2.put((Object)"result", (Object)String.valueOf(optionResult.getResult()));
                jSONObject2.put((Object)"weight", (Object)String.valueOf(optionResult.getWeight()));
            } else {
                jSONObject2.put((Object)"result", (Object)"");
                jSONObject2.put((Object)"weight", (Object)"0");
            }
            transaction.add(jSONObject2);
        }
        jSONObject.put((Object)"results", (Object)transaction);
        return jSONObject;
    }

    static JSONObject vote(Vote vote, VoteWeighter voteWeighter) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "voter", vote.getVoterId());
        jSONObject.put((Object)"transaction", (Object)Long.toUnsignedString(vote.getId()));
        JSONArray jSONArray = new JSONArray();
        for (byte by : vote.getVoteBytes()) {
            if (by == -128) {
                jSONArray.add((Object)"");
                continue;
            }
            jSONArray.add((Object)Byte.toString(by));
        }
        jSONObject.put((Object)"votes", (Object)jSONArray);
        if (voteWeighter != null) {
            jSONObject.put((Object)"weight", (Object)String.valueOf(voteWeighter.calcWeight(vote.getVoterId())));
        }
        return jSONObject;
    }

    static JSONObject phasingPoll(PhasingPoll phasingPoll, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transaction", (Object)Long.toUnsignedString(phasingPoll.getId()));
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(phasingPoll.getFullHash()));
        jSONObject.put((Object)"finishHeight", (Object)phasingPoll.getFinishHeight());
        jSONObject.put((Object)"quorum", (Object)String.valueOf(phasingPoll.getQuorum()));
        JSONData.putAccount(jSONObject, "account", phasingPoll.getAccountId());
        JSONArray jSONArray = new JSONArray();
        for (long l : phasingPoll.getWhitelist()) {
            JSONObject jSONObject2 = new JSONObject();
            JSONData.putAccount(jSONObject2, "whitelisted", l);
            jSONArray.add((Object)jSONObject2);
        }
        jSONObject.put((Object)"whitelist", (Object)jSONArray);
        Object object = phasingPoll.getLinkedFullHashes();
        if (object.size() > 0) {
            JSONArray jSONArray2 = new JSONArray();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                jSONArray2.add((Object)Convert.toHexString(byArray));
            }
            jSONObject.put((Object)"linkedFullHashes", (Object)jSONArray2);
        }
        if (phasingPoll.getHashedSecret() != null) {
            jSONObject.put((Object)"hashedSecret", (Object)Convert.toHexString(phasingPoll.getHashedSecret()));
        }
        JSONData.putVoteWeighting(jSONObject, phasingPoll.getVoteWeighting());
        PhasingPoll.PhasingPollResult phasingPollResult = PhasingPoll.getResult(phasingPoll.getId());
        jSONObject.put((Object)"finished", (Object)(phasingPollResult != null ? 1 : 0));
        if (phasingPollResult != null) {
            jSONObject.put((Object)"approved", (Object)phasingPollResult.isApproved());
            jSONObject.put((Object)"result", (Object)String.valueOf(phasingPollResult.getResult()));
            jSONObject.put((Object)"executionHeight", (Object)phasingPollResult.getHeight());
        } else if (bl) {
            jSONObject.put((Object)"result", (Object)String.valueOf(phasingPoll.countVotes()));
        }
        return jSONObject;
    }

    static JSONObject phasingPollResult(PhasingPoll.PhasingPollResult phasingPollResult) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transaction", (Object)Long.toUnsignedString(phasingPollResult.getId()));
        jSONObject.put((Object)"approved", (Object)phasingPollResult.isApproved());
        jSONObject.put((Object)"result", (Object)String.valueOf(phasingPollResult.getResult()));
        jSONObject.put((Object)"executionHeight", (Object)phasingPollResult.getHeight());
        return jSONObject;
    }

    static JSONObject phasingPollVote(PhasingVote phasingVote) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "voter", phasingVote.getVoterId());
        jSONObject.put((Object)"transaction", (Object)Long.toUnsignedString(phasingVote.getVoteId()));
        return jSONObject;
    }

    private static void putVoteWeighting(JSONObject jSONObject, VoteWeighting voteWeighting) {
        jSONObject.put((Object)"votingModel", (Object)voteWeighting.getVotingModel().getCode());
        jSONObject.put((Object)"minBalance", (Object)String.valueOf(voteWeighting.getMinBalance()));
        jSONObject.put((Object)"minBalanceModel", (Object)voteWeighting.getMinBalanceModel().getCode());
        if (voteWeighting.getHoldingId() != 0L) {
            jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(voteWeighting.getHoldingId()));
        }
    }

    static JSONObject phasingOnly(AccountRestrictions.PhasingOnly phasingOnly) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", phasingOnly.getAccountId());
        jSONObject.put((Object)"quorum", (Object)String.valueOf(phasingOnly.getPhasingParams().getQuorum()));
        JSONArray jSONArray = new JSONArray();
        for (long l : phasingOnly.getPhasingParams().getWhitelist()) {
            JSONObject jSONObject2 = new JSONObject();
            JSONData.putAccount(jSONObject2, "whitelisted", l);
            jSONArray.add((Object)jSONObject2);
        }
        jSONObject.put((Object)"whitelist", (Object)jSONArray);
        jSONObject.put((Object)"maxFees", (Object)String.valueOf(phasingOnly.getMaxFees()));
        jSONObject.put((Object)"minDuration", (Object)phasingOnly.getMinDuration());
        jSONObject.put((Object)"maxDuration", (Object)phasingOnly.getMaxDuration());
        JSONData.putVoteWeighting(jSONObject, phasingOnly.getPhasingParams().getVoteWeighting());
        return jSONObject;
    }

    static JSONObject purchase(DigitalGoodsStore.Purchase purchase) {
        JSONArray jSONArray;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"purchase", (Object)Long.toUnsignedString(purchase.getId()));
        jSONObject.put((Object)"goods", (Object)Long.toUnsignedString(purchase.getGoodsId()));
        DigitalGoodsStore.Goods goods = DigitalGoodsStore.Goods.getGoods(purchase.getGoodsId());
        jSONObject.put((Object)"name", (Object)goods.getName());
        jSONObject.put((Object)"hasImage", (Object)goods.hasImage());
        JSONData.putAccount(jSONObject, "seller", purchase.getSellerId());
        jSONObject.put((Object)"priceNQT", (Object)String.valueOf(purchase.getPriceNQT()));
        jSONObject.put((Object)"quantity", (Object)purchase.getQuantity());
        JSONData.putAccount(jSONObject, "buyer", purchase.getBuyerId());
        jSONObject.put((Object)"timestamp", (Object)purchase.getTimestamp());
        jSONObject.put((Object)"deliveryDeadlineTimestamp", (Object)purchase.getDeliveryDeadlineTimestamp());
        if (purchase.getNote() != null) {
            jSONObject.put((Object)"note", (Object)JSONData.encryptedData(purchase.getNote()));
        }
        jSONObject.put((Object)"pending", (Object)purchase.isPending());
        if (purchase.getEncryptedGoods() != null) {
            jSONObject.put((Object)"goodsData", (Object)JSONData.encryptedData(purchase.getEncryptedGoods()));
            jSONObject.put((Object)"goodsIsText", (Object)purchase.goodsIsText());
        }
        if (purchase.getFeedbackNotes() != null) {
            jSONArray = new JSONArray();
            for (EncryptedData object : purchase.getFeedbackNotes()) {
                jSONArray.add(0, (Object)JSONData.encryptedData(object));
            }
            jSONObject.put((Object)"feedbackNotes", (Object)jSONArray);
        }
        if (purchase.getPublicFeedbacks() != null) {
            jSONArray = new JSONArray();
            for (String string : purchase.getPublicFeedbacks()) {
                jSONArray.add(0, (Object)string);
            }
            jSONObject.put((Object)"publicFeedbacks", (Object)jSONArray);
        }
        if (purchase.getRefundNote() != null) {
            jSONObject.put((Object)"refundNote", (Object)JSONData.encryptedData(purchase.getRefundNote()));
        }
        if (purchase.getDiscountNQT() > 0L) {
            jSONObject.put((Object)"discountNQT", (Object)String.valueOf(purchase.getDiscountNQT()));
        }
        if (purchase.getRefundNQT() > 0L) {
            jSONObject.put((Object)"refundNQT", (Object)String.valueOf(purchase.getRefundNQT()));
        }
        return jSONObject;
    }

    static JSONObject trade(Trade trade, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"timestamp", (Object)trade.getTimestamp());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(trade.getQuantityQNT()));
        jSONObject.put((Object)"priceNQT", (Object)String.valueOf(trade.getPriceNQT()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(trade.getAssetId()));
        jSONObject.put((Object)"askOrder", (Object)Long.toUnsignedString(trade.getAskOrderId()));
        jSONObject.put((Object)"bidOrder", (Object)Long.toUnsignedString(trade.getBidOrderId()));
        jSONObject.put((Object)"askOrderHeight", (Object)trade.getAskOrderHeight());
        jSONObject.put((Object)"bidOrderHeight", (Object)trade.getBidOrderHeight());
        JSONData.putAccount(jSONObject, "seller", trade.getSellerId());
        JSONData.putAccount(jSONObject, "buyer", trade.getBuyerId());
        jSONObject.put((Object)"block", (Object)Long.toUnsignedString(trade.getBlockId()));
        jSONObject.put((Object)"height", (Object)trade.getHeight());
        jSONObject.put((Object)"tradeType", (Object)(trade.isBuy() ? "buy" : "sell"));
        if (bl) {
            JSONData.putAssetInfo(jSONObject, trade.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject assetTransfer(AssetTransfer assetTransfer, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"assetTransfer", (Object)Long.toUnsignedString(assetTransfer.getId()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetTransfer.getAssetId()));
        JSONData.putAccount(jSONObject, "sender", assetTransfer.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", assetTransfer.getRecipientId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(assetTransfer.getQuantityQNT()));
        jSONObject.put((Object)"height", (Object)assetTransfer.getHeight());
        jSONObject.put((Object)"timestamp", (Object)assetTransfer.getTimestamp());
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetTransfer.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject expectedAssetTransfer(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        Attachment.ColoredCoinsAssetTransfer coloredCoinsAssetTransfer = (Attachment.ColoredCoinsAssetTransfer)transaction.getAttachment();
        jSONObject.put((Object)"assetTransfer", (Object)transaction.getStringId());
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(coloredCoinsAssetTransfer.getAssetId()));
        JSONData.putAccount(jSONObject, "sender", transaction.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", transaction.getRecipientId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(coloredCoinsAssetTransfer.getQuantityQNT()));
        if (bl) {
            JSONData.putAssetInfo(jSONObject, coloredCoinsAssetTransfer.getAssetId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject assetDelete(AssetHistory assetHistory, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"assetDelete", (Object)Long.toUnsignedString(assetHistory.getId()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetHistory.getAssetId()));
        JSONData.putAccount(jSONObject, "account", assetHistory.getAccountId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(-assetHistory.getQuantityQNT()));
        jSONObject.put((Object)"height", (Object)assetHistory.getHeight());
        jSONObject.put((Object)"timestamp", (Object)assetHistory.getTimestamp());
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetHistory.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject assetHistory(AssetHistory assetHistory, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"assetHistory", (Object)Long.toUnsignedString(assetHistory.getId()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetHistory.getAssetId()));
        JSONData.putAccount(jSONObject, "account", assetHistory.getAccountId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(assetHistory.getQuantityQNT()));
        jSONObject.put((Object)"height", (Object)assetHistory.getHeight());
        jSONObject.put((Object)"timestamp", (Object)assetHistory.getTimestamp());
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetHistory.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject expectedAssetDelete(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        Attachment.ColoredCoinsAssetDelete coloredCoinsAssetDelete = (Attachment.ColoredCoinsAssetDelete)transaction.getAttachment();
        jSONObject.put((Object)"assetDelete", (Object)transaction.getStringId());
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(coloredCoinsAssetDelete.getAssetId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(coloredCoinsAssetDelete.getQuantityQNT()));
        if (bl) {
            JSONData.putAssetInfo(jSONObject, coloredCoinsAssetDelete.getAssetId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject assetDividend(AssetDividend assetDividend, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"assetDividend", (Object)Long.toUnsignedString(assetDividend.getId()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetDividend.getAssetId()));
        jSONObject.put((Object)"amountNQTPerQNT", (Object)String.valueOf(assetDividend.getAmountNQTPerQNT()));
        jSONObject.put((Object)"totalDividend", (Object)String.valueOf(assetDividend.getTotalDividend()));
        jSONObject.put((Object)"dividendHeight", (Object)assetDividend.getDividendHeight());
        jSONObject.put((Object)"numberOfAccounts", (Object)assetDividend.getNumAccounts());
        jSONObject.put((Object)"height", (Object)assetDividend.getHeight());
        jSONObject.put((Object)"timestamp", (Object)assetDividend.getTimestamp());
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(assetDividend.getHoldingId()));
        HoldingType holdingType = assetDividend.getHoldingType();
        jSONObject.put((Object)"holdingType", (Object)holdingType.getCode());
        if (bl && holdingType != HoldingType.NXT) {
            jSONObject.put((Object)"holdingInfo", (Object)JSONData.holdingInfoJson(holdingType, assetDividend.getHoldingId()));
        }
        return jSONObject;
    }

    static JSONObject currencyTransfer(CurrencyTransfer currencyTransfer, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transfer", (Object)Long.toUnsignedString(currencyTransfer.getId()));
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(currencyTransfer.getCurrencyId()));
        JSONData.putAccount(jSONObject, "sender", currencyTransfer.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", currencyTransfer.getRecipientId());
        jSONObject.put((Object)"units", (Object)String.valueOf(currencyTransfer.getUnits()));
        jSONObject.put((Object)"height", (Object)currencyTransfer.getHeight());
        jSONObject.put((Object)"timestamp", (Object)currencyTransfer.getTimestamp());
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, currencyTransfer.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject expectedCurrencyTransfer(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer = (Attachment.MonetarySystemCurrencyTransfer)transaction.getAttachment();
        jSONObject.put((Object)"transfer", (Object)transaction.getStringId());
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(monetarySystemCurrencyTransfer.getCurrencyId()));
        JSONData.putAccount(jSONObject, "sender", transaction.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", transaction.getRecipientId());
        jSONObject.put((Object)"units", (Object)String.valueOf(monetarySystemCurrencyTransfer.getUnits()));
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, monetarySystemCurrencyTransfer.getCurrencyId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject exchange(Exchange exchange, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transaction", (Object)Long.toUnsignedString(exchange.getTransactionId()));
        jSONObject.put((Object)"timestamp", (Object)exchange.getTimestamp());
        jSONObject.put((Object)"units", (Object)String.valueOf(exchange.getUnits()));
        jSONObject.put((Object)"rateNQT", (Object)String.valueOf(exchange.getRate()));
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(exchange.getCurrencyId()));
        jSONObject.put((Object)"offer", (Object)Long.toUnsignedString(exchange.getOfferId()));
        JSONData.putAccount(jSONObject, "seller", exchange.getSellerId());
        JSONData.putAccount(jSONObject, "buyer", exchange.getBuyerId());
        jSONObject.put((Object)"block", (Object)Long.toUnsignedString(exchange.getBlockId()));
        jSONObject.put((Object)"height", (Object)exchange.getHeight());
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, exchange.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject exchangeRequest(ExchangeRequest exchangeRequest, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transaction", (Object)Long.toUnsignedString(exchangeRequest.getId()));
        jSONObject.put((Object)"subtype", (Object)(exchangeRequest.isBuy() ? MonetarySystem.EXCHANGE_BUY.getSubtype() : MonetarySystem.EXCHANGE_SELL.getSubtype()));
        jSONObject.put((Object)"timestamp", (Object)exchangeRequest.getTimestamp());
        jSONObject.put((Object)"units", (Object)String.valueOf(exchangeRequest.getUnits()));
        jSONObject.put((Object)"rateNQT", (Object)String.valueOf(exchangeRequest.getRate()));
        jSONObject.put((Object)"height", (Object)exchangeRequest.getHeight());
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, exchangeRequest.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject expectedExchangeRequest(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transaction", (Object)transaction.getStringId());
        jSONObject.put((Object)"subtype", (Object)transaction.getType().getSubtype());
        Attachment.MonetarySystemExchange monetarySystemExchange = (Attachment.MonetarySystemExchange)transaction.getAttachment();
        jSONObject.put((Object)"units", (Object)String.valueOf(monetarySystemExchange.getUnits()));
        jSONObject.put((Object)"rateNQT", (Object)String.valueOf(monetarySystemExchange.getRateNQT()));
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, monetarySystemExchange.getCurrencyId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject unconfirmedTransaction(Transaction transaction) {
        return JSONData.unconfirmedTransaction(transaction, null);
    }

    static JSONObject unconfirmedTransaction(Transaction transaction, Filter<Appendix> filter) {
        byte[] byArray;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"type", (Object)transaction.getType().getType());
        jSONObject.put((Object)"subtype", (Object)transaction.getType().getSubtype());
        jSONObject.put((Object)"phased", (Object)(transaction.getPhasing() != null ? 1 : 0));
        jSONObject.put((Object)"timestamp", (Object)transaction.getTimestamp());
        jSONObject.put((Object)"deadline", (Object)transaction.getDeadline());
        jSONObject.put((Object)"senderPublicKey", (Object)Convert.toHexString(transaction.getSenderPublicKey()));
        if (transaction.getRecipientId() != 0L) {
            JSONData.putAccount(jSONObject, "recipient", transaction.getRecipientId());
        }
        jSONObject.put((Object)"amountNQT", (Object)String.valueOf(transaction.getAmountNQT()));
        jSONObject.put((Object)"feeNQT", (Object)String.valueOf(transaction.getFeeNQT()));
        String string = transaction.getReferencedTransactionFullHash();
        if (string != null) {
            jSONObject.put((Object)"referencedTransactionFullHash", (Object)string);
        }
        if ((byArray = Convert.emptyToNull(transaction.getSignature())) != null) {
            jSONObject.put((Object)"signature", (Object)Convert.toHexString(byArray));
            jSONObject.put((Object)"signatureHash", (Object)Convert.toHexString(Crypto.sha256().digest(byArray)));
            jSONObject.put((Object)"fullHash", (Object)transaction.getFullHash());
            jSONObject.put((Object)"transaction", (Object)transaction.getStringId());
        }
        JSONObject jSONObject2 = new JSONObject();
        if (filter == null) {
            for (Appendix object : transaction.getAppendages(true)) {
                jSONObject2.putAll((Map)object.getJSONObject());
            }
        } else {
            for (Appendix appendix : transaction.getAppendages(filter, true)) {
                jSONObject2.putAll((Map)appendix.getJSONObject());
            }
        }
        if (!jSONObject2.isEmpty()) {
            for (Map.Entry entry : jSONObject2.entrySet()) {
                if (!(entry.getValue() instanceof Long)) continue;
                entry.setValue(String.valueOf(entry.getValue()));
            }
            jSONObject.put((Object)"attachment", (Object)jSONObject2);
        }
        JSONData.putAccount(jSONObject, "sender", transaction.getSenderId());
        jSONObject.put((Object)"height", (Object)transaction.getHeight());
        jSONObject.put((Object)"version", (Object)transaction.getVersion());
        if (transaction.getVersion() > 0) {
            jSONObject.put((Object)"ecBlockId", (Object)Long.toUnsignedString(transaction.getECBlockId()));
            jSONObject.put((Object)"ecBlockHeight", (Object)transaction.getECBlockHeight());
        }
        return jSONObject;
    }

    static JSONObject transaction(Transaction transaction) {
        return JSONData.transaction(transaction, false);
    }

    static JSONObject transaction(Transaction transaction, boolean bl) {
        PhasingPoll.PhasingPollResult phasingPollResult;
        JSONObject jSONObject = JSONData.transaction(transaction, null);
        if (bl && transaction.getPhasing() != null && (phasingPollResult = PhasingPoll.getResult(transaction.getId())) != null) {
            jSONObject.put((Object)"approved", (Object)phasingPollResult.isApproved());
            jSONObject.put((Object)"result", (Object)String.valueOf(phasingPollResult.getResult()));
            jSONObject.put((Object)"executionHeight", (Object)phasingPollResult.getHeight());
        }
        return jSONObject;
    }

    static JSONObject transaction(Transaction transaction, Filter<Appendix> filter) {
        JSONObject jSONObject = JSONData.unconfirmedTransaction(transaction, filter);
        jSONObject.put((Object)"block", (Object)Long.toUnsignedString(transaction.getBlockId()));
        jSONObject.put((Object)"confirmations", (Object)(Nxt.getBlockchain().getHeight() - transaction.getHeight()));
        jSONObject.put((Object)"blockTimestamp", (Object)transaction.getBlockTimestamp());
        jSONObject.put((Object)"transactionIndex", (Object)transaction.getIndex());
        return jSONObject;
    }

    static JSONObject generator(Generator generator, int n) {
        JSONObject jSONObject = new JSONObject();
        long l = generator.getDeadline();
        JSONData.putAccount(jSONObject, "account", generator.getAccountId());
        jSONObject.put((Object)"deadline", (Object)l);
        jSONObject.put((Object)"hitTime", (Object)generator.getHitTime());
        jSONObject.put((Object)"remaining", (Object)Math.max(l - (long)n, 0L));
        return jSONObject;
    }

    static JSONObject accountMonitor(FundingMonitor fundingMonitor, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"holdingType", (Object)fundingMonitor.getHoldingType().getCode());
        jSONObject.put((Object)"account", (Object)Long.toUnsignedString(fundingMonitor.getAccountId()));
        jSONObject.put((Object)"accountRS", (Object)fundingMonitor.getAccountName());
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(fundingMonitor.getHoldingId()));
        jSONObject.put((Object)"property", (Object)fundingMonitor.getProperty());
        jSONObject.put((Object)"amount", (Object)String.valueOf(fundingMonitor.getAmount()));
        jSONObject.put((Object)"threshold", (Object)String.valueOf(fundingMonitor.getThreshold()));
        jSONObject.put((Object)"interval", (Object)fundingMonitor.getInterval());
        if (bl) {
            JSONArray jSONArray = new JSONArray();
            List<FundingMonitor.MonitoredAccount> list = FundingMonitor.getMonitoredAccounts(fundingMonitor);
            list.forEach(monitoredAccount -> jSONArray.add((Object)JSONData.monitoredAccount(monitoredAccount)));
            jSONObject.put((Object)"monitoredAccounts", (Object)jSONArray);
        }
        return jSONObject;
    }

    static JSONObject monitoredAccount(FundingMonitor.MonitoredAccount monitoredAccount) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"account", (Object)Long.toUnsignedString(monitoredAccount.getAccountId()));
        jSONObject.put((Object)"accountRS", (Object)monitoredAccount.getAccountName());
        jSONObject.put((Object)"amount", (Object)String.valueOf(monitoredAccount.getAmount()));
        jSONObject.put((Object)"threshold", (Object)String.valueOf(monitoredAccount.getThreshold()));
        jSONObject.put((Object)"interval", (Object)monitoredAccount.getInterval());
        return jSONObject;
    }

    static JSONObject prunableMessage(PrunableMessage prunableMessage, String string, byte[] byArray) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transaction", (Object)Long.toUnsignedString(prunableMessage.getId()));
        if (prunableMessage.getMessage() == null || prunableMessage.getEncryptedData() == null) {
            jSONObject.put((Object)"isText", (Object)(prunableMessage.getMessage() != null ? prunableMessage.messageIsText() : prunableMessage.encryptedMessageIsText()));
        }
        JSONData.putAccount(jSONObject, "sender", prunableMessage.getSenderId());
        if (prunableMessage.getRecipientId() != 0L) {
            JSONData.putAccount(jSONObject, "recipient", prunableMessage.getRecipientId());
        }
        jSONObject.put((Object)"transactionTimestamp", (Object)prunableMessage.getTransactionTimestamp());
        jSONObject.put((Object)"blockTimestamp", (Object)prunableMessage.getBlockTimestamp());
        EncryptedData encryptedData = prunableMessage.getEncryptedData();
        if (encryptedData != null) {
            jSONObject.put((Object)"encryptedMessage", (Object)JSONData.encryptedData(prunableMessage.getEncryptedData()));
            jSONObject.put((Object)"encryptedMessageIsText", (Object)prunableMessage.encryptedMessageIsText());
            byte[] byArray2 = null;
            try {
                if (string != null) {
                    byArray2 = prunableMessage.decrypt(string);
                } else if (byArray != null && byArray.length > 0) {
                    byArray2 = prunableMessage.decrypt(byArray);
                }
                if (byArray2 != null) {
                    jSONObject.put((Object)"decryptedMessage", (Object)Convert.toString(byArray2, prunableMessage.encryptedMessageIsText()));
                }
            }
            catch (RuntimeException runtimeException) {
                JSONData.putException(jSONObject, runtimeException, "Decryption failed");
            }
            jSONObject.put((Object)"isCompressed", (Object)prunableMessage.isCompressed());
        }
        if (prunableMessage.getMessage() != null) {
            jSONObject.put((Object)"message", (Object)Convert.toString(prunableMessage.getMessage(), prunableMessage.messageIsText()));
            jSONObject.put((Object)"messageIsText", (Object)prunableMessage.messageIsText());
        }
        return jSONObject;
    }

    static JSONObject taggedData(TaggedData taggedData, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transaction", (Object)Long.toUnsignedString(taggedData.getId()));
        JSONData.putAccount(jSONObject, "account", taggedData.getAccountId());
        jSONObject.put((Object)"name", (Object)taggedData.getName());
        jSONObject.put((Object)"description", (Object)taggedData.getDescription());
        jSONObject.put((Object)"tags", (Object)taggedData.getTags());
        JSONArray jSONArray = new JSONArray();
        Collections.addAll(jSONArray, taggedData.getParsedTags());
        jSONObject.put((Object)"parsedTags", (Object)jSONArray);
        jSONObject.put((Object)"type", (Object)taggedData.getType());
        jSONObject.put((Object)"channel", (Object)taggedData.getChannel());
        jSONObject.put((Object)"filename", (Object)taggedData.getFilename());
        jSONObject.put((Object)"isText", (Object)taggedData.isText());
        if (bl) {
            jSONObject.put((Object)"data", (Object)(taggedData.isText() ? Convert.toString(taggedData.getData()) : Convert.toHexString(taggedData.getData())));
        }
        jSONObject.put((Object)"transactionTimestamp", (Object)taggedData.getTransactionTimestamp());
        jSONObject.put((Object)"blockTimestamp", (Object)taggedData.getBlockTimestamp());
        return jSONObject;
    }

    static JSONObject dataTag(TaggedData.Tag tag) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"tag", (Object)tag.getTag());
        jSONObject.put((Object)"count", (Object)tag.getCount());
        return jSONObject;
    }

    static JSONObject apiRequestHandler(APIServlet.APIRequestHandler aPIRequestHandler) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"allowRequiredBlockParameters", (Object)aPIRequestHandler.allowRequiredBlockParameters());
        if (aPIRequestHandler.getFileParameter() != null) {
            jSONObject.put((Object)"fileParameter", (Object)aPIRequestHandler.getFileParameter());
        }
        jSONObject.put((Object)"requireBlockchain", (Object)aPIRequestHandler.requireBlockchain());
        jSONObject.put((Object)"requirePost", (Object)aPIRequestHandler.requirePost());
        jSONObject.put((Object)"requirePassword", (Object)aPIRequestHandler.requirePassword());
        jSONObject.put((Object)"requireFullClient", (Object)aPIRequestHandler.requireFullClient());
        return jSONObject;
    }

    static void putPrunableAttachment(JSONObject jSONObject, Transaction transaction) {
        JSONObject jSONObject2 = transaction.getPrunableAttachmentJSON();
        if (jSONObject2 != null) {
            jSONObject.put((Object)"prunableAttachmentJSON", (Object)jSONObject2);
        }
    }

    static void putException(JSONObject jSONObject, Exception exception) {
        JSONData.putException(jSONObject, exception, "");
    }

    static void putException(JSONObject jSONObject, Exception exception, String string) {
        jSONObject.put((Object)"errorCode", (Object)4);
        if (string.length() > 0) {
            string = string + ": ";
        }
        jSONObject.put((Object)"error", (Object)exception.toString());
        jSONObject.put((Object)"errorDescription", (Object)(string + exception.getMessage()));
    }

    static void putAccount(JSONObject jSONObject, String string, long l) {
        jSONObject.put((Object)string, (Object)Long.toUnsignedString(l));
        jSONObject.put((Object)(string + "RS"), (Object)Convert.rsAccount(l));
    }

    private static void putCurrencyInfo(JSONObject jSONObject, long l) {
        Currency currency = Currency.getCurrency(l);
        if (currency == null) {
            return;
        }
        jSONObject.put((Object)"name", (Object)currency.getName());
        jSONObject.put((Object)"code", (Object)currency.getCode());
        jSONObject.put((Object)"type", (Object)currency.getType());
        jSONObject.put((Object)"decimals", (Object)currency.getDecimals());
        jSONObject.put((Object)"issuanceHeight", (Object)currency.getIssuanceHeight());
        JSONData.putAccount(jSONObject, "issuerAccount", currency.getAccountId());
    }

    private static void putAssetInfo(JSONObject jSONObject, long l) {
        Asset asset = Asset.getAsset(l);
        jSONObject.put((Object)"name", (Object)asset.getName());
        jSONObject.put((Object)"decimals", (Object)asset.getDecimals());
    }

    private static void putExpectedTransaction(JSONObject jSONObject, Transaction transaction) {
        jSONObject.put((Object)"height", (Object)(Nxt.getBlockchain().getHeight() + 1));
        jSONObject.put((Object)"phased", (Object)(transaction.getPhasing() != null ? 1 : 0));
        if (transaction.getBlockId() != 0L) {
            jSONObject.put((Object)"transactionHeight", (Object)transaction.getHeight());
            jSONObject.put((Object)"confirmations", (Object)(Nxt.getBlockchain().getHeight() - transaction.getHeight()));
        }
    }

    static void ledgerEntry(JSONObject jSONObject, AccountLedger.LedgerEntry ledgerEntry, boolean bl, boolean bl2) {
        Transaction transaction;
        JSONData.putAccount(jSONObject, "account", ledgerEntry.getAccountId());
        jSONObject.put((Object)"ledgerId", (Object)Long.toUnsignedString(ledgerEntry.getLedgerId()));
        jSONObject.put((Object)"block", (Object)Long.toUnsignedString(ledgerEntry.getBlockId()));
        jSONObject.put((Object)"height", (Object)ledgerEntry.getHeight());
        jSONObject.put((Object)"timestamp", (Object)ledgerEntry.getTimestamp());
        jSONObject.put((Object)"eventType", (Object)ledgerEntry.getEvent().name());
        jSONObject.put((Object)"event", (Object)Long.toUnsignedString(ledgerEntry.getEventId()));
        jSONObject.put((Object)"isTransactionEvent", (Object)ledgerEntry.getEvent().isTransaction());
        jSONObject.put((Object)"change", (Object)String.valueOf(ledgerEntry.getChange()));
        jSONObject.put((Object)"balance", (Object)String.valueOf(ledgerEntry.getBalance()));
        AccountLedger.LedgerHolding ledgerHolding = ledgerEntry.getHolding();
        if (ledgerHolding != null) {
            jSONObject.put((Object)"holdingType", (Object)ledgerHolding.name());
            if (ledgerEntry.getHoldingId() != null) {
                jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(ledgerEntry.getHoldingId()));
            }
            if (bl2) {
                transaction = null;
                if (ledgerHolding == AccountLedger.LedgerHolding.ASSET_BALANCE || ledgerHolding == AccountLedger.LedgerHolding.UNCONFIRMED_ASSET_BALANCE) {
                    transaction = new JSONObject();
                    JSONData.putAssetInfo((JSONObject)transaction, ledgerEntry.getHoldingId());
                } else if (ledgerHolding == AccountLedger.LedgerHolding.CURRENCY_BALANCE || ledgerHolding == AccountLedger.LedgerHolding.UNCONFIRMED_CURRENCY_BALANCE) {
                    transaction = new JSONObject();
                    JSONData.putCurrencyInfo((JSONObject)transaction, ledgerEntry.getHoldingId());
                }
                if (transaction != null) {
                    jSONObject.put((Object)"holdingInfo", (Object)transaction);
                }
            }
        }
        if (bl && ledgerEntry.getEvent().isTransaction()) {
            transaction = Nxt.getBlockchain().getTransaction(ledgerEntry.getEventId());
            jSONObject.put((Object)"transaction", (Object)JSONData.transaction(transaction));
        }
    }

    private JSONData() {
    }

    static interface VoteWeighter {
        public long calcWeight(long var1);
    }
}

