/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Currency;
import nxt.CurrencySellOffer;
import nxt.MonetarySystem;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.TransactionScheduler;
import nxt.http.API;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;

public final class ScheduleCurrencyBuy
extends CreateTransaction {
    static final ScheduleCurrencyBuy instance = new ScheduleCurrencyBuy();

    private ScheduleCurrencyBuy() {
        super(new APITag[]{APITag.MS, APITag.CREATE_TRANSACTION}, "currency", "rateNQT", "units", "offerIssuer", "transactionJSON", "transactionBytes", "prunableAttachmentJSON", "adminPassword");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("transactionJSON"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("transactionBytes"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("prunableAttachmentJSON"));
        long l = ParameterParser.getAccountId(httpServletRequest, "offerIssuer", true);
        try {
            Transaction transaction;
            JSONObject jSONObject;
            Object object;
            if (string2 == null && string == null) {
                boolean bl;
                boolean bl2 = bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("broadcast"));
                if (bl) {
                    return JSONResponses.error("Must use broadcast=false to schedule a future currency buy");
                }
                object = ParameterParser.getCurrency(httpServletRequest);
                long l2 = ParameterParser.getLong(httpServletRequest, "rateNQT", 0L, Long.MAX_VALUE, true);
                long l3 = ParameterParser.getLong(httpServletRequest, "units", 0L, Long.MAX_VALUE, true);
                Account account = ParameterParser.getSenderAccount(httpServletRequest);
                String string4 = ParameterParser.getSecretPhrase(httpServletRequest, false);
                Attachment.MonetarySystemExchangeBuy monetarySystemExchangeBuy = new Attachment.MonetarySystemExchangeBuy(((Currency)object).getId(), l2, l3);
                jSONObject = (JSONObject)JSONValue.parse((String)JSON.toString(this.createTransaction(httpServletRequest, account, monetarySystemExchangeBuy)));
                if (string4 == null || "true".equalsIgnoreCase(httpServletRequest.getParameter("calculateFee"))) {
                    jSONObject.put((Object)"scheduled", (Object)false);
                    return jSONObject;
                }
                transaction = Nxt.newTransactionBuilder((JSONObject)jSONObject.get((Object)"transactionJSON")).build();
            } else {
                jSONObject = new JSONObject();
                transaction = ParameterParser.parseTransaction(string, string2, string3).build();
                JSONObject jSONObject2 = JSONData.unconfirmedTransaction(transaction);
                jSONObject.put((Object)"transactionJSON", (Object)jSONObject2);
                try {
                    jSONObject.put((Object)"unsignedTransactionBytes", (Object)Convert.toHexString(transaction.getUnsignedBytes()));
                }
                catch (NxtException.NotYetEncryptedException notYetEncryptedException) {
                    // empty catch block
                }
                jSONObject.put((Object)"transactionBytes", (Object)Convert.toHexString(transaction.getBytes()));
                jSONObject.put((Object)"signatureHash", jSONObject2.get((Object)"signatureHash"));
                jSONObject.put((Object)"transaction", (Object)transaction.getStringId());
                jSONObject.put((Object)"fullHash", (Object)transaction.getFullHash());
            }
            Attachment.MonetarySystemExchangeBuy monetarySystemExchangeBuy = (Attachment.MonetarySystemExchangeBuy)transaction.getAttachment();
            object = new ExchangeOfferFilter(l, monetarySystemExchangeBuy.getCurrencyId(), monetarySystemExchangeBuy.getRateNQT());
            Nxt.getBlockchain().updateLock();
            try {
                transaction.validate();
                CurrencySellOffer currencySellOffer = CurrencySellOffer.getOffer(monetarySystemExchangeBuy.getCurrencyId(), l);
                if (currencySellOffer != null && currencySellOffer.getSupply() > 0L && currencySellOffer.getRateNQT() <= monetarySystemExchangeBuy.getRateNQT()) {
                    Logger.logDebugMessage("Exchange offer found in blockchain, broadcasting transaction " + transaction.getStringId());
                    Nxt.getTransactionProcessor().broadcast(transaction);
                    jSONObject.put((Object)"broadcasted", (Object)true);
                    JSONObject jSONObject3 = jSONObject;
                    return jSONObject3;
                }
                try (JSONStreamAware jSONStreamAware = Nxt.getTransactionProcessor().getAllUnconfirmedTransactions();){
                    while (jSONStreamAware.hasNext()) {
                        if (!object.ok(jSONStreamAware.next())) continue;
                        Logger.logDebugMessage("Exchange offer found in unconfirmed pool, broadcasting transaction " + transaction.getStringId());
                        Nxt.getTransactionProcessor().broadcast(transaction);
                        jSONObject.put((Object)"broadcasted", (Object)true);
                        JSONObject jSONObject4 = jSONObject;
                        return jSONObject4;
                    }
                }
                if (API.checkPassword(httpServletRequest)) {
                    Logger.logDebugMessage("Scheduling transaction " + transaction.getStringId());
                    TransactionScheduler.schedule((Filter<Transaction>)object, transaction);
                    jSONObject.put((Object)"scheduled", (Object)true);
                    return jSONObject;
                }
                jSONStreamAware = JSONResponses.error("No sell offer is currently available. Please try again when there is an open sell offer. (To schedule a buy order even in the absence of a sell offer, on a node protected by admin password, please first specify the admin password in the account settings.)");
                return jSONStreamAware;
            }
            finally {
                Nxt.getBlockchain().updateUnlock();
            }
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }

    private static class ExchangeOfferFilter
    implements Filter<Transaction> {
        private final long senderId;
        private final long currencyId;
        private final long rateNQT;

        private ExchangeOfferFilter(long l, long l2, long l3) {
            this.senderId = l;
            this.currencyId = l2;
            this.rateNQT = l3;
        }

        @Override
        public boolean ok(Transaction transaction) {
            if (transaction.getSenderId() != this.senderId || transaction.getType() != MonetarySystem.PUBLISH_EXCHANGE_OFFER || transaction.getPhasing() != null) {
                return false;
            }
            Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
            return monetarySystemPublishExchangeOffer.getCurrencyId() == this.currencyId && monetarySystemPublishExchangeOffer.getSellRateNQT() <= this.rateNQT;
        }
    }
}

