/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class VerifyTaggedData
extends APIServlet.APIRequestHandler {
    static final VerifyTaggedData instance = new VerifyTaggedData();

    private VerifyTaggedData() {
        super("file", new APITag[]{APITag.DATA}, "transaction", "name", "description", "tags", "type", "channel", "isText", "filename", "data");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "transaction", true);
        Transaction transaction = Nxt.getBlockchain().getTransaction(l);
        if (transaction == null) {
            return JSONResponses.UNKNOWN_TRANSACTION;
        }
        Attachment.TaggedDataUpload taggedDataUpload = ParameterParser.getTaggedData(httpServletRequest);
        Attachment attachment = transaction.getAttachment();
        if (!(attachment instanceof Attachment.TaggedDataUpload)) {
            return JSONResponses.INCORRECT_TRANSACTION;
        }
        Attachment.TaggedDataUpload taggedDataUpload2 = (Attachment.TaggedDataUpload)attachment;
        if (!Arrays.equals(taggedDataUpload2.getHash(), taggedDataUpload.getHash())) {
            return JSONResponses.HASHES_MISMATCH;
        }
        JSONObject jSONObject = taggedDataUpload2.getJSONObject();
        jSONObject.put((Object)"verify", (Object)true);
        return jSONObject;
    }
}

