/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.File;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.Statement;
import nxt.Constants;
import nxt.Nxt;
import nxt.util.Logger;

public class CompactDatabase {
    public static void main(String[] stringArray) {
        Logger.init();
        int n = CompactDatabase.compactDatabase();
        Logger.shutdown();
        System.exit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int compactDatabase() {
        Object object;
        String string;
        int n = 0;
        String string2 = Constants.isTestnet ? "nxt.testDb" : "nxt.db";
        String string3 = Nxt.getStringProperty(string2 + "Type");
        if (!"h2".equals(string3)) {
            Logger.logErrorMessage("Database type must be 'h2'");
            return 1;
        }
        String string4 = Nxt.getStringProperty(string2 + "Url");
        if (string4 == null) {
            string = Nxt.getDbDir(Nxt.getStringProperty(string2 + "Dir"));
            string4 = String.format("jdbc:%s:%s", string3, string);
        }
        string = Nxt.getStringProperty(string2 + "Params");
        string4 = string4 + ";" + string;
        String string5 = Nxt.getStringProperty(string2 + "Username", "sa");
        String string6 = Nxt.getStringProperty(string2 + "Password", "sa", true);
        int n2 = string4.indexOf(58);
        if (n2 >= 0) {
            n2 = string4.indexOf(58, n2 + 1);
        }
        if (n2 < 0) {
            Logger.logErrorMessage("Malformed database URL: " + string4);
            return 1;
        }
        int n3 = n2 + 1;
        int n4 = string4.indexOf(59, n3);
        String string7 = n4 < 0 ? string4.substring(n3) : string4.substring(n3, n4);
        if (string7.startsWith("file:")) {
            string7 = string7.substring(5);
        }
        n4 = string7.lastIndexOf(92);
        n2 = string7.lastIndexOf(47);
        if (n4 >= 0) {
            if (n2 >= 0) {
                n4 = Math.max(n4, n2);
            }
        } else {
            n4 = n2;
        }
        if (n4 < 0) {
            Logger.logErrorMessage("Malformed database URL: " + string4);
            return 1;
        }
        string7 = string7.substring(0, n4);
        Logger.logInfoMessage("Database directory is \"" + string7 + '\"');
        int n5 = 0;
        File file = new File(string7, "backup.sql.gz");
        File file2 = new File(string7, "nxt.h2.db");
        if (!file2.exists() && !(file2 = new File(string7, "nxt.mv.db")).exists()) {
            Logger.logErrorMessage("NRS database not found");
            return 1;
        }
        File file3 = new File(file2.getPath() + ".bak");
        try {
            Throwable throwable;
            Statement statement;
            Logger.logInfoMessage("Creating the SQL script");
            if (file.exists() && !file.delete()) {
                throw new IOException(String.format("Unable to delete '%s'", file.getPath()));
            }
            object = DriverManager.getConnection(string4, string5, string6);
            Throwable throwable2 = null;
            try {
                statement = object.createStatement();
                throwable = null;
                try {
                    statement.execute("SCRIPT TO '" + file.getPath() + "' COMPRESSION GZIP CHARSET 'UTF-8'");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (object != null) {
                    if (throwable2 != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        object.close();
                    }
                }
            }
            Logger.logInfoMessage("Creating the new database");
            if (!file2.renameTo(file3)) {
                throw new IOException(String.format("Unable to rename '%s' to '%s'", file2.getPath(), file3.getPath()));
            }
            n5 = 1;
            object = DriverManager.getConnection(string4, string5, string6);
            throwable2 = null;
            try {
                statement = object.createStatement();
                throwable = null;
                try {
                    statement.execute("RUNSCRIPT FROM '" + file.getPath() + "' COMPRESSION GZIP CHARSET 'UTF-8'");
                    statement.execute("ANALYZE");
                    statement.execute("SHUTDOWN COMPACT");
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Throwable throwable9) {
                throwable2 = throwable9;
                throw throwable9;
            }
            finally {
                if (object != null) {
                    if (throwable2 != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                    } else {
                        object.close();
                    }
                }
            }
            n5 = 2;
            Logger.logInfoMessage("Database successfully compacted");
        }
        catch (Throwable throwable) {
            try {
                Logger.logErrorMessage("Unable to compact the database", throwable);
                n = 1;
            }
            catch (Throwable throwable11) {
                switch (n5) {
                    case 0: {
                        if (!file.exists() || file.delete()) break;
                        Logger.logErrorMessage(String.format("Unable to delete '%s'", file.getPath()));
                        break;
                    }
                    case 1: {
                        File file4 = new File(string7, "nxt.h2.db");
                        if (file4.exists()) {
                            if (!file4.delete()) {
                                Logger.logErrorMessage(String.format("Unable to delete '%s'", file4.getPath()));
                            }
                        } else {
                            file4 = new File(string7, "nxt.mv.db");
                            if (file4.exists() && !file4.delete()) {
                                Logger.logErrorMessage(String.format("Unable to delete '%s'", file4.getPath()));
                            }
                        }
                        if (file3.renameTo(file2)) break;
                        Logger.logErrorMessage(String.format("Unable to rename '%s' to '%s'", file3.getPath(), file2.getPath()));
                        break;
                    }
                    case 2: {
                        if (!file.delete()) {
                            Logger.logErrorMessage(String.format("Unable to delete '%s'", file.getPath()));
                        }
                        if (file3.delete()) break;
                        Logger.logErrorMessage(String.format("Unable to delete '%s'", file3.getPath()));
                    }
                }
                throw throwable11;
            }
            switch (n5) {
                case 0: {
                    if (!file.exists() || file.delete()) break;
                    Logger.logErrorMessage(String.format("Unable to delete '%s'", file.getPath()));
                    break;
                }
                case 1: {
                    File file5 = new File(string7, "nxt.h2.db");
                    if (file5.exists()) {
                        if (!file5.delete()) {
                            Logger.logErrorMessage(String.format("Unable to delete '%s'", file5.getPath()));
                        }
                    } else {
                        file5 = new File(string7, "nxt.mv.db");
                        if (file5.exists() && !file5.delete()) {
                            Logger.logErrorMessage(String.format("Unable to delete '%s'", file5.getPath()));
                        }
                    }
                    if (file3.renameTo(file2)) break;
                    Logger.logErrorMessage(String.format("Unable to rename '%s' to '%s'", file3.getPath(), file2.getPath()));
                    break;
                }
                case 2: {
                    if (!file.delete()) {
                        Logger.logErrorMessage(String.format("Unable to delete '%s'", file.getPath()));
                    }
                    if (file3.delete()) break;
                    Logger.logErrorMessage(String.format("Unable to delete '%s'", file3.getPath()));
                }
            }
        }
        switch (n5) {
            case 0: {
                if (!file.exists() || file.delete()) break;
                Logger.logErrorMessage(String.format("Unable to delete '%s'", file.getPath()));
                break;
            }
            case 1: {
                object = new File(string7, "nxt.h2.db");
                if (((File)object).exists()) {
                    if (!((File)object).delete()) {
                        Logger.logErrorMessage(String.format("Unable to delete '%s'", ((File)object).getPath()));
                    }
                } else {
                    object = new File(string7, "nxt.mv.db");
                    if (((File)object).exists() && !((File)object).delete()) {
                        Logger.logErrorMessage(String.format("Unable to delete '%s'", ((File)object).getPath()));
                    }
                }
                if (file3.renameTo(file2)) break;
                Logger.logErrorMessage(String.format("Unable to rename '%s' to '%s'", file3.getPath(), file2.getPath()));
                break;
            }
            case 2: {
                if (!file.delete()) {
                    Logger.logErrorMessage(String.format("Unable to delete '%s'", file.getPath()));
                }
                if (file3.delete()) break;
                Logger.logErrorMessage(String.format("Unable to delete '%s'", file3.getPath()));
            }
        }
        return n;
    }
}

