/*
 * Decompiled with CFR 0.152.
 */
package nxt.user;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.user.JSONResponses;
import nxt.user.User;
import nxt.user.UserServlet;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SendMoney
extends UserServlet.UserRequestHandler {
    static final SendMoney instance = new SendMoney();

    private SendMoney() {
    }

    @Override
    JSONStreamAware processRequest(HttpServletRequest httpServletRequest, User user) throws NxtException.ValidationException, IOException {
        long l;
        if (user.getSecretPhrase() == null) {
            return null;
        }
        String string = httpServletRequest.getParameter("recipient");
        String string2 = httpServletRequest.getParameter("amountNXT");
        String string3 = httpServletRequest.getParameter("feeNXT");
        String string4 = httpServletRequest.getParameter("deadline");
        String string5 = httpServletRequest.getParameter("secretPhrase");
        long l2 = 0L;
        long l3 = 0L;
        short s = 0;
        try {
            l = Convert.parseUnsignedLong(string);
            if (l == 0L) {
                throw new IllegalArgumentException("invalid recipient");
            }
            l2 = Convert.parseNXT(string2.trim());
            l3 = Convert.parseNXT(string3.trim());
            s = (short)(Double.parseDouble(string4) * 60.0);
        }
        catch (RuntimeException runtimeException) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"response", (Object)"notifyOfIncorrectTransaction");
            jSONObject.put((Object)"message", (Object)"One of the fields is filled incorrectly!");
            jSONObject.put((Object)"recipient", (Object)string);
            jSONObject.put((Object)"amountNXT", (Object)string2);
            jSONObject.put((Object)"feeNXT", (Object)string3);
            jSONObject.put((Object)"deadline", (Object)string4);
            return jSONObject;
        }
        if (!user.getSecretPhrase().equals(string5)) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"response", (Object)"notifyOfIncorrectTransaction");
            jSONObject.put((Object)"message", (Object)"Wrong secret phrase!");
            jSONObject.put((Object)"recipient", (Object)string);
            jSONObject.put((Object)"amountNXT", (Object)string2);
            jSONObject.put((Object)"feeNXT", (Object)string3);
            jSONObject.put((Object)"deadline", (Object)string4);
            return jSONObject;
        }
        if (l2 <= 0L || l2 > 100000000000000000L) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"response", (Object)"notifyOfIncorrectTransaction");
            jSONObject.put((Object)"message", (Object)"\"Amount\" must be greater than 0!");
            jSONObject.put((Object)"recipient", (Object)string);
            jSONObject.put((Object)"amountNXT", (Object)string2);
            jSONObject.put((Object)"feeNXT", (Object)string3);
            jSONObject.put((Object)"deadline", (Object)string4);
            return jSONObject;
        }
        if (l3 < 100000000L || l3 > 100000000000000000L) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"response", (Object)"notifyOfIncorrectTransaction");
            jSONObject.put((Object)"message", (Object)"\"Fee\" must be at least 1 NXT!");
            jSONObject.put((Object)"recipient", (Object)string);
            jSONObject.put((Object)"amountNXT", (Object)string2);
            jSONObject.put((Object)"feeNXT", (Object)string3);
            jSONObject.put((Object)"deadline", (Object)string4);
            return jSONObject;
        }
        if (s < 1 || s > 1440) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"response", (Object)"notifyOfIncorrectTransaction");
            jSONObject.put((Object)"message", (Object)"\"Deadline\" must be greater or equal to 1 minute and less than 24 hours!");
            jSONObject.put((Object)"recipient", (Object)string);
            jSONObject.put((Object)"amountNXT", (Object)string2);
            jSONObject.put((Object)"feeNXT", (Object)string3);
            jSONObject.put((Object)"deadline", (Object)string4);
            return jSONObject;
        }
        Account account = Account.getAccount(user.getPublicKey());
        if (account == null || Math.addExact(l2, l3) > account.getUnconfirmedBalanceNQT()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"response", (Object)"notifyOfIncorrectTransaction");
            jSONObject.put((Object)"message", (Object)"Not enough funds!");
            jSONObject.put((Object)"recipient", (Object)string);
            jSONObject.put((Object)"amountNXT", (Object)string2);
            jSONObject.put((Object)"feeNXT", (Object)string3);
            jSONObject.put((Object)"deadline", (Object)string4);
            return jSONObject;
        }
        Transaction transaction = Nxt.newTransactionBuilder(user.getPublicKey(), l2, l3, s, Attachment.ORDINARY_PAYMENT).recipientId(l).build(string5);
        Nxt.getTransactionProcessor().broadcast(transaction);
        return JSONResponses.NOTIFY_OF_ACCEPTED_TRANSACTION;
    }

    @Override
    boolean requirePost() {
        return true;
    }
}

