/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.pkg.ZipContainerDetector;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractPOIFSExtractor {
    private static final Log logger = LogFactory.getLog(AbstractPOIFSExtractor.class);
    private final EmbeddedDocumentExtractor extractor;
    private PasswordProvider passwordProvider;
    private TikaConfig tikaConfig;
    private MimeTypes mimeTypes;
    private Detector detector;
    private Metadata metadata;

    protected AbstractPOIFSExtractor(ParseContext context) {
        this(context, null);
    }

    protected AbstractPOIFSExtractor(ParseContext context, Metadata metadata) {
        EmbeddedDocumentExtractor ex = (EmbeddedDocumentExtractor)context.get(EmbeddedDocumentExtractor.class);
        this.extractor = ex == null ? new ParsingEmbeddedDocumentExtractor(context) : ex;
        this.passwordProvider = (PasswordProvider)context.get(PasswordProvider.class);
        this.tikaConfig = (TikaConfig)context.get(TikaConfig.class);
        this.mimeTypes = (MimeTypes)context.get(MimeTypes.class);
        this.detector = (Detector)context.get(Detector.class);
        this.metadata = metadata;
    }

    protected TikaConfig getTikaConfig() {
        if (this.tikaConfig == null) {
            this.tikaConfig = TikaConfig.getDefaultConfig();
        }
        return this.tikaConfig;
    }

    protected Detector getDetector() {
        if (this.detector != null) {
            return this.detector;
        }
        this.detector = this.getTikaConfig().getDetector();
        return this.detector;
    }

    protected MimeTypes getMimeTypes() {
        if (this.mimeTypes != null) {
            return this.mimeTypes;
        }
        this.mimeTypes = this.getTikaConfig().getMimeRepository();
        return this.mimeTypes;
    }

    protected String getPassword() {
        if (this.passwordProvider != null) {
            return this.passwordProvider.getPassword(this.metadata);
        }
        return null;
    }

    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String relationshipID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedResource(resource, filename, relationshipID, null, mediaType, xhtml, outputHtml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String relationshipID, ClassID storageClassID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        try {
            Metadata metadata = new Metadata();
            if (filename != null) {
                metadata.set("tika.mime.file", filename);
                metadata.set("resourceName", filename);
            }
            if (relationshipID != null) {
                metadata.set("embeddedRelationshipId", relationshipID);
            }
            if (storageClassID != null) {
                metadata.set("embeddedStorageClassId", storageClassID.toString());
            }
            if (mediaType != null) {
                metadata.set("Content-Type", mediaType);
            }
            if (this.extractor.shouldParseEmbedded(metadata)) {
                this.extractor.parseEmbedded((InputStream)resource, (ContentHandler)xhtml, metadata, outputHtml);
            }
        }
        finally {
            resource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedOfficeDoc(DirectoryEntry dir, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        if (dir.hasEntry("Package")) {
            Entry ooxml = dir.getEntry("Package");
            try (TikaInputStream stream = TikaInputStream.get((InputStream)new DocumentInputStream((DocumentEntry)ooxml));){
                ZipContainerDetector detector = new ZipContainerDetector();
                MediaType type = detector.detect((InputStream)stream, new Metadata());
                this.handleEmbeddedResource(stream, null, dir.getName(), dir.getStorageClsid(), type.toString(), xhtml, true);
                return;
            }
        }
        Metadata metadata = new Metadata();
        metadata.set("embeddedRelationshipId", dir.getName());
        if (dir.getStorageClsid() != null) {
            metadata.set("embeddedStorageClassId", dir.getStorageClsid().toString());
        }
        OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(dir);
        try (TikaInputStream embedded = null;){
            if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
                try {
                    Ole10Native ole = Ole10Native.createFromEmbeddedOleObject((DirectoryNode)((DirectoryNode)dir));
                    if (ole.getLabel() != null) {
                        metadata.set("resourceName", dir.getName() + '/' + ole.getLabel());
                    }
                    byte[] data = ole.getDataBuffer();
                    embedded = TikaInputStream.get((byte[])data);
                }
                catch (Ole10NativeException ole) {
                }
                catch (Exception e) {
                    logger.warn((Object)("Ignoring unexpected exception while parsing possible OLE10_NATIVE embedded document " + dir.getName()), (Throwable)e);
                }
            } else {
                if (type == OfficeParser.POIFSDocumentType.COMP_OBJ) {
                    try {
                        DocumentEntry contentsEntry;
                        try {
                            contentsEntry = (DocumentEntry)dir.getEntry("CONTENTS");
                        }
                        catch (FileNotFoundException ioe) {
                            contentsEntry = (DocumentEntry)dir.getEntry("Contents");
                        }
                        DocumentInputStream inp = new DocumentInputStream(contentsEntry);
                        byte[] contents = new byte[contentsEntry.getSize()];
                        inp.readFully(contents);
                        embedded = TikaInputStream.get((byte[])contents);
                        MediaType mediaType = this.getDetector().detect((InputStream)embedded, new Metadata());
                        String extension = type.getExtension();
                        try {
                            MimeType mimeType = this.getMimeTypes().forName(mediaType.toString());
                            extension = mimeType.getExtension();
                        }
                        catch (MimeTypeException mimeTypeException) {
                            // empty catch block
                        }
                        metadata.set("Content-Type", mediaType.getType().toString());
                        metadata.set("resourceName", dir.getName() + extension);
                    }
                    catch (Exception e) {
                        throw new TikaException("Invalid embedded resource", (Throwable)e);
                    }
                }
                metadata.set("Content-Type", type.getType().toString());
                metadata.set("resourceName", dir.getName() + '.' + type.getExtension());
            }
            if (this.extractor.shouldParseEmbedded(metadata)) {
                if (embedded == null) {
                    embedded = TikaInputStream.get((byte[])new byte[0]);
                    embedded.setOpenContainer((Object)dir);
                }
                this.extractor.parseEmbedded((InputStream)embedded, (ContentHandler)xhtml, metadata, true);
            }
        }
    }
}

