/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Block;
import nxt.BlockDb;
import nxt.BlockchainImpl;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Generator;
import nxt.NxtException;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

final class BlockImpl
implements Block {
    private final int version;
    private final int timestamp;
    private final long previousBlockId;
    private volatile byte[] generatorPublicKey;
    private final byte[] previousBlockHash;
    private final long totalAmountNQT;
    private final long totalFeeNQT;
    private final int payloadLength;
    private final byte[] generationSignature;
    private final byte[] payloadHash;
    private volatile List<TransactionImpl> blockTransactions;
    private byte[] blockSignature;
    private BigInteger cumulativeDifficulty = BigInteger.ZERO;
    private long baseTarget = 153722867L;
    private volatile long nextBlockId;
    private int height = -1;
    private volatile long id;
    private volatile String stringId = null;
    private volatile long generatorId;
    private volatile byte[] bytes = null;
    private volatile boolean hasValidSignature = false;
    private static final long[] badBlocks = new long[]{5113090348579089956L, 8032405266942971936L, 7702042872885598917L, -407022268390237559L, -3320029330888410250L, -6568770202903512165L, 4288642518741472722L, 5315076199486616536L, -6175599071600228543L};

    BlockImpl(int n, int n2, long l, long l2, long l3, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, List<TransactionImpl> list, String string) {
        this(n, n2, l, l2, l3, n3, byArray, byArray2, byArray3, null, byArray4, list);
        this.blockSignature = Crypto.sign(this.bytes(), string);
        this.bytes = null;
    }

    BlockImpl(int n, int n2, long l, long l2, long l3, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, List<TransactionImpl> list) {
        this.version = n;
        this.timestamp = n2;
        this.previousBlockId = l;
        this.totalAmountNQT = l2;
        this.totalFeeNQT = l3;
        this.payloadLength = n3;
        this.payloadHash = byArray;
        this.generatorPublicKey = byArray2;
        this.generationSignature = byArray3;
        this.blockSignature = byArray4;
        this.previousBlockHash = byArray5;
        if (list != null) {
            this.blockTransactions = Collections.unmodifiableList(list);
        }
    }

    BlockImpl(int n, int n2, long l, long l2, long l3, int n3, byte[] byArray, long l4, byte[] byArray2, byte[] byArray3, byte[] byArray4, BigInteger bigInteger, long l5, long l6, int n4, long l7, List<TransactionImpl> list) {
        this(n, n2, l, l2, l3, n3, byArray, null, byArray2, byArray3, byArray4, null);
        this.cumulativeDifficulty = bigInteger;
        this.baseTarget = l5;
        this.nextBlockId = l6;
        this.height = n4;
        this.id = l7;
        this.generatorId = l4;
        this.blockTransactions = list;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getPreviousBlockId() {
        return this.previousBlockId;
    }

    @Override
    public byte[] getGeneratorPublicKey() {
        if (this.generatorPublicKey == null) {
            this.generatorPublicKey = Account.getPublicKey(this.generatorId);
        }
        return this.generatorPublicKey;
    }

    @Override
    public byte[] getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    @Override
    public long getTotalAmountNQT() {
        return this.totalAmountNQT;
    }

    @Override
    public long getTotalFeeNQT() {
        return this.totalFeeNQT;
    }

    @Override
    public int getPayloadLength() {
        return this.payloadLength;
    }

    @Override
    public byte[] getPayloadHash() {
        return this.payloadHash;
    }

    @Override
    public byte[] getGenerationSignature() {
        return this.generationSignature;
    }

    @Override
    public byte[] getBlockSignature() {
        return this.blockSignature;
    }

    public List<TransactionImpl> getTransactions() {
        if (this.blockTransactions == null) {
            List<TransactionImpl> list = Collections.unmodifiableList(TransactionDb.findBlockTransactions(this.getId()));
            for (TransactionImpl transactionImpl : list) {
                transactionImpl.setBlock(this);
            }
            this.blockTransactions = list;
        }
        return this.blockTransactions;
    }

    @Override
    public long getBaseTarget() {
        return this.baseTarget;
    }

    @Override
    public BigInteger getCumulativeDifficulty() {
        return this.cumulativeDifficulty;
    }

    @Override
    public long getNextBlockId() {
        return this.nextBlockId;
    }

    void setNextBlockId(long l) {
        this.nextBlockId = l;
    }

    @Override
    public int getHeight() {
        if (this.height == -1) {
            throw new IllegalStateException("Block height not yet set");
        }
        return this.height;
    }

    @Override
    public long getId() {
        if (this.id == 0L) {
            if (this.blockSignature == null) {
                throw new IllegalStateException("Block is not signed yet");
            }
            byte[] byArray = Crypto.sha256().digest(this.bytes());
            BigInteger bigInteger = new BigInteger(1, new byte[]{byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]});
            this.id = bigInteger.longValue();
            this.stringId = bigInteger.toString();
        }
        return this.id;
    }

    @Override
    public String getStringId() {
        if (this.stringId == null) {
            this.getId();
            if (this.stringId == null) {
                this.stringId = Long.toUnsignedString(this.id);
            }
        }
        return this.stringId;
    }

    @Override
    public long getGeneratorId() {
        if (this.generatorId == 0L) {
            this.generatorId = Account.getId(this.getGeneratorPublicKey());
        }
        return this.generatorId;
    }

    public boolean equals(Object object) {
        return object instanceof BlockImpl && this.getId() == ((BlockImpl)object).getId();
    }

    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    @Override
    public JSONObject getJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"version", (Object)this.version);
        jSONObject.put((Object)"timestamp", (Object)this.timestamp);
        jSONObject.put((Object)"previousBlock", (Object)Long.toUnsignedString(this.previousBlockId));
        jSONObject.put((Object)"totalAmountNQT", (Object)this.totalAmountNQT);
        jSONObject.put((Object)"totalFeeNQT", (Object)this.totalFeeNQT);
        jSONObject.put((Object)"payloadLength", (Object)this.payloadLength);
        jSONObject.put((Object)"payloadHash", (Object)Convert.toHexString(this.payloadHash));
        jSONObject.put((Object)"generatorPublicKey", (Object)Convert.toHexString(this.getGeneratorPublicKey()));
        jSONObject.put((Object)"generationSignature", (Object)Convert.toHexString(this.generationSignature));
        if (this.version > 1) {
            jSONObject.put((Object)"previousBlockHash", (Object)Convert.toHexString(this.previousBlockHash));
        }
        jSONObject.put((Object)"blockSignature", (Object)Convert.toHexString(this.blockSignature));
        JSONArray jSONArray = new JSONArray();
        this.getTransactions().forEach(transactionImpl -> jSONArray.add((Object)transactionImpl.getJSONObject()));
        jSONObject.put((Object)"transactions", (Object)jSONArray);
        return jSONObject;
    }

    static BlockImpl parseBlock(JSONObject jSONObject) throws NxtException.NotValidException {
        try {
            int n = ((Long)jSONObject.get((Object)"version")).intValue();
            int n2 = ((Long)jSONObject.get((Object)"timestamp")).intValue();
            long l = Convert.parseUnsignedLong((String)jSONObject.get((Object)"previousBlock"));
            long l2 = Convert.parseLong(jSONObject.get((Object)"totalAmountNQT"));
            long l3 = Convert.parseLong(jSONObject.get((Object)"totalFeeNQT"));
            int n3 = ((Long)jSONObject.get((Object)"payloadLength")).intValue();
            byte[] byArray = Convert.parseHexString((String)jSONObject.get((Object)"payloadHash"));
            byte[] byArray2 = Convert.parseHexString((String)jSONObject.get((Object)"generatorPublicKey"));
            byte[] byArray3 = Convert.parseHexString((String)jSONObject.get((Object)"generationSignature"));
            byte[] byArray4 = Convert.parseHexString((String)jSONObject.get((Object)"blockSignature"));
            byte[] byArray5 = n == 1 ? null : Convert.parseHexString((String)jSONObject.get((Object)"previousBlockHash"));
            ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
            for (Object e : (JSONArray)jSONObject.get((Object)"transactions")) {
                arrayList.add(TransactionImpl.parseTransaction((JSONObject)e));
            }
            BlockImpl blockImpl = new BlockImpl(n, n2, l, l2, l3, n3, byArray, byArray2, byArray3, byArray4, byArray5, arrayList);
            if (!super.checkSignature()) {
                throw new NxtException.NotValidException("Invalid block signature");
            }
            return blockImpl;
        }
        catch (RuntimeException | NxtException.NotValidException exception) {
            Logger.logDebugMessage("Failed to parse block: " + jSONObject.toJSONString());
            throw exception;
        }
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes(), this.bytes.length);
    }

    byte[] bytes() {
        if (this.bytes == null) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(20 + (this.version < 3 ? 8 : 16) + 4 + 32 + 32 + 64 + (this.blockSignature != null ? 64 : 0));
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(this.version);
            byteBuffer.putInt(this.timestamp);
            byteBuffer.putLong(this.previousBlockId);
            byteBuffer.putInt(this.getTransactions().size());
            if (this.version < 3) {
                byteBuffer.putInt((int)(this.totalAmountNQT / 100000000L));
                byteBuffer.putInt((int)(this.totalFeeNQT / 100000000L));
            } else {
                byteBuffer.putLong(this.totalAmountNQT);
                byteBuffer.putLong(this.totalFeeNQT);
            }
            byteBuffer.putInt(this.payloadLength);
            byteBuffer.put(this.payloadHash);
            byteBuffer.put(this.getGeneratorPublicKey());
            byteBuffer.put(this.generationSignature);
            if (this.version > 1) {
                byteBuffer.put(this.previousBlockHash);
            }
            if (this.blockSignature != null) {
                byteBuffer.put(this.blockSignature);
            }
            this.bytes = byteBuffer.array();
        }
        return this.bytes;
    }

    boolean verifyBlockSignature() {
        return this.checkSignature() && Account.setOrVerify(this.getGeneratorId(), this.getGeneratorPublicKey());
    }

    private boolean checkSignature() {
        if (!this.hasValidSignature) {
            byte[] byArray = Arrays.copyOf(this.bytes(), this.bytes.length - 64);
            this.hasValidSignature = this.blockSignature != null && Crypto.verify(this.blockSignature, byArray, this.getGeneratorPublicKey(), this.version >= 3);
        }
        return this.hasValidSignature;
    }

    boolean verifyGenerationSignature() throws BlockchainProcessor.BlockOutOfOrderException {
        try {
            byte[] byArray;
            long l;
            BlockImpl blockImpl = BlockchainImpl.getInstance().getBlock(this.getPreviousBlockId());
            if (blockImpl == null) {
                throw new BlockchainProcessor.BlockOutOfOrderException("Can't verify signature because previous block is missing", this);
            }
            if (this.version == 1 && !Crypto.verify(this.generationSignature, blockImpl.generationSignature, this.getGeneratorPublicKey(), false)) {
                return false;
            }
            Account account = Account.getAccount(this.getGeneratorId());
            long l2 = l = account == null ? 0L : account.getEffectiveBalanceNXT();
            if (l <= 0L) {
                return false;
            }
            MessageDigest messageDigest = Crypto.sha256();
            if (this.version == 1) {
                byArray = messageDigest.digest(this.generationSignature);
            } else {
                messageDigest.update(blockImpl.generationSignature);
                byArray = messageDigest.digest(this.getGeneratorPublicKey());
                if (!Arrays.equals(this.generationSignature, byArray)) {
                    return false;
                }
            }
            BigInteger bigInteger = new BigInteger(1, new byte[]{byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]});
            return Generator.verifyHit(bigInteger, BigInteger.valueOf(l), blockImpl, this.timestamp) || this.height < 67000 && Arrays.binarySearch(badBlocks, this.getId()) >= 0;
        }
        catch (RuntimeException runtimeException) {
            Logger.logMessage("Error verifying block generation signature", runtimeException);
            return false;
        }
    }

    void apply() {
        Account account = Account.addOrGetAccount(this.getGeneratorId());
        account.apply(this.getGeneratorPublicKey());
        long l = 0L;
        if (this.height > Math.max(Constants.SHUFFLING_BLOCK, 3)) {
            long[] lArray = new long[3];
            for (TransactionImpl object : this.getTransactions()) {
                long[] lArray2 = object.getBackFees();
                for (int i = 0; i < lArray2.length; ++i) {
                    int n = i;
                    lArray[n] = lArray[n] + lArray2[i];
                }
            }
            for (int i = 0; i < lArray.length && lArray[i] != 0L; ++i) {
                l += lArray[i];
                Account account2 = Account.getAccount(BlockDb.findBlockAtHeight(this.height - i - 1).getGeneratorId());
                Logger.logDebugMessage("Back fees %f NXT to forger at height %d", (double)lArray[i] / 1.0E8, this.height - i - 1);
                account2.addToBalanceAndUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.BLOCK_GENERATED, this.getId(), lArray[i]);
                account2.addToForgedBalanceNQT(lArray[i]);
            }
        }
        if (l != 0L) {
            Logger.logDebugMessage("Fee reduced by %f NXT at height %d", (double)l / 1.0E8, this.height);
        }
        account.addToBalanceAndUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.BLOCK_GENERATED, this.getId(), this.totalFeeNQT - l);
        account.addToForgedBalanceNQT(this.totalFeeNQT - l);
    }

    void setPrevious(BlockImpl blockImpl) {
        if (blockImpl != null) {
            if (blockImpl.getId() != this.getPreviousBlockId()) {
                throw new IllegalStateException("Previous block id doesn't match");
            }
            this.height = blockImpl.getHeight() + 1;
            this.calculateBaseTarget(blockImpl);
        } else {
            this.height = 0;
        }
        int n = 0;
        for (TransactionImpl transactionImpl : this.getTransactions()) {
            transactionImpl.setBlock(this);
            int n2 = n;
            n = (short)(n + 1);
            transactionImpl.setIndex(n2);
        }
    }

    void loadTransactions() {
        for (TransactionImpl transactionImpl : this.getTransactions()) {
            transactionImpl.bytes();
            transactionImpl.getAppendages();
        }
    }

    private void calculateBaseTarget(BlockImpl blockImpl) {
        long l = blockImpl.baseTarget;
        if (blockImpl.getHeight() < Math.max(Constants.SHUFFLING_BLOCK, 3)) {
            long l2;
            this.baseTarget = BigInteger.valueOf(l).multiply(BigInteger.valueOf(this.timestamp - blockImpl.timestamp)).divide(BigInteger.valueOf(60L)).longValue();
            if (this.baseTarget < 0L || this.baseTarget > 153722867000000000L) {
                this.baseTarget = 153722867000000000L;
            }
            if (this.baseTarget < l / 2L) {
                this.baseTarget = l / 2L;
            }
            if (this.baseTarget == 0L) {
                this.baseTarget = 1L;
            }
            if ((l2 = l * 2L) < 0L) {
                l2 = 153722867000000000L;
            }
            if (this.baseTarget > l2) {
                this.baseTarget = l2;
            }
        } else if (blockImpl.getHeight() % 2 == 0) {
            BlockImpl blockImpl2 = BlockDb.findBlockAtHeight(blockImpl.getHeight() - 2);
            int n = (this.timestamp - blockImpl2.timestamp) / 3;
            this.baseTarget = n > 60 ? l * (long)Math.min(n, 67) / 60L : l - l * 64L * (long)(60 - Math.max(n, 53)) / 6000L;
            if (this.baseTarget < 0L || this.baseTarget > Constants.MAX_BASE_TARGET_2) {
                this.baseTarget = Constants.MAX_BASE_TARGET_2;
            }
            if (this.baseTarget < 138350580L) {
                this.baseTarget = 138350580L;
            }
        } else {
            this.baseTarget = l;
        }
        this.cumulativeDifficulty = blockImpl.cumulativeDifficulty.add(Convert.two64.divide(BigInteger.valueOf(this.baseTarget)));
    }

    static {
        Arrays.sort(badBlocks);
    }
}

