/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Account;
import nxt.Attachment;
import nxt.Currency;
import nxt.CurrencyBuyOffer;
import nxt.CurrencyExchangeOffer;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;

public final class CurrencySellOffer
extends CurrencyExchangeOffer {
    private static final DbKey.LongKeyFactory<CurrencySellOffer> sellOfferDbKeyFactory = new DbKey.LongKeyFactory<CurrencySellOffer>("id"){

        @Override
        public DbKey newKey(CurrencySellOffer currencySellOffer) {
            return currencySellOffer.dbKey;
        }
    };
    private static final VersionedEntityDbTable<CurrencySellOffer> sellOfferTable = new VersionedEntityDbTable<CurrencySellOffer>("sell_offer", sellOfferDbKeyFactory){

        @Override
        protected CurrencySellOffer load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new CurrencySellOffer(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, CurrencySellOffer currencySellOffer) throws SQLException {
            currencySellOffer.save(connection, this.table);
        }
    };
    private final DbKey dbKey;

    public static int getCount() {
        return sellOfferTable.getCount();
    }

    public static CurrencySellOffer getOffer(long l) {
        return (CurrencySellOffer)sellOfferTable.get(sellOfferDbKeyFactory.newKey(l));
    }

    public static DbIterator<CurrencySellOffer> getAll(int n, int n2) {
        return sellOfferTable.getAll(n, n2);
    }

    public static DbIterator<CurrencySellOffer> getOffers(Currency currency, int n, int n2) {
        return CurrencySellOffer.getCurrencyOffers(currency.getId(), false, n, n2);
    }

    public static DbIterator<CurrencySellOffer> getCurrencyOffers(long l, boolean bl, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("currency_id", l);
        if (bl) {
            dbClause = dbClause.and(availableOnlyDbClause);
        }
        return sellOfferTable.getManyBy(dbClause, n, n2, " ORDER BY rate ASC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    public static DbIterator<CurrencySellOffer> getAccountOffers(long l, boolean bl, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("account_id", l);
        if (bl) {
            dbClause = dbClause.and(availableOnlyDbClause);
        }
        return sellOfferTable.getManyBy(dbClause, n, n2, " ORDER BY rate ASC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    public static CurrencySellOffer getOffer(Currency currency, Account account) {
        return CurrencySellOffer.getOffer(currency.getId(), account.getId());
    }

    public static CurrencySellOffer getOffer(long l, long l2) {
        return (CurrencySellOffer)sellOfferTable.getBy(new DbClause.LongClause("currency_id", l).and(new DbClause.LongClause("account_id", l2)));
    }

    public static DbIterator<CurrencySellOffer> getOffers(DbClause dbClause, int n, int n2) {
        return sellOfferTable.getManyBy(dbClause, n, n2);
    }

    public static DbIterator<CurrencySellOffer> getOffers(DbClause dbClause, int n, int n2, String string) {
        return sellOfferTable.getManyBy(dbClause, n, n2, string);
    }

    static void addOffer(Transaction transaction, Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer) {
        sellOfferTable.insert(new CurrencySellOffer(transaction, monetarySystemPublishExchangeOffer));
    }

    static void remove(CurrencySellOffer currencySellOffer) {
        sellOfferTable.delete(currencySellOffer);
    }

    static void init() {
    }

    private CurrencySellOffer(Transaction transaction, Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer) {
        super(transaction.getId(), monetarySystemPublishExchangeOffer.getCurrencyId(), transaction.getSenderId(), monetarySystemPublishExchangeOffer.getSellRateNQT(), monetarySystemPublishExchangeOffer.getTotalSellLimit(), monetarySystemPublishExchangeOffer.getInitialSellSupply(), monetarySystemPublishExchangeOffer.getExpirationHeight(), transaction.getHeight(), transaction.getIndex());
        this.dbKey = sellOfferDbKeyFactory.newKey(this.id);
    }

    private CurrencySellOffer(ResultSet resultSet, DbKey dbKey) throws SQLException {
        super(resultSet);
        this.dbKey = dbKey;
    }

    @Override
    public CurrencyBuyOffer getCounterOffer() {
        return CurrencyBuyOffer.getOffer(this.id);
    }

    @Override
    long increaseSupply(long l) {
        long l2 = super.increaseSupply(l);
        sellOfferTable.insert(this);
        return l2;
    }

    @Override
    void decreaseLimitAndSupply(long l) {
        super.decreaseLimitAndSupply(l);
        sellOfferTable.insert(this);
    }
}

