/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import nxt.Account;
import nxt.Block;
import nxt.BlockDb;
import nxt.BlockImpl;
import nxt.Blockchain;
import nxt.BlockchainImpl;
import nxt.BlockchainProcessor;
import nxt.BlockchainProcessorImpl;
import nxt.Constants;
import nxt.Nxt;
import nxt.TransactionProcessorImpl;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.ThreadPool;

public final class Generator
implements Comparable<Generator> {
    private static final int MAX_FORGERS = Nxt.getIntProperty("nxt.maxNumberOfForgers");
    private static final List<byte[]> fakeForgingPublicKeys = Generator.getFakeForgingPublicKeys();
    private static final Listeners<Generator, Event> listeners = new Listeners();
    private static final ConcurrentMap<String, Generator> generators = new ConcurrentHashMap<String, Generator>();
    private static final Collection<Generator> allGenerators = Collections.unmodifiableCollection(generators.values());
    private static volatile List<Generator> sortedForgers = null;
    private static long lastBlockId;
    private static int delayTime;
    private static final Runnable generateBlocksThread;
    private final long accountId;
    private final String secretPhrase;
    private final byte[] publicKey;
    private volatile long hitTime;
    private volatile BigInteger hit;
    private volatile BigInteger effectiveBalance;
    private volatile long deadline;
    private static final Set<Long> activeGeneratorIds;
    private static long activeBlockId;
    private static final List<ActiveGenerator> activeGenerators;
    private static boolean generatorsInitialized;

    private static List<byte[]> getFakeForgingPublicKeys() {
        if (!Nxt.getBooleanProperty("nxt.enableFakeForging")) {
            return Collections.emptyList();
        }
        List<String> list = Nxt.getStringListProperty("nxt.fakeForgingPublicKeys");
        return list.stream().map(Convert::parseHexString).collect(Collectors.toList());
    }

    static void init() {
    }

    public static boolean addListener(Listener<Generator> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Generator> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static Generator startForging(String string) {
        if (generators.size() >= MAX_FORGERS) {
            throw new RuntimeException("Cannot forge with more than " + MAX_FORGERS + " accounts on the same node");
        }
        Generator generator = new Generator(string);
        Generator generator2 = generators.putIfAbsent(string, generator);
        if (generator2 != null) {
            Logger.logDebugMessage(generator2 + " is already forging");
            return generator2;
        }
        listeners.notify(generator, Event.START_FORGING);
        Logger.logDebugMessage(generator + " started");
        return generator;
    }

    public static Generator stopForging(String string) {
        Generator generator = (Generator)generators.remove(string);
        if (generator != null) {
            Nxt.getBlockchain().updateLock();
            try {
                sortedForgers = null;
            }
            finally {
                Nxt.getBlockchain().updateUnlock();
            }
            Logger.logDebugMessage(generator + " stopped");
            listeners.notify(generator, Event.STOP_FORGING);
        }
        return generator;
    }

    public static int stopForging() {
        int n = generators.size();
        Iterator iterator = generators.values().iterator();
        while (iterator.hasNext()) {
            Generator generator = (Generator)iterator.next();
            iterator.remove();
            Logger.logDebugMessage(generator + " stopped");
            listeners.notify(generator, Event.STOP_FORGING);
        }
        Nxt.getBlockchain().updateLock();
        try {
            sortedForgers = null;
        }
        finally {
            Nxt.getBlockchain().updateUnlock();
        }
        return n;
    }

    public static Generator getGenerator(String string) {
        return (Generator)generators.get(string);
    }

    public static int getGeneratorCount() {
        return generators.size();
    }

    public static Collection<Generator> getAllGenerators() {
        return allGenerators;
    }

    public static List<Generator> getSortedForgers() {
        List<Generator> list = sortedForgers;
        return list == null ? Collections.emptyList() : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextHitTime(long l, int n) {
        BlockchainImpl.getInstance().readLock();
        try {
            if (l == lastBlockId && sortedForgers != null) {
                for (Generator generator : sortedForgers) {
                    if (generator.getHitTime() < (long)(n - Constants.FORGING_DELAY)) continue;
                    long l2 = generator.getHitTime();
                    return l2;
                }
            }
            long l3 = 0L;
            return l3;
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
    }

    static void setDelay(int n) {
        delayTime = n;
    }

    static boolean verifyHit(BigInteger bigInteger, BigInteger bigInteger2, Block block, int n) {
        int n2 = n - block.getTimestamp();
        if (n2 <= 0) {
            return false;
        }
        BigInteger bigInteger3 = BigInteger.valueOf(block.getBaseTarget()).multiply(bigInteger2);
        BigInteger bigInteger4 = bigInteger3.multiply(BigInteger.valueOf(n2 - 1));
        BigInteger bigInteger5 = bigInteger4.add(bigInteger3);
        return bigInteger.compareTo(bigInteger5) < 0 && (block.getHeight() < Constants.TRANSPARENT_FORGING_BLOCK_8 || bigInteger.compareTo(bigInteger4) >= 0 || (!Constants.isTestnet ? n2 > 3600 : n2 > 300) || Constants.isOffline);
    }

    static boolean allowsFakeForging(byte[] byArray) {
        return Constants.isTestnet && byArray != null && fakeForgingPublicKeys.stream().anyMatch(byArray2 -> Arrays.equals(byArray2, byArray));
    }

    static BigInteger getHit(byte[] byArray, Block block) {
        if (Generator.allowsFakeForging(byArray)) {
            return BigInteger.ZERO;
        }
        if (block.getHeight() < Constants.TRANSPARENT_FORGING_BLOCK) {
            throw new IllegalArgumentException("Not supported below Transparent Forging Block");
        }
        MessageDigest messageDigest = Crypto.sha256();
        messageDigest.update(block.getGenerationSignature());
        byte[] byArray2 = messageDigest.digest(byArray);
        return new BigInteger(1, new byte[]{byArray2[7], byArray2[6], byArray2[5], byArray2[4], byArray2[3], byArray2[2], byArray2[1], byArray2[0]});
    }

    static long getHitTime(BigInteger bigInteger, BigInteger bigInteger2, Block block) {
        return (long)block.getTimestamp() + bigInteger2.divide(BigInteger.valueOf(block.getBaseTarget()).multiply(bigInteger)).longValue();
    }

    private Generator(String string) {
        this.secretPhrase = string;
        this.publicKey = Crypto.getPublicKey(string);
        this.accountId = Account.getId(this.publicKey);
        Nxt.getBlockchain().updateLock();
        try {
            if (Nxt.getBlockchain().getHeight() >= Constants.LAST_KNOWN_BLOCK) {
                this.setLastBlock(Nxt.getBlockchain().getLastBlock());
            }
            sortedForgers = null;
        }
        finally {
            Nxt.getBlockchain().updateUnlock();
        }
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public long getHitTime() {
        return this.hitTime;
    }

    @Override
    public int compareTo(Generator generator) {
        int n = this.hit.multiply(generator.effectiveBalance).compareTo(generator.hit.multiply(this.effectiveBalance));
        if (n != 0) {
            return n;
        }
        return Long.compare(this.accountId, generator.accountId);
    }

    public String toString() {
        return "Forger " + Long.toUnsignedString(this.accountId) + " deadline " + this.getDeadline() + " hit " + this.hitTime;
    }

    private void setLastBlock(Block block) {
        int n = block.getHeight();
        Account account = Account.getAccount(this.accountId, n);
        this.effectiveBalance = account == null ? BigInteger.ZERO : BigInteger.valueOf(Math.max(account.getEffectiveBalanceNXT(n), 0L));
        if (this.effectiveBalance.signum() == 0) {
            this.hitTime = 0L;
            this.hit = BigInteger.ZERO;
            return;
        }
        this.hit = Generator.getHit(this.publicKey, block);
        this.hitTime = Generator.getHitTime(this.effectiveBalance, this.hit, block);
        this.deadline = Math.max(this.hitTime - (long)block.getTimestamp(), 0L);
        listeners.notify(this, Event.GENERATION_DEADLINE);
    }

    boolean forge(Block block, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        int n2 = this.getTimestamp(n);
        if (!Generator.verifyHit(this.hit, this.effectiveBalance, block, n2)) {
            Logger.logDebugMessage(this.toString() + " failed to forge at " + n2 + " height " + block.getHeight() + " last timestamp " + block.getTimestamp());
            return false;
        }
        int n3 = Nxt.getEpochTime();
        while (true) {
            try {
                BlockchainProcessorImpl.getInstance().generateBlock(this.secretPhrase, n2);
                Generator.setDelay(Constants.FORGING_DELAY);
                return true;
            }
            catch (BlockchainProcessor.TransactionNotAcceptedException transactionNotAcceptedException) {
                if (Nxt.getEpochTime() - n3 <= 10) continue;
                throw transactionNotAcceptedException;
            }
            break;
        }
    }

    private int getTimestamp(int n) {
        return (long)n - this.hitTime > 3600L ? n : (int)this.hitTime + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ActiveGenerator> getNextGenerators() {
        ArrayList<ActiveGenerator> arrayList;
        Blockchain blockchain = Nxt.getBlockchain();
        List<ActiveGenerator> list = activeGenerators;
        synchronized (list) {
            long l2;
            if (!generatorsInitialized) {
                activeGeneratorIds.addAll(BlockDb.getBlockGenerators(Math.max(1, blockchain.getHeight() - 10000)));
                activeGeneratorIds.forEach(l -> activeGenerators.add(new ActiveGenerator((long)l)));
                Logger.logDebugMessage(activeGeneratorIds.size() + " block generators found");
                Nxt.getBlockchainProcessor().addListener(block -> {
                    long l = block.getGeneratorId();
                    List<ActiveGenerator> list = activeGenerators;
                    synchronized (list) {
                        if (!activeGeneratorIds.contains(l)) {
                            activeGeneratorIds.add(l);
                            activeGenerators.add(new ActiveGenerator(l));
                        }
                    }
                }, BlockchainProcessor.Event.BLOCK_PUSHED);
                generatorsInitialized = true;
            }
            if ((l2 = blockchain.getLastBlock().getId()) != activeBlockId) {
                activeBlockId = l2;
                Block block2 = blockchain.getLastBlock();
                for (ActiveGenerator activeGenerator : activeGenerators) {
                    activeGenerator.setLastBlock(block2);
                }
                Collections.sort(activeGenerators);
            }
            arrayList = new ArrayList<ActiveGenerator>(activeGenerators);
        }
        return arrayList;
    }

    static {
        delayTime = Constants.FORGING_DELAY;
        generateBlocksThread = new Runnable(){
            private volatile boolean logged;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        BlockchainImpl.getInstance().updateLock();
                        try {
                            Object object4;
                            Object object2;
                            Object object3 = Nxt.getBlockchain().getLastBlock();
                            if (object3 == null || object3.getHeight() < Constants.LAST_KNOWN_BLOCK) {
                                return;
                            }
                            int n = Nxt.getEpochTime() - delayTime;
                            if (object3.getId() != lastBlockId || sortedForgers == null) {
                                lastBlockId = object3.getId();
                                if (object3.getTimestamp() > Nxt.getEpochTime() - 600) {
                                    object2 = Nxt.getBlockchain().getBlock(object3.getPreviousBlockId());
                                    for (Generator generator : generators.values()) {
                                        generator.setLastBlock((Block)object2);
                                        int n2 = generator.getTimestamp(n);
                                        if (n2 == n || generator.getHitTime() <= 0L || n2 >= object3.getTimestamp()) continue;
                                        Logger.logDebugMessage("Pop off: " + generator.toString() + " will pop off last block " + object3.getStringId());
                                        List<BlockImpl> list = BlockchainProcessorImpl.getInstance().popOffTo((Block)object2);
                                        for (BlockImpl blockImpl : list) {
                                            TransactionProcessorImpl.getInstance().processLater(blockImpl.getTransactions());
                                        }
                                        object3 = object2;
                                        lastBlockId = object2.getId();
                                        break;
                                    }
                                }
                                object2 = new ArrayList();
                                object4 = generators.values().iterator();
                                while (object4.hasNext()) {
                                    Generator generator;
                                    generator = (Generator)object4.next();
                                    generator.setLastBlock((Block)object3);
                                    if (generator.effectiveBalance.signum() <= 0) continue;
                                    object2.add(generator);
                                }
                                Collections.sort(object2);
                                sortedForgers = Collections.unmodifiableList(object2);
                                this.logged = false;
                            }
                            if (!this.logged) {
                                object2 = sortedForgers.iterator();
                                while (object2.hasNext() && ((Generator)(object4 = (Generator)object2.next())).getHitTime() - (long)n <= 60L) {
                                    Logger.logDebugMessage(((Generator)object4).toString());
                                    this.logged = true;
                                }
                            }
                            for (Object object4 : sortedForgers) {
                                if (((Generator)object4).getHitTime() <= (long)n && !((Generator)object4).forge((Block)object3, n)) continue;
                                return;
                            }
                        }
                        finally {
                            BlockchainImpl.getInstance().updateUnlock();
                        }
                    }
                    catch (Exception exception) {
                        Logger.logMessage("Error in block generation thread", exception);
                    }
                }
                catch (Throwable throwable) {
                    Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString());
                    throwable.printStackTrace();
                    System.exit(1);
                }
            }
        };
        if (!Constants.isLightClient) {
            ThreadPool.scheduleThread("GenerateBlocks", generateBlocksThread, 500, TimeUnit.MILLISECONDS);
        }
        activeGeneratorIds = new HashSet<Long>();
        activeGenerators = new ArrayList<ActiveGenerator>();
        generatorsInitialized = false;
    }

    public static class ActiveGenerator
    implements Comparable<ActiveGenerator> {
        private final long accountId;
        private long hitTime;
        private long effectiveBalanceNXT;
        private byte[] publicKey;

        private ActiveGenerator(long l) {
            this.accountId = l;
            this.hitTime = Long.MAX_VALUE;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getEffectiveBalance() {
            return this.effectiveBalanceNXT;
        }

        public long getHitTime() {
            return this.hitTime;
        }

        private void setLastBlock(Block block) {
            int n;
            Account account;
            if (this.publicKey == null) {
                this.publicKey = Account.getPublicKey(this.accountId);
                if (this.publicKey == null) {
                    this.hitTime = Long.MAX_VALUE;
                    return;
                }
            }
            if ((account = Account.getAccount(this.accountId, n = block.getHeight())) == null) {
                this.hitTime = Long.MAX_VALUE;
                return;
            }
            this.effectiveBalanceNXT = Math.max(account.getEffectiveBalanceNXT(n), 0L);
            if (this.effectiveBalanceNXT == 0L) {
                this.hitTime = Long.MAX_VALUE;
                return;
            }
            BigInteger bigInteger = BigInteger.valueOf(this.effectiveBalanceNXT);
            BigInteger bigInteger2 = Generator.getHit(this.publicKey, block);
            this.hitTime = Generator.getHitTime(bigInteger, bigInteger2, block);
        }

        public int hashCode() {
            return Long.hashCode(this.accountId);
        }

        public boolean equals(Object object) {
            return object != null && object instanceof ActiveGenerator && this.accountId == ((ActiveGenerator)object).accountId;
        }

        @Override
        public int compareTo(ActiveGenerator activeGenerator) {
            return Long.compare(this.hitTime, activeGenerator.hitTime);
        }
    }

    public static enum Event {
        GENERATION_DEADLINE,
        START_FORGING,
        STOP_FORGING;

    }
}

