/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import nxt.Account;
import nxt.Block;
import nxt.BlockchainProcessor;
import nxt.Db;
import nxt.FxtDistribution;
import nxt.Nxt;
import nxt.NxtException;
import nxt.addons.AddOn;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Listener;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public final class JPLSnapshot
implements AddOn {
    @Override
    public APIServlet.APIRequestHandler getAPIRequestHandler() {
        return new JPLSnapshotAPI("newGenesisAccounts", new APITag[]{APITag.ADDONS}, new String[]{"height"});
    }

    @Override
    public String getAPIRequestType() {
        return "downloadJPLSnapshot";
    }

    private static class JPLSnapshotListener
    implements Listener<Block> {
        private final int height;
        private final JSONObject inputJSON;
        private final SortedMap<String, Object> snapshot = new TreeMap<String, Object>();

        private JPLSnapshotListener(int n, JSONObject jSONObject) {
            this.height = n;
            this.inputJSON = jSONObject;
        }

        @Override
        public void notify(Block block) {
            if (block.getHeight() == this.height) {
                SortedMap<String, String> sortedMap = this.snapshotPublicKeys();
                JSONArray jSONArray = (JSONArray)this.inputJSON.get((Object)"publicKeys");
                if (jSONArray != null) {
                    Logger.logInfoMessage("Loading " + jSONArray.size() + " input public keys");
                    jSONArray.forEach(object -> {
                        String string = Long.toUnsignedString(Account.getId(Convert.parseHexString((String)object)));
                        String string2 = sortedMap.putIfAbsent(string, (String)object);
                        if (string2 != null && !string2.equals(object)) {
                            throw new RuntimeException("Public key collision, input " + object + ", snapshot contains " + string2);
                        }
                    });
                }
                JSONArray jSONArray2 = new JSONArray();
                jSONArray2.addAll(sortedMap.values());
                this.snapshot.put("publicKeys", jSONArray2);
                SortedMap<String, Long> sortedMap2 = this.snapshotNxtBalances();
                BigInteger bigInteger = BigInteger.valueOf(sortedMap2.values().stream().mapToLong(Long::longValue).sum());
                JSONObject jSONObject = (JSONObject)this.inputJSON.get((Object)"balances");
                if (jSONObject != null) {
                    Logger.logInfoMessage("Loading " + jSONObject.size() + " input account balances");
                    BigInteger bigInteger2 = BigInteger.valueOf(jSONObject.values().stream().mapToLong(object -> (Long)object).sum());
                    if (!bigInteger2.equals(BigInteger.ZERO)) {
                        sortedMap2.entrySet().forEach(entry -> {
                            long l = (Long)entry.getValue();
                            long l2 = Convert.longValueExact(BigInteger.valueOf(l).multiply(bigInteger2).divide(bigInteger).divide(BigInteger.valueOf(9L)));
                            entry.setValue(l2);
                        });
                    }
                    jSONObject.entrySet().forEach(object -> {
                        long l3 = Convert.parseAccountId((String)((Map.Entry)object).getKey());
                        String string = Long.toUnsignedString(l3);
                        long l4 = (Long)((Map.Entry)object).getValue();
                        sortedMap2.merge(string, l4, (l, l2) -> l + l2);
                    });
                }
                this.snapshot.put("balances", sortedMap2);
            }
        }

        private SortedMap<String, Object> getSnapshot() {
            return this.snapshot;
        }

        private SortedMap<String, String> snapshotPublicKeys() {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            try (Connection connection = Db.db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT public_key FROM public_key WHERE public_key IS NOT NULL AND height <= ? ORDER by account_id");){
                preparedStatement.setInt(1, this.height);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        byte[] byArray = resultSet.getBytes("public_key");
                        long l = Account.getId(byArray);
                        treeMap.put(Long.toUnsignedString(l), Convert.toHexString(byArray));
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.getMessage(), sQLException);
            }
            return treeMap;
        }

        private SortedMap<String, Long> snapshotNxtBalances() {
            TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
            try (Connection connection = Db.db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT id, balance FROM account WHERE LATEST=true");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long l = resultSet.getLong("id");
                    if (l == FxtDistribution.FXT_ISSUER_ID) {
                        Logger.logInfoMessage("Skip FXT issuer balance of " + resultSet.getLong("balance"));
                        continue;
                    }
                    long l2 = resultSet.getLong("balance");
                    if (l2 <= 0L) {
                        if (l2 >= 0L) continue;
                        Logger.logInfoMessage("Skip negative balance of " + l2);
                        continue;
                    }
                    String string = Long.toUnsignedString(l);
                    treeMap.put(string, l2);
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.getMessage(), sQLException);
            }
            return treeMap;
        }
    }

    public static class JPLSnapshotAPI
    extends APIServlet.APIRequestHandler {
        private JPLSnapshotAPI(String string, APITag[] aPITagArray, String ... stringArray) {
            super(string, aPITagArray, stringArray);
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NxtException {
            Object object;
            Object object2;
            Object object3;
            int n = ParameterParser.getHeight(httpServletRequest);
            if (n <= 0 || n > Nxt.getBlockchain().getHeight()) {
                return JSONResponses.INCORRECT_HEIGHT;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                object3 = httpServletRequest.getPart("newGenesisAccounts");
                if (object3 != null && !((String)(object2 = Convert.toString(((ParameterParser.FileData)(object = new ParameterParser.FileData((Part)object3).invoke())).getData()))).trim().isEmpty()) {
                    jSONObject = (JSONObject)JSONValue.parseWithException((String)object2);
                }
            }
            catch (IOException | ServletException | ParseException throwable) {
                return JSONResponses.INCORRECT_FILE;
            }
            object3 = new JPLSnapshotListener(n, jSONObject);
            Nxt.getBlockchainProcessor().addListener(object3, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
            Nxt.getBlockchainProcessor().scan(n - 1, false);
            Nxt.getBlockchainProcessor().removeListener(object3, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
            object = new StringBuilder(1024);
            JSON.encodeObject(((JPLSnapshotListener)object3).getSnapshot(), (StringBuilder)object);
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=genesisAccounts.json");
            httpServletResponse.setContentLength(((StringBuilder)object).length());
            httpServletResponse.setCharacterEncoding("UTF-8");
            try {
                object2 = httpServletResponse.getWriter();
                Throwable throwable = null;
                try {
                    ((PrintWriter)object2).write(((StringBuilder)object).toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object2 != null) {
                        if (throwable != null) {
                            try {
                                ((PrintWriter)object2).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((PrintWriter)object2).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                return JSONResponses.RESPONSE_WRITE_ERROR;
            }
            return null;
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean requirePost() {
            return true;
        }

        @Override
        protected boolean requirePassword() {
            return true;
        }

        @Override
        protected boolean requireFullClient() {
            return true;
        }

        @Override
        protected boolean allowRequiredBlockParameters() {
            return false;
        }
    }
}

