/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import nxt.Constants;
import nxt.Db;
import nxt.db.TransactionalDb;
import nxt.util.Logger;
import nxt.util.ReadWriteUpdateLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.h2.api.Trigger;
import org.h2.tools.SimpleResultSet;

public class FullTextTrigger
implements Trigger,
TransactionalDb.TransactionCallback {
    private static volatile boolean isActive = false;
    private static final ConcurrentHashMap<String, FullTextTrigger> indexTriggers = new ConcurrentHashMap();
    private static final FileSystem fileSystem = FileSystems.getDefault();
    private static final ReadWriteUpdateLock indexLock = new ReadWriteUpdateLock();
    private static Path indexPath;
    private static Directory directory;
    private static DirectoryReader indexReader;
    private static IndexSearcher indexSearcher;
    private static IndexWriter indexWriter;
    private static final Analyzer analyzer;
    private volatile boolean isEnabled = false;
    private String tableName;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> columnTypes = new ArrayList<String>();
    private int dbColumn = -1;
    private final List<Integer> indexColumns = new ArrayList<Integer>();
    private final List<TableUpdate> tableUpdates = new ArrayList<TableUpdate>();

    public static void setActive(boolean bl) {
        if (Constants.DISABLE_FULL_TEXT_SEARCH) {
            return;
        }
        isActive = bl;
        if (!bl) {
            indexTriggers.values().forEach(fullTextTrigger -> {
                fullTextTrigger.isEnabled = false;
            });
            indexTriggers.clear();
            FullTextTrigger.removeIndexAccess();
        }
    }

    public static void init() {
        if (Constants.DISABLE_FULL_TEXT_SEARCH) {
            return;
        }
        String string = FullTextTrigger.class.getName();
        try (Connection connection = Db.db.getConnection();
             Statement statement = connection.createStatement();
             Statement statement2 = connection.createStatement();){
            boolean bl = true;
            boolean bl2 = false;
            try (ResultSet resultSet = statement2.executeQuery("SELECT JAVA_CLASS FROM INFORMATION_SCHEMA.TRIGGERS WHERE SUBSTRING(TRIGGER_NAME, 0, 4) = 'FTL_'");){
                while (resultSet.next()) {
                    bl2 = true;
                    if (resultSet.getString(1).startsWith(string)) continue;
                    bl = false;
                }
            }
            if (bl2 && bl) {
                Logger.logInfoMessage("NRS fulltext support is already initialized");
                return;
            }
            FullTextTrigger.getIndexPath(connection);
            FullTextTrigger.removeIndexFiles(connection);
            statement.execute("DROP ALIAS IF EXISTS FTL_INIT");
            statement.execute("DROP ALIAS IF EXISTS FTL_CREATE_INDEX");
            statement.execute("DROP ALIAS IF EXISTS FTL_DROP_INDEX");
            statement.execute("DROP ALIAS IF EXISTS FTL_DROP_ALL");
            statement.execute("DROP ALIAS IF EXISTS FTL_REINDEX");
            statement.execute("DROP ALIAS IF EXISTS FTL_SEARCH");
            statement.execute("DROP ALIAS IF EXISTS FTL_SEARCH_DATA");
            Logger.logInfoMessage("H2 fulltext function aliases dropped");
            statement.execute("CREATE SCHEMA IF NOT EXISTS FTL");
            statement.execute("CREATE TABLE IF NOT EXISTS FTL.INDEXES (SCHEMA VARCHAR, `TABLE` VARCHAR, COLUMNS VARCHAR, PRIMARY KEY(SCHEMA, `TABLE`))");
            Logger.logInfoMessage("NRS fulltext schema created");
            resultSet = statement2.executeQuery("SELECT * FROM FTL.INDEXES");
            var10_20 = null;
            try {
                while (resultSet.next()) {
                    String string2 = resultSet.getString("SCHEMA");
                    String string3 = resultSet.getString("TABLE");
                    statement.execute("DROP TRIGGER IF EXISTS FTL_" + string3);
                    statement.execute(String.format("CREATE TRIGGER FTL_%s AFTER INSERT,UPDATE,DELETE ON %s.%s FOR EACH ROW CALL \"%s\"", string3, string2, string3, string));
                }
            }
            catch (Throwable throwable) {
                var10_20 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var10_20 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var10_20.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
            FullTextTrigger.reindex(connection);
            statement.execute("CREATE ALIAS FTL_CREATE_INDEX FOR \"" + string + ".createIndex\"");
            statement.execute("CREATE ALIAS FTL_DROP_INDEX FOR \"" + string + ".dropIndex\"");
            statement.execute("CREATE ALIAS FTL_SEARCH NOBUFFER FOR \"" + string + ".search\"");
            Logger.logInfoMessage("NRS fulltext aliases created");
        }
        catch (SQLException sQLException) {
            Logger.logErrorMessage("Unable to initialize NRS fulltext search support", sQLException);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static void reindex(Connection connection) throws SQLException {
        Logger.logInfoMessage("Rebuilding the Lucene search index");
        try {
            FullTextTrigger.removeIndexFiles(connection);
            for (FullTextTrigger fullTextTrigger : indexTriggers.values()) {
                fullTextTrigger.reindexTable(connection);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Unable to rebuild the Lucene index", sQLException);
        }
        Logger.logInfoMessage("Lucene search index successfully rebuilt");
    }

    public static void createIndex(Connection connection, String string, String string2, String string3) throws SQLException {
        if (Constants.DISABLE_FULL_TEXT_SEARCH) {
            return;
        }
        String string4 = string.toUpperCase(Locale.ROOT);
        String string5 = string2.toUpperCase(Locale.ROOT);
        String string6 = string4 + "." + string5;
        FullTextTrigger.getIndexAccess(connection);
        FullTextTrigger.dropIndex(connection, string, string2);
        try (Object object = connection.createStatement();){
            object.execute(String.format("INSERT INTO FTL.INDEXES (schema, `table`, columns) VALUES('%s', '%s', '%s')", string4, string5, string3.toUpperCase(Locale.ROOT)));
            object.execute(String.format("CREATE TRIGGER FTL_%s AFTER INSERT,UPDATE,DELETE ON %s FOR EACH ROW CALL \"%s\"", string5, string6, FullTextTrigger.class.getName()));
        }
        object = indexTriggers.get(string6);
        if (object == null) {
            Logger.logErrorMessage("NRS fulltext trigger for table " + string6 + " was not initialized");
        } else {
            try {
                super.reindexTable(connection);
                Logger.logInfoMessage("Lucene search index created for table " + string6);
            }
            catch (SQLException sQLException) {
                Logger.logErrorMessage("Unable to create Lucene search index for table " + string6);
                throw new SQLException("Unable to create Lucene search index for table " + string6, sQLException);
            }
        }
    }

    public static void dropIndex(Connection connection, String string, String string2) throws SQLException {
        String string3 = string.toUpperCase(Locale.ROOT);
        String string4 = string2.toUpperCase(Locale.ROOT);
        boolean bl = false;
        try (Statement statement = connection.createStatement();
             Statement statement2 = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("SELECT COLUMNS FROM FTL.INDEXES WHERE SCHEMA = '%s' AND `TABLE` = '%s'", string3, string4));){
            if (resultSet.next()) {
                statement2.execute("DROP TRIGGER IF EXISTS FTL_" + string4);
                statement2.execute(String.format("DELETE FROM FTL.INDEXES WHERE SCHEMA = '%s' AND `TABLE` = '%s'", string3, string4));
                bl = true;
            }
        }
        if (bl) {
            FullTextTrigger.reindex(connection);
        }
    }

    public static void dropAll(Connection connection) throws SQLException {
        if (Constants.DISABLE_FULL_TEXT_SEARCH) {
            return;
        }
        try (Statement statement = connection.createStatement();
             Statement statement2 = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT `TABLE` FROM FTL.INDEXES");){
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                statement2.execute("DROP TRIGGER IF EXISTS FTL_" + string);
            }
            statement2.execute("TRUNCATE TABLE FTL.INDEXES");
            indexTriggers.clear();
        }
        FullTextTrigger.removeIndexFiles(connection);
    }

    public static ResultSet search(Connection connection, String string, String string2, String string3, int n, int n2) throws SQLException {
        FullTextTrigger.getIndexAccess(connection);
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.addColumn("SCHEMA", 12, 0, 0);
        simpleResultSet.addColumn("TABLE", 12, 0, 0);
        simpleResultSet.addColumn("COLUMNS", 2003, 0, 0);
        simpleResultSet.addColumn("KEYS", 2003, 0, 0);
        simpleResultSet.addColumn("SCORE", 6, 0, 0);
        indexLock.readLock().lock();
        try {
            int n3;
            QueryParser queryParser = new QueryParser("_DATA", analyzer);
            queryParser.setDateResolution("_MODIFIED", DateTools.Resolution.SECOND);
            queryParser.setDefaultOperator(QueryParser.Operator.AND);
            Query query = queryParser.parse("_TABLE:" + string.toUpperCase(Locale.ROOT) + "." + string2.toUpperCase(Locale.ROOT) + " AND (" + string3 + ")");
            TopDocs topDocs = indexSearcher.search(query, n);
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            int n4 = Math.min(scoreDocArray.length, n == 0 ? scoreDocArray.length : n);
            for (int i = n3 = Math.min(n2, n4); i < n4; ++i) {
                Document document = indexSearcher.doc(scoreDocArray[i].doc);
                String[] stringArray = document.get("_QUERY").split(";");
                String[] stringArray2 = stringArray[0].split("\\.");
                simpleResultSet.addRow(new Object[]{stringArray2[0], stringArray2[1], new String[]{stringArray[1]}, new Long[]{Long.parseLong(stringArray[2])}, Float.valueOf(scoreDocArray[i].score)});
            }
        }
        catch (ParseException parseException) {
            Logger.logDebugMessage("Lucene parse exception for query: " + string3 + "\n" + parseException.getMessage());
            throw new SQLException("Lucene parse exception for query: " + string3 + "\n" + parseException.getMessage());
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("Unable to search Lucene index", iOException);
            throw new SQLException("Unable to search Lucene index", iOException);
        }
        finally {
            indexLock.readLock().unlock();
        }
        return simpleResultSet;
    }

    public void init(Connection connection, String string, String string2, String string3, boolean bl, int n) throws SQLException {
        if (!isActive || string3.contains("_COPY_")) {
            return;
        }
        FullTextTrigger.getIndexAccess(connection);
        this.tableName = string + "." + string3;
        try (Statement statement = connection.createStatement();){
            try (ResultSet resultSet = statement.executeQuery("SHOW COLUMNS FROM " + string3 + " FROM " + string);){
                int n2 = 0;
                while (resultSet.next()) {
                    String[] stringArray = resultSet.getString("FIELD");
                    String string4 = resultSet.getString("TYPE");
                    string4 = string4.substring(0, string4.indexOf(40));
                    this.columnNames.add((String)stringArray);
                    this.columnTypes.add(string4);
                    if (stringArray.equals("DB_ID")) {
                        this.dbColumn = n2;
                    }
                    ++n2;
                }
            }
            if (this.dbColumn < 0) {
                Logger.logErrorMessage("DB_ID column not found for table " + this.tableName);
                return;
            }
            resultSet = statement.executeQuery(String.format("SELECT COLUMNS FROM FTL.INDEXES WHERE SCHEMA = '%s' AND `TABLE` = '%s'", string, string3));
            var10_15 = null;
            try {
                if (resultSet.next()) {
                    String[] stringArray;
                    for (String string5 : stringArray = resultSet.getString(1).split(",")) {
                        int n3 = this.columnNames.indexOf(string5);
                        if (n3 >= 0) {
                            if (this.columnTypes.get(n3).equals("VARCHAR")) {
                                this.indexColumns.add(n3);
                                continue;
                            }
                            Logger.logErrorMessage("Indexed column " + string5 + " in table " + this.tableName + " is not a string");
                            continue;
                        }
                        Logger.logErrorMessage("Indexed column " + string5 + " not found in table " + this.tableName);
                    }
                }
            }
            catch (Throwable throwable) {
                var10_15 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var10_15 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var10_15.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
            if (this.indexColumns.isEmpty()) {
                Logger.logErrorMessage("No indexed columns found for table " + this.tableName);
                return;
            }
            this.isEnabled = true;
            indexTriggers.put(this.tableName, this);
        }
        catch (SQLException sQLException) {
            Logger.logErrorMessage("Unable to get table information", sQLException);
        }
    }

    public void close() {
        if (this.isEnabled) {
            this.isEnabled = false;
            indexTriggers.remove(this.tableName);
        }
    }

    public void remove() {
        if (this.isEnabled) {
            this.isEnabled = false;
            indexTriggers.remove(this.tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(Connection connection, Object[] objectArray, Object[] objectArray2) {
        if (!this.isEnabled) {
            return;
        }
        if (!Db.db.isInTransaction()) {
            try {
                this.commitRow(objectArray, objectArray2);
                FullTextTrigger.commitIndex();
            }
            catch (SQLException sQLException) {
                Logger.logErrorMessage("Unable to update the Lucene index", sQLException);
            }
            return;
        }
        List<TableUpdate> list = this.tableUpdates;
        synchronized (list) {
            this.tableUpdates.add(new TableUpdate(Thread.currentThread(), objectArray, objectArray2));
        }
        Db.db.registerCallback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        Thread thread = Thread.currentThread();
        try {
            boolean bl = false;
            List<TableUpdate> list = this.tableUpdates;
            synchronized (list) {
                Iterator<TableUpdate> iterator = this.tableUpdates.iterator();
                while (iterator.hasNext()) {
                    TableUpdate tableUpdate = iterator.next();
                    if (tableUpdate.getThread() != thread) continue;
                    this.commitRow(tableUpdate.getOldRow(), tableUpdate.getNewRow());
                    iterator.remove();
                    bl = true;
                }
            }
            if (bl) {
                FullTextTrigger.commitIndex();
            }
        }
        catch (SQLException sQLException) {
            Logger.logErrorMessage("Unable to update the Lucene index", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Thread thread = Thread.currentThread();
        List<TableUpdate> list = this.tableUpdates;
        synchronized (list) {
            this.tableUpdates.removeIf(tableUpdate -> tableUpdate.getThread() == thread);
        }
    }

    private void commitRow(Object[] objectArray, Object[] objectArray2) throws SQLException {
        if (objectArray != null) {
            if (objectArray2 != null) {
                this.indexRow(objectArray2);
            } else {
                this.deleteRow(objectArray);
            }
        } else if (objectArray2 != null) {
            this.indexRow(objectArray2);
        }
    }

    private void reindexTable(Connection connection) throws SQLException {
        if (this.indexColumns.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT DB_ID");
        Object[] objectArray = this.indexColumns.iterator();
        while (objectArray.hasNext()) {
            int n = objectArray.next();
            stringBuilder.append(", ").append(this.columnNames.get(n));
        }
        stringBuilder.append(" FROM ").append(this.tableName);
        objectArray = new Object[this.columnNames.size()];
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(stringBuilder.toString());){
            while (resultSet.next()) {
                objectArray[this.dbColumn] = resultSet.getObject(1);
                int n = 2;
                for (int n2 : this.indexColumns) {
                    objectArray[n2] = resultSet.getObject(n++);
                }
                this.indexRow(objectArray);
            }
        }
        FullTextTrigger.commitIndex();
    }

    private void indexRow(Object[] objectArray) throws SQLException {
        indexLock.readLock().lock();
        try {
            String string = this.tableName + ";" + this.columnNames.get(this.dbColumn) + ";" + (Long)objectArray[this.dbColumn];
            Document document = new Document();
            document.add((IndexableField)new StringField("_QUERY", string, Field.Store.YES));
            long l = System.currentTimeMillis();
            document.add((IndexableField)new TextField("_MODIFIED", DateTools.timeToString((long)l, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.NO));
            document.add((IndexableField)new TextField("_TABLE", this.tableName, Field.Store.NO));
            StringJoiner stringJoiner = new StringJoiner(" ");
            for (int n : this.indexColumns) {
                String string2 = objectArray[n] != null ? (String)objectArray[n] : "NULL";
                document.add((IndexableField)new TextField(this.columnNames.get(n), string2, Field.Store.NO));
                stringJoiner.add(string2);
            }
            document.add((IndexableField)new TextField("_DATA", stringJoiner.toString(), Field.Store.NO));
            indexWriter.updateDocument(new Term("_QUERY", string), (Iterable)document);
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("Unable to index row", iOException);
            throw new SQLException("Unable to index row", iOException);
        }
        finally {
            indexLock.readLock().unlock();
        }
    }

    private void deleteRow(Object[] objectArray) throws SQLException {
        String string = this.tableName + ";" + this.columnNames.get(this.dbColumn) + ";" + (Long)objectArray[this.dbColumn];
        indexLock.readLock().lock();
        try {
            indexWriter.deleteDocuments(new Term[]{new Term("_QUERY", string)});
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("Unable to delete indexed row", iOException);
            throw new SQLException("Unable to delete indexed row", iOException);
        }
        finally {
            indexLock.readLock().unlock();
        }
    }

    private static void commitIndex() throws SQLException {
        indexLock.writeLock().lock();
        try {
            indexWriter.commit();
            DirectoryReader directoryReader = DirectoryReader.openIfChanged((DirectoryReader)indexReader);
            if (directoryReader != null) {
                indexReader.close();
                indexReader = directoryReader;
                indexSearcher = new IndexSearcher((IndexReader)indexReader);
            }
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("Unable to commit Lucene index updates", iOException);
            throw new SQLException("Unable to commit Lucene index updates", iOException);
        }
        finally {
            indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getIndexPath(Connection connection) throws SQLException {
        block30: {
            indexLock.writeLock().lock();
            try {
                if (indexPath != null) break block30;
                try (Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery("CALL DATABASE_PATH()");){
                    resultSet.next();
                    indexPath = fileSystem.getPath(resultSet.getString(1), new String[0]);
                    if (!Files.exists(indexPath, new LinkOption[0])) {
                        Files.createDirectory(indexPath, new FileAttribute[0]);
                    }
                }
                catch (IOException iOException) {
                    Logger.logErrorMessage("Unable to create the Lucene index directory", iOException);
                    throw new SQLException("Unable to create the Lucene index directory", iOException);
                }
            }
            finally {
                indexLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getIndexAccess(Connection connection) throws SQLException {
        block17: {
            if (Constants.DISABLE_FULL_TEXT_SEARCH) {
                return;
            }
            if (!isActive) {
                throw new SQLException("NRS is no longer active");
            }
            boolean bl = false;
            if (!indexLock.writeLock().hasLock()) {
                indexLock.updateLock().lock();
                bl = true;
            }
            try {
                if (indexPath != null && indexWriter != null) break block17;
                indexLock.writeLock().lock();
                try {
                    if (indexPath == null) {
                        FullTextTrigger.getIndexPath(connection);
                    }
                    if (directory == null) {
                        try {
                            directory = (Directory)FSDirectory.class.getMethod("open", Path.class).invoke(null, indexPath);
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            throw new RuntimeException("FSDirectory.open cannot be invoket", reflectiveOperationException);
                        }
                    }
                    if (indexWriter == null) {
                        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(analyzer);
                        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                        indexWriter = new IndexWriter(directory, indexWriterConfig);
                        Document document = new Document();
                        document.add((IndexableField)new StringField("_QUERY", "_CONTROL_DOCUMENT_", Field.Store.YES));
                        indexWriter.updateDocument(new Term("_QUERY", "_CONTROL_DOCUMENT_"), (Iterable)document);
                        indexWriter.commit();
                        indexReader = DirectoryReader.open((Directory)directory);
                        indexSearcher = new IndexSearcher((IndexReader)indexReader);
                    }
                }
                finally {
                    indexLock.writeLock().unlock();
                }
            }
            catch (IOException | SQLException exception) {
                Logger.logErrorMessage("Unable to access the Lucene index", exception);
                throw new SQLException("Unable to access the Lucene index", exception);
            }
            finally {
                if (bl) {
                    indexLock.updateLock().unlock();
                }
            }
        }
    }

    private static void removeIndexAccess() {
        indexLock.writeLock().lock();
        try {
            if (indexSearcher != null) {
                indexSearcher = null;
            }
            if (indexReader != null) {
                indexReader.close();
                indexReader = null;
            }
            if (indexWriter != null) {
                indexWriter.close();
                indexWriter = null;
            }
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("Unable to remove Lucene index access", iOException);
        }
        finally {
            indexLock.writeLock().unlock();
        }
    }

    private static void removeIndexFiles(Connection connection) throws SQLException {
        indexLock.writeLock().lock();
        try {
            FullTextTrigger.removeIndexAccess();
            FullTextTrigger.getIndexPath(connection);
            try (Stream<Path> stream = Files.list(indexPath);){
                Path[] pathArray;
                for (Path path : pathArray = (Path[])stream.toArray(Path[]::new)) {
                    Files.delete(path);
                }
            }
            Logger.logInfoMessage("Lucene search index deleted");
            FullTextTrigger.getIndexAccess(connection);
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("Unable to remove Lucene index files", iOException);
            throw new SQLException("Unable to remove Lucene index files", iOException);
        }
        finally {
            indexLock.writeLock().unlock();
        }
    }

    static {
        analyzer = new StandardAnalyzer();
    }

    private static class TableUpdate {
        private final Thread thread;
        private final Object[] oldRow;
        private final Object[] newRow;

        public TableUpdate(Thread thread, Object[] objectArray, Object[] objectArray2) {
            this.thread = thread;
            this.oldRow = objectArray;
            this.newRow = objectArray2;
        }

        public Thread getThread() {
            return this.thread;
        }

        public Object[] getOldRow() {
            return this.oldRow;
        }

        public Object[] getNewRow() {
            return this.newRow;
        }
    }
}

