/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Currency;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class CurrencySell
extends CreateTransaction {
    static final CurrencySell instance = new CurrencySell();

    private CurrencySell() {
        super(new APITag[]{APITag.MS, APITag.CREATE_TRANSACTION}, "currency", "rateNQT", "units");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Currency currency = ParameterParser.getCurrency(httpServletRequest);
        long l = ParameterParser.getLong(httpServletRequest, "rateNQT", 0L, Long.MAX_VALUE, true);
        long l2 = ParameterParser.getLong(httpServletRequest, "units", 0L, Long.MAX_VALUE, true);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.MonetarySystemExchangeSell monetarySystemExchangeSell = new Attachment.MonetarySystemExchangeSell(currency.getId(), l, l2);
        try {
            return this.createTransaction(httpServletRequest, account, monetarySystemExchangeSell);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_CURRENCY;
        }
    }
}

