/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.DigitalGoodsStore;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class DGSQuantityChange
extends CreateTransaction {
    static final DGSQuantityChange instance = new DGSQuantityChange();

    private DGSQuantityChange() {
        super(new APITag[]{APITag.DGS, APITag.CREATE_TRANSACTION}, "goods", "deltaQuantity");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n;
        Object object;
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        DigitalGoodsStore.Goods goods = ParameterParser.getGoods(httpServletRequest);
        if (goods.isDelisted() || goods.getSellerId() != account.getId()) {
            return JSONResponses.UNKNOWN_GOODS;
        }
        try {
            object = Convert.emptyToNull(httpServletRequest.getParameter("deltaQuantity"));
            if (object == null) {
                return JSONResponses.MISSING_DELTA_QUANTITY;
            }
            n = Integer.parseInt((String)object);
            if (n > 1000000000 || n < -1000000000) {
                return JSONResponses.INCORRECT_DELTA_QUANTITY;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return JSONResponses.INCORRECT_DELTA_QUANTITY;
        }
        object = new Attachment.DigitalGoodsQuantityChange(goods.getId(), n);
        return this.createTransaction(httpServletRequest, account, (Attachment)object);
    }
}

