/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Shuffler;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetShufflers
extends APIServlet.APIRequestHandler {
    static final GetShufflers instance = new GetShufflers();

    private GetShufflers() {
        super(new APITag[]{APITag.SHUFFLING}, "account", "shufflingFullHash", "secretPhrase", "adminPassword", "includeParticipantState");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        List<Object> list;
        Shuffler shuffler2;
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "shufflingFullHash", false);
        long l = ParameterParser.getAccountId(httpServletRequest, false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeParticipantState"));
        if (string != null) {
            if (l != 0L && Account.getId(Crypto.getPublicKey(string)) != l) {
                return JSONResponses.INCORRECT_ACCOUNT;
            }
            l = Account.getId(Crypto.getPublicKey(string));
            list = byArray.length == 0 ? Shuffler.getAccountShufflers(l) : ((shuffler2 = Shuffler.getShuffler(l, byArray)) == null ? Collections.emptyList() : Collections.singletonList(shuffler2));
        } else {
            API.verifyPassword(httpServletRequest);
            list = l != 0L && byArray.length == 0 ? Shuffler.getAccountShufflers(l) : (l == 0L && byArray.length > 0 ? Shuffler.getShufflingShufflers(byArray) : (l != 0L && byArray.length > 0 ? ((shuffler2 = Shuffler.getShuffler(l, byArray)) == null ? Collections.emptyList() : Collections.singletonList(shuffler2)) : Shuffler.getAllShufflers()));
        }
        shuffler2 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        list.forEach(shuffler -> jSONArray.add((Object)JSONData.shuffler(shuffler, bl)));
        shuffler2.put("shufflers", jSONArray);
        return shuffler2;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

