/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class ParseTransaction
extends APIServlet.APIRequestHandler {
    static final ParseTransaction instance = new ParseTransaction();

    private ParseTransaction() {
        super(new APITag[]{APITag.TRANSACTIONS}, "transactionJSON", "transactionBytes", "prunableAttachmentJSON");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("transactionBytes"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("transactionJSON"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("prunableAttachmentJSON"));
        Transaction transaction = ParameterParser.parseTransaction(string2, string, string3).build();
        JSONObject jSONObject = JSONData.unconfirmedTransaction(transaction);
        try {
            transaction.validate();
        }
        catch (RuntimeException | NxtException.ValidationException exception) {
            Logger.logDebugMessage(exception.getMessage(), exception);
            jSONObject.put((Object)"validate", (Object)false);
            JSONData.putException(jSONObject, exception, "Invalid transaction");
        }
        jSONObject.put((Object)"verify", (Object)transaction.verifySignature());
        return jSONObject;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }
}

