/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class SetAccountProperty
extends CreateTransaction {
    static final SetAccountProperty instance = new SetAccountProperty();

    private SetAccountProperty() {
        super(new APITag[]{APITag.ACCOUNTS, APITag.CREATE_TRANSACTION}, "recipient", "property", "value");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        long l = ParameterParser.getAccountId(httpServletRequest, "recipient", false);
        if (l == 0L) {
            l = account.getId();
        }
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("property")).trim();
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("value")).trim();
        if (string.length() > 32 || string.length() == 0) {
            return JSONResponses.INCORRECT_ACCOUNT_PROPERTY_NAME_LENGTH;
        }
        if (string2.length() > 160) {
            return JSONResponses.INCORRECT_ACCOUNT_PROPERTY_VALUE_LENGTH;
        }
        Attachment.MessagingAccountProperty messagingAccountProperty = new Attachment.MessagingAccountProperty(string, string2);
        return this.createTransaction(httpServletRequest, account, l, 0L, messagingAccountProperty);
    }
}

