/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.peer.Peers;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class SetLogging
extends APIServlet.APIRequestHandler {
    static final SetLogging instance = new SetLogging();
    private static final JSONStreamAware LOGGING_UPDATED;
    private static final JSONStreamAware INCORRECT_LEVEL;
    private static final JSONStreamAware INCORRECT_EVENT;

    private SetLogging() {
        super(new APITag[]{APITag.DEBUG}, "logLevel", "communicationEvent", "communicationEvent", "communicationEvent");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String[] stringArray;
        JSONStreamAware jSONStreamAware = null;
        String[] stringArray2 = httpServletRequest.getParameter("logLevel");
        if (stringArray2 != null) {
            switch (stringArray2) {
                case "DEBUG": {
                    Logger.setLevel(Logger.Level.DEBUG);
                    break;
                }
                case "INFO": {
                    Logger.setLevel(Logger.Level.INFO);
                    break;
                }
                case "WARN": {
                    Logger.setLevel(Logger.Level.WARN);
                    break;
                }
                case "ERROR": {
                    Logger.setLevel(Logger.Level.ERROR);
                    break;
                }
                default: {
                    jSONStreamAware = INCORRECT_LEVEL;
                    break;
                }
            }
        } else {
            Logger.setLevel(Logger.Level.INFO);
        }
        if (jSONStreamAware == null && !Peers.setCommunicationLoggingMask(stringArray = httpServletRequest.getParameterValues("communicationEvent"))) {
            jSONStreamAware = INCORRECT_EVENT;
        }
        if (jSONStreamAware == null) {
            jSONStreamAware = LOGGING_UPDATED;
        }
        return jSONStreamAware;
    }

    @Override
    protected boolean requirePassword() {
        return true;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    static {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"loggingUpdated", (Object)true);
        LOGGING_UPDATED = JSON.prepare(jSONObject);
        INCORRECT_LEVEL = JSONResponses.incorrect("logLevel", "Log level must be DEBUG, INFO, WARN or ERROR");
        INCORRECT_EVENT = JSONResponses.incorrect("communicationEvent", "Communication event must be EXCEPTION, HTTP-ERROR or HTTP-OK");
    }
}

